/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.common.logging.impl;

import java.io.Serializable;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Locale;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.hibernate.search.util.common.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.TypeFormatter;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String interruptedWorkError = "HSEARCH000017: Work discarded, thread was interrupted while waiting for space to schedule: %1$s";
    private static final String exceptionOccurred = "HSEARCH000058: %1$s";
    private static final String mustNotBeNull = "HSEARCH900000: '%1$s' must not be null.";
    private static final String collectionMustNotBeNullNorEmpty = "HSEARCH900001: '%1$s' must not be null or empty.";
    private static final String mustBePositiveOrZero = "HSEARCH900002: '%1$s' must be positive or zero.";
    private static final String stringMustNotBeNullNorEmpty = "HSEARCH900003: '%1$s' must not be null or empty.";
    private static final String arrayMustNotBeNullNorEmpty = "HSEARCH900004: '%1$s' must not be null or empty.";
    private static final String errorInvokingMember = "HSEARCH900005: Exception while invoking '%1$s' on '%2$s'.";
    private static final String cannotRequestTypeParameterOfUnparameterizedType = "HSEARCH900006: Requested type argument %3$s to type %2$s in implementing type %1$s, but %2$s doesn't declare any type parameter";
    private static final String typeParameterIndexOutOfBound = "HSEARCH900007: Requested type argument %3$s to type %2$s in implementing type %1$s, but %2$s only declares %4$s type parameter(s)";
    private static final String invalidTypeParameterIndex = "HSEARCH900008: Requested type argument index %3$s to type %2$s in implementing type %1$s should be 0 or greater";
    private static final String cannotAccessRepeateableContainingAnnotationValue = "HSEARCH900009: Cannot access the value of containing annotation '%1$s'. Ignoring annotation.";
    private static final String mustBeStrictlyPositive = "HSEARCH900010: '%1$s' must be strictly positive.";

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void interruptedWorkError(Runnable r) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.interruptedWorkError$str(), (Object)r);
    }

    protected String interruptedWorkError$str() {
        return interruptedWorkError;
    }

    @Override
    public final void exceptionOccurred(String errorMsg, Throwable exceptionThatOccurred) {
        this.log.logf(FQCN, Logger.Level.ERROR, exceptionThatOccurred, this.exceptionOccurred$str(), (Object)errorMsg);
    }

    protected String exceptionOccurred$str() {
        return exceptionOccurred;
    }

    protected String mustNotBeNull$str() {
        return mustNotBeNull;
    }

    @Override
    public final IllegalArgumentException mustNotBeNull(String objectDescription) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.mustNotBeNull$str(), objectDescription));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String collectionMustNotBeNullNorEmpty$str() {
        return collectionMustNotBeNullNorEmpty;
    }

    @Override
    public final IllegalArgumentException collectionMustNotBeNullNorEmpty(String objectDescription) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.collectionMustNotBeNullNorEmpty$str(), objectDescription));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mustBePositiveOrZero$str() {
        return mustBePositiveOrZero;
    }

    @Override
    public final IllegalArgumentException mustBePositiveOrZero(String objectDescription) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.mustBePositiveOrZero$str(), objectDescription));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String stringMustNotBeNullNorEmpty$str() {
        return stringMustNotBeNullNorEmpty;
    }

    @Override
    public final IllegalArgumentException stringMustNotBeNullNorEmpty(String objectDescription) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.stringMustNotBeNullNorEmpty$str(), objectDescription));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String arrayMustNotBeNullNorEmpty$str() {
        return arrayMustNotBeNullNorEmpty;
    }

    @Override
    public final IllegalArgumentException arrayMustNotBeNullNorEmpty(String objectDescription) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.arrayMustNotBeNullNorEmpty$str(), objectDescription));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorInvokingMember$str() {
        return errorInvokingMember;
    }

    @Override
    public final SearchException errorInvokingMember(Member member, Object component, Throwable e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.errorInvokingMember$str(), member, component), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotRequestTypeParameterOfUnparameterizedType$str() {
        return cannotRequestTypeParameterOfUnparameterizedType;
    }

    @Override
    public final IllegalArgumentException cannotRequestTypeParameterOfUnparameterizedType(Type type, Class<?> rawSuperType, int typeArgumentIndex) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.cannotRequestTypeParameterOfUnparameterizedType$str(), new TypeFormatter(type), new ClassFormatter(rawSuperType), typeArgumentIndex));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String typeParameterIndexOutOfBound$str() {
        return typeParameterIndexOutOfBound;
    }

    @Override
    public final IllegalArgumentException typeParameterIndexOutOfBound(Type type, Class<?> rawSuperType, int typeArgumentIndex, int typeParametersLength) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.typeParameterIndexOutOfBound$str(), new TypeFormatter(type), new ClassFormatter(rawSuperType), typeArgumentIndex, typeParametersLength));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidTypeParameterIndex$str() {
        return invalidTypeParameterIndex;
    }

    @Override
    public final IllegalArgumentException invalidTypeParameterIndex(Type type, Class<?> rawSuperType, int typeArgumentIndex) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidTypeParameterIndex$str(), new TypeFormatter(type), new ClassFormatter(rawSuperType), typeArgumentIndex));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void cannotAccessRepeateableContainingAnnotationValue(Class<?> containingAnnotationType, Throwable e) {
        this.log.logf(FQCN, Logger.Level.INFO, e, this.cannotAccessRepeateableContainingAnnotationValue$str(), (Object)new ClassFormatter(containingAnnotationType));
    }

    protected String cannotAccessRepeateableContainingAnnotationValue$str() {
        return cannotAccessRepeateableContainingAnnotationValue;
    }

    protected String mustBeStrictlyPositive$str() {
        return mustBeStrictlyPositive;
    }

    @Override
    public final IllegalArgumentException mustBeStrictlyPositive(String objectDescription) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.mustBeStrictlyPositive$str(), objectDescription));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

