/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.processing.impl;

import java.util.Collection;
import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.mapper.pojo.bridge.PropertyBridge;
import org.hibernate.search.mapper.pojo.processing.impl.PojoIndexingProcessor;
import org.hibernate.search.mapper.pojo.session.context.spi.AbstractPojoBackendSessionContext;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.ToStringTreeBuilder;
import org.hibernate.search.util.common.reflect.spi.ValueReadHandle;

public class PojoIndexingProcessorPropertyNode<T, P>
extends PojoIndexingProcessor<T> {
    private final ValueReadHandle<P> handle;
    private final Collection<BeanHolder<? extends PropertyBridge>> propertyBridgeHolders;
    private final Collection<PojoIndexingProcessor<? super P>> nestedNodes;

    public PojoIndexingProcessorPropertyNode(ValueReadHandle<P> handle, Collection<BeanHolder<? extends PropertyBridge>> propertyBridgeHolders, Collection<PojoIndexingProcessor<? super P>> nestedNodes) {
        this.handle = handle;
        this.propertyBridgeHolders = propertyBridgeHolders;
        this.nestedNodes = nestedNodes;
    }

    @Override
    public void close() {
        try (Closer closer = new Closer();){
            closer.pushAll(holder -> ((PropertyBridge)holder.get()).close(), this.propertyBridgeHolders);
            closer.pushAll(BeanHolder::close, this.propertyBridgeHolders);
            closer.pushAll(PojoIndexingProcessor::close, this.nestedNodes);
        }
    }

    public void appendTo(ToStringTreeBuilder builder) {
        builder.attribute("class", (Object)this.getClass().getSimpleName());
        builder.attribute("handle", this.handle);
        builder.startList("bridges");
        for (BeanHolder<? extends PropertyBridge> beanHolder : this.propertyBridgeHolders) {
            builder.value(beanHolder.get());
        }
        builder.endList();
        builder.startList("nestedNodes");
        for (PojoIndexingProcessor pojoIndexingProcessor : this.nestedNodes) {
            builder.value((Object)pojoIndexingProcessor);
        }
        builder.endList();
    }

    @Override
    public final void process(DocumentElement target, T source, AbstractPojoBackendSessionContext sessionContext) {
        Object propertyValue = this.handle.get(source);
        for (BeanHolder<? extends PropertyBridge> beanHolder : this.propertyBridgeHolders) {
            ((PropertyBridge)beanHolder.get()).write(target, propertyValue, sessionContext.getPropertyBridgeWriteContext());
        }
        for (PojoIndexingProcessor pojoIndexingProcessor : this.nestedNodes) {
            pojoIndexingProcessor.process(target, propertyValue, sessionContext);
        }
    }
}

