/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.processing.building.impl;

import org.hibernate.search.engine.mapper.mapping.building.spi.IndexBindingContext;
import org.hibernate.search.engine.reporting.spi.ContextualFailureCollector;
import org.hibernate.search.mapper.pojo.mapping.building.impl.PojoMappingHelper;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPath;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPath;
import org.hibernate.search.mapper.pojo.reporting.impl.PojoEventContexts;

abstract class AbstractPojoProcessorNodeBuilder {
    final PojoMappingHelper mappingHelper;
    final IndexBindingContext bindingContext;

    AbstractPojoProcessorNodeBuilder(PojoMappingHelper mappingHelper, IndexBindingContext bindingContext) {
        this.mappingHelper = mappingHelper;
        this.bindingContext = bindingContext;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getModelPath() + "]";
    }

    abstract BoundPojoModelPath getModelPath();

    abstract void closeOnFailure();

    public final ContextualFailureCollector getFailureCollector() {
        BoundPojoModelPath modelPath = this.getModelPath();
        ContextualFailureCollector failureCollector = this.mappingHelper.getFailureCollector().withContext(PojoEventContexts.fromType(modelPath.getRootType().getRawType()));
        PojoModelPath unboundPath = modelPath.toUnboundPath();
        if (unboundPath != null) {
            failureCollector = failureCollector.withContext(PojoEventContexts.fromPath(modelPath.toUnboundPath()));
        }
        return failureCollector;
    }
}

