/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.model.additionalmetadata.building.impl;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.engine.reporting.spi.ContextualFailureCollector;
import org.hibernate.search.mapper.pojo.automaticindexing.ReindexOnUpdate;
import org.hibernate.search.mapper.pojo.extractor.mapping.programmatic.ContainerExtractorPath;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.building.impl.PojoTypeAdditionalMetadataBuilder;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.building.spi.PojoAdditionalMetadataCollectorValueNode;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.impl.PojoValueAdditionalMetadata;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPath;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.reporting.impl.PojoEventContexts;

class PojoValueAdditionalMetadataBuilder
implements PojoAdditionalMetadataCollectorValueNode {
    private final PojoTypeAdditionalMetadataBuilder rootBuilder;
    private final String propertyName;
    private final ContainerExtractorPath extractorPath;
    private PojoModelPathValueNode inverseSidePath;
    private boolean associationEmbedded = false;
    private Optional<ReindexOnUpdate> reindexOnUpdate = Optional.empty();
    private Set<PojoModelPathValueNode> derivedFrom = Collections.emptySet();
    private Integer decimalScale;

    PojoValueAdditionalMetadataBuilder(PojoTypeAdditionalMetadataBuilder rootBuilder, String propertyName, ContainerExtractorPath extractorPath) {
        this.rootBuilder = rootBuilder;
        this.propertyName = propertyName;
        this.extractorPath = extractorPath;
    }

    @Override
    public ContextualFailureCollector getFailureCollector() {
        return this.rootBuilder.getFailureCollector().withContext(PojoEventContexts.fromPath(PojoModelPath.ofValue(this.propertyName, this.extractorPath)));
    }

    @Override
    public void associationInverseSide(PojoModelPathValueNode inverseSidePath) {
        this.inverseSidePath = inverseSidePath;
    }

    @Override
    public void associationEmbedded() {
        this.associationEmbedded = true;
    }

    @Override
    public void reindexOnUpdate(ReindexOnUpdate reindexOnUpdate) {
        this.reindexOnUpdate = Optional.of(reindexOnUpdate);
    }

    @Override
    public void derivedFrom(Set<PojoModelPathValueNode> derivedFrom) {
        this.derivedFrom = derivedFrom;
    }

    @Override
    public void decimalScale(int decimalScale) {
        this.decimalScale = decimalScale;
    }

    PojoValueAdditionalMetadata build() {
        return new PojoValueAdditionalMetadata(this.inverseSidePath, this.associationEmbedded, this.reindexOnUpdate, this.derivedFrom, this.decimalScale);
    }
}

