/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.definition.annotation.impl;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.impl.AnnotationProcessorHelper;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.TypeMappingStep;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.reporting.impl.PojoEventContexts;

abstract class TypeAnnotationProcessor<A extends Annotation> {
    final AnnotationProcessorHelper helper;

    TypeAnnotationProcessor(AnnotationProcessorHelper helper) {
        this.helper = helper;
    }

    public final boolean process(TypeMappingStep mappingContext, PojoRawTypeModel<?> typeModel) {
        List annotationList = this.extractAnnotations(typeModel).collect(Collectors.toList());
        this.processEach(mappingContext, typeModel, annotationList);
        return !annotationList.isEmpty();
    }

    abstract Stream<? extends A> extractAnnotations(PojoRawTypeModel<?> var1);

    abstract void doProcess(TypeMappingStep var1, PojoRawTypeModel<?> var2, A var3);

    private void processEach(TypeMappingStep mappingContext, PojoRawTypeModel<?> typeModel, List<A> annotationList) {
        for (Annotation annotation : annotationList) {
            try {
                this.doProcess(mappingContext, typeModel, annotation);
            }
            catch (RuntimeException e) {
                this.helper.getRootFailureCollector().withContext(PojoEventContexts.fromType(typeModel)).withContext(PojoEventContexts.fromAnnotation(annotation)).add((Throwable)e);
            }
        }
    }
}

