/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.definition.annotation.impl;

import java.lang.annotation.Annotation;
import java.util.stream.Stream;
import org.hibernate.search.engine.backend.types.Projectable;
import org.hibernate.search.engine.backend.types.Searchable;
import org.hibernate.search.mapper.pojo.bridge.mapping.annotation.ValueBinderRef;
import org.hibernate.search.mapper.pojo.bridge.mapping.annotation.ValueBridgeRef;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.ValueBinder;
import org.hibernate.search.mapper.pojo.extractor.mapping.annotation.ContainerExtraction;
import org.hibernate.search.mapper.pojo.extractor.mapping.programmatic.ContainerExtractorPath;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.impl.AnnotationProcessorHelper;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.impl.PropertyAnnotationProcessor;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.PropertyMappingFieldOptionsStep;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.PropertyMappingStep;
import org.hibernate.search.mapper.pojo.model.spi.PojoPropertyModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;

abstract class PropertyFieldAnnotationProcessor<A extends Annotation>
extends PropertyAnnotationProcessor<A> {
    private final Class<A> annotationType;

    PropertyFieldAnnotationProcessor(AnnotationProcessorHelper helper, Class<A> annotationType) {
        super(helper);
        this.annotationType = annotationType;
    }

    @Override
    final Stream<? extends A> extractAnnotations(PojoPropertyModel<?> propertyModel) {
        return propertyModel.getAnnotationsByType(this.annotationType);
    }

    @Override
    final void doProcess(PropertyMappingStep mappingContext, PojoRawTypeModel<?> typeModel, PojoPropertyModel<?> propertyModel, A annotation) {
        Searchable searchable;
        String cleanedUpRelativeFieldName = this.getName(annotation);
        if (cleanedUpRelativeFieldName.isEmpty()) {
            cleanedUpRelativeFieldName = null;
        }
        PropertyMappingFieldOptionsStep<?> fieldContext = this.initFieldMappingContext(mappingContext, propertyModel, annotation, cleanedUpRelativeFieldName);
        ValueBinder binder = this.helper.createValueBinder(this.getValueBridge(annotation), this.getValueBinder(annotation), propertyModel);
        fieldContext.valueBinder(binder);
        ContainerExtractorPath extractorPath = this.helper.getExtractorPath(this.getExtraction(annotation));
        fieldContext.extractors(extractorPath);
        Projectable projectable = this.getProjectable(annotation);
        if (!Projectable.DEFAULT.equals((Object)projectable)) {
            fieldContext.projectable(projectable);
        }
        if (!Searchable.DEFAULT.equals((Object)(searchable = this.getSearchable(annotation)))) {
            fieldContext.searchable(searchable);
        }
    }

    abstract PropertyMappingFieldOptionsStep<?> initFieldMappingContext(PropertyMappingStep var1, PojoPropertyModel<?> var2, A var3, String var4);

    abstract String getName(A var1);

    abstract Projectable getProjectable(A var1);

    abstract Searchable getSearchable(A var1);

    abstract ValueBridgeRef getValueBridge(A var1);

    abstract ValueBinderRef getValueBinder(A var1);

    abstract ContainerExtraction getExtraction(A var1);
}

