/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.work.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.hibernate.search.engine.backend.work.execution.spi.IndexWorkExecutor;
import org.hibernate.search.engine.mapper.session.context.spi.DetachedSessionContextImplementor;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkIndexedTypeContext;
import org.hibernate.search.mapper.pojo.work.spi.PojoScopeWorkExecutor;

public class PojoScopeWorkExecutorImpl
implements PojoScopeWorkExecutor {
    private final List<IndexWorkExecutor> workExecutors = new ArrayList<IndexWorkExecutor>();

    public PojoScopeWorkExecutorImpl(Set<? extends PojoWorkIndexedTypeContext<?, ?, ?>> targetedTypeContexts, DetachedSessionContextImplementor sessionContext) {
        for (PojoWorkIndexedTypeContext<?, ?, ?> targetedTypeContext : targetedTypeContexts) {
            this.workExecutors.add(targetedTypeContext.createWorkExecutor(sessionContext));
        }
    }

    @Override
    public CompletableFuture<?> optimize() {
        return this.doOperationOnTypes(IndexWorkExecutor::optimize);
    }

    @Override
    public CompletableFuture<?> purge() {
        return this.doOperationOnTypes(IndexWorkExecutor::purge);
    }

    @Override
    public CompletableFuture<?> flush() {
        return this.doOperationOnTypes(IndexWorkExecutor::flush);
    }

    private CompletableFuture<?> doOperationOnTypes(Function<IndexWorkExecutor, CompletableFuture<?>> operation) {
        CompletableFuture[] futures = new CompletableFuture[this.workExecutors.size()];
        int typeCounter = 0;
        for (IndexWorkExecutor workExecutor : this.workExecutors) {
            futures[typeCounter++] = operation.apply(workExecutor);
        }
        return CompletableFuture.allOf(futures);
    }
}

