/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.model.spi;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.hibernate.search.mapper.pojo.model.spi.GenericContextAwarePojoPropertyModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoGenericTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoPropertyModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.util.common.reflect.impl.GenericTypeContext;
import org.hibernate.search.util.common.reflect.impl.ReflectionUtils;

public final class GenericContextAwarePojoGenericTypeModel<T>
implements PojoGenericTypeModel<T> {
    private final Helper helper;
    private final PojoRawTypeModel<? super T> rawTypeModel;
    private final GenericTypeContext genericTypeContext;
    private final Map<Object, PojoPropertyModel<?>> genericPropertyCache = new HashMap();

    private GenericContextAwarePojoGenericTypeModel(Helper helper, GenericTypeContext genericTypeContext) {
        this.helper = helper;
        this.rawTypeModel = helper.getRawTypeModel(ReflectionUtils.getRawType((Type)genericTypeContext.getResolvedType()));
        this.genericTypeContext = genericTypeContext;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getName() + "]";
    }

    @Override
    public String getName() {
        return this.genericTypeContext.getResolvedType().getTypeName();
    }

    @Override
    public PojoRawTypeModel<? super T> getRawType() {
        return this.rawTypeModel;
    }

    @Override
    public PojoPropertyModel<?> getProperty(String propertyName) {
        return this.wrapProperty(this.rawTypeModel.getProperty(propertyName));
    }

    @Override
    public Optional<PojoGenericTypeModel<?>> getTypeArgument(Class<?> rawSuperType, int typeParameterIndex) {
        return this.genericTypeContext.resolveTypeArgument(rawSuperType, typeParameterIndex).map(type -> new GenericContextAwarePojoGenericTypeModel<T>(this.helper, new GenericTypeContext(this.genericTypeContext.getDeclaringContext(), type)));
    }

    @Override
    public Optional<PojoGenericTypeModel<?>> getArrayElementType() {
        return this.genericTypeContext.resolveArrayElementType().map(type -> new GenericContextAwarePojoGenericTypeModel<T>(this.helper, new GenericTypeContext(this.genericTypeContext.getDeclaringContext(), type)));
    }

    private <U> PojoPropertyModel<? extends U> wrapProperty(PojoPropertyModel<U> rawPropertyModel) {
        Object cacheKey = this.helper.getPropertyCacheKey(rawPropertyModel);
        PojoPropertyModel<?> cached = this.genericPropertyCache.get(cacheKey);
        if (cached != null) {
            return cached;
        }
        Type propertyType = this.helper.getPropertyGenericType(rawPropertyModel);
        GenericTypeContext propertyGenericTypeContext = new GenericTypeContext(this.genericTypeContext, propertyType);
        GenericContextAwarePojoGenericTypeModel<T> genericPropertyTypeModel = new GenericContextAwarePojoGenericTypeModel<T>(this.helper, propertyGenericTypeContext);
        GenericContextAwarePojoPropertyModel<U> propertyModel = new GenericContextAwarePojoPropertyModel<U>(rawPropertyModel, genericPropertyTypeModel);
        this.genericPropertyCache.put(cacheKey, propertyModel);
        return propertyModel;
    }

    public static class RawTypeDeclaringContext<T> {
        private final Helper helper;
        private final GenericTypeContext genericTypeContext;

        public RawTypeDeclaringContext(Helper helper, Class<T> rawType) {
            this.helper = helper;
            this.genericTypeContext = new GenericTypeContext(rawType);
        }

        public <U> PojoGenericTypeModel<U> createGenericTypeModel(Class<U> declaredType) {
            return this.createGenericTypeModel((Type)declaredType);
        }

        public PojoGenericTypeModel<?> createGenericTypeModel(Type declaredType) {
            return new GenericContextAwarePojoGenericTypeModel(this.helper, new GenericTypeContext(this.genericTypeContext, declaredType));
        }
    }

    public static interface Helper {
        public <T> PojoRawTypeModel<T> getRawTypeModel(Class<T> var1);

        public Object getPropertyCacheKey(PojoPropertyModel<?> var1);

        public Type getPropertyGenericType(PojoPropertyModel<?> var1);
    }
}

