/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.model.path.impl;

import org.hibernate.search.mapper.pojo.extractor.impl.BoundContainerExtractorPath;
import org.hibernate.search.mapper.pojo.extractor.impl.ContainerExtractorBinder;
import org.hibernate.search.mapper.pojo.extractor.mapping.programmatic.ContainerExtractorPath;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPath;
import org.hibernate.search.mapper.pojo.model.path.binding.impl.PojoModelPathWalker;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathOriginalTypeNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathPropertyNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathTypeNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel;

public abstract class BoundPojoModelPath {
    public static Walker walker(ContainerExtractorBinder containerExtractorBinder) {
        return new Walker(containerExtractorBinder);
    }

    public static <T> BoundPojoModelPathOriginalTypeNode<T> root(PojoTypeModel<T> typeModel) {
        return new BoundPojoModelPathOriginalTypeNode<T>(null, typeModel);
    }

    BoundPojoModelPath() {
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName()).append("[");
        this.appendPath(builder);
        builder.append("]");
        return builder.toString();
    }

    public abstract BoundPojoModelPath getParent();

    public abstract PojoTypeModel<?> getRootType();

    public abstract PojoModelPath toUnboundPath();

    abstract void appendSelfPath(StringBuilder var1);

    private void appendPath(StringBuilder builder) {
        BoundPojoModelPath parent = this.getParent();
        if (parent == null) {
            this.appendSelfPath(builder);
        } else {
            parent.appendPath(builder);
            builder.append(" => ");
            this.appendSelfPath(builder);
        }
    }

    abstract void appendSelfPath(PojoModelPath.Builder var1);

    final void appendPath(PojoModelPath.Builder builder) {
        BoundPojoModelPath parent = this.getParent();
        if (parent != null) {
            parent.appendPath(builder);
        }
        this.appendSelfPath(builder);
    }

    public static class Walker
    implements PojoModelPathWalker<BoundPojoModelPathTypeNode<?>, BoundPojoModelPathPropertyNode<?, ?>, BoundPojoModelPathValueNode<?, ?, ?>> {
        private final ContainerExtractorBinder containerExtractorBinder;

        private Walker(ContainerExtractorBinder containerExtractorBinder) {
            this.containerExtractorBinder = containerExtractorBinder;
        }

        @Override
        public BoundPojoModelPathPropertyNode<?, ?> property(BoundPojoModelPathTypeNode<?> typeNode, String propertyName) {
            return typeNode.property(propertyName);
        }

        @Override
        public BoundPojoModelPathValueNode<?, ?, ?> value(BoundPojoModelPathPropertyNode<?, ?> propertyNode, ContainerExtractorPath extractorPath) {
            return this.doValue(propertyNode, extractorPath);
        }

        @Override
        public BoundPojoModelPathTypeNode<?> type(BoundPojoModelPathValueNode<?, ?, ?> valueNode) {
            return valueNode.type();
        }

        private <P> BoundPojoModelPathValueNode<?, P, ?> doValue(BoundPojoModelPathPropertyNode<?, P> propertyNode, ContainerExtractorPath extractorPath) {
            BoundContainerExtractorPath<P, ?> boundExtractorPath = this.containerExtractorBinder.bindPath(propertyNode.getPropertyModel().getTypeModel(), extractorPath);
            return propertyNode.value(boundExtractorPath);
        }
    }
}

