/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.definition.annotation.impl;

import java.util.Optional;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoTypeMetadataContributor;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.impl.AnnotationProcessorProvider;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.impl.PropertyAnnotationProcessor;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.impl.TypeAnnotationProcessor;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.PropertyMappingStep;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.impl.TypeMappingStepImpl;
import org.hibernate.search.mapper.pojo.model.spi.PojoPropertyModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;

class AnnotationPojoTypeMetadataContributorFactory {
    private final AnnotationProcessorProvider annotationProcessorProvider;

    AnnotationPojoTypeMetadataContributorFactory(AnnotationProcessorProvider annotationProcessorProvider) {
        this.annotationProcessorProvider = annotationProcessorProvider;
    }

    public Optional<PojoTypeMetadataContributor> createIfAnnotated(PojoRawTypeModel<?> typeModel) {
        TypeMappingStepImpl typeMappingContext = new TypeMappingStepImpl(typeModel);
        boolean processedTypeLevelAnnotation = this.processTypeLevelAnnotations(typeMappingContext, typeModel);
        boolean processedPropertyLevelAnnotation = typeModel.getDeclaredProperties().map(propertyModel -> this.processPropertyLevelAnnotations(typeMappingContext, typeModel, (PojoPropertyModel<?>)propertyModel)).reduce((processedAnnotationHere, processedAnnotationThere) -> processedAnnotationHere != false || processedAnnotationThere != false).orElse(false);
        if (!processedTypeLevelAnnotation && !processedPropertyLevelAnnotation) {
            return Optional.empty();
        }
        return Optional.of(typeMappingContext);
    }

    private boolean processTypeLevelAnnotations(TypeMappingStepImpl typeMappingContext, PojoRawTypeModel<?> typeModel) {
        boolean processedAtLeastOneAnnotation = false;
        for (TypeAnnotationProcessor<?> processor : this.annotationProcessorProvider.getTypeAnnotationProcessors()) {
            if (!processor.process(typeMappingContext, typeModel)) continue;
            processedAtLeastOneAnnotation = true;
        }
        return processedAtLeastOneAnnotation;
    }

    private boolean processPropertyLevelAnnotations(TypeMappingStepImpl typeMappingContext, PojoRawTypeModel<?> typeModel, PojoPropertyModel<?> propertyModel) {
        String propertyName = propertyModel.getName();
        PropertyMappingStep mappingContext = typeMappingContext.property(propertyName);
        boolean processedAtLeastOneAnnotation = false;
        for (PropertyAnnotationProcessor<?> processor : this.annotationProcessorProvider.getPropertyAnnotationProcessors()) {
            if (!processor.process(mappingContext, typeModel, propertyModel)) continue;
            processedAtLeastOneAnnotation = true;
        }
        return processedAtLeastOneAnnotation;
    }
}

