/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.logging.impl;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import org.hibernate.search.engine.backend.types.dsl.StandardIndexFieldTypeOptionsStep;
import org.hibernate.search.mapper.pojo.extractor.ContainerExtractor;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.logging.spi.PojoModelPathFormatter;
import org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoContainedTypeManager;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoIndexedTypeManager;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.spi.PojoGenericTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.hibernate.search.util.common.logging.impl.ToStringTreeAppendableMultilineFormatter;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String uselessIncludePathFilters = "HSEARCH000216: An IndexedEmbedded defines includePaths filters that do not match anything. Non-matching includePaths filters: %1$s. Encountered field paths: %2$s. Check the filters for typos, or remove them if they are not useful.";
    private static final String parseException = "HSEARCH000295: String '$1%s' cannot be parsed into a '$2%s'";
    private static final String valueTooLargeForConversionException = "HSEARCH000297:  Value of '%2$s' for type '%1$s' is too big for the conversion";
    private static final String unableToResolveDefaultIdentifierBridgeFromSourceType = "HSEARCH700001: Unable to find a default identifier bridge implementation for type '%1$s'";
    private static final String unableToResolveDefaultValueBridgeFromSourceType = "HSEARCH700002: Unable to find a default value bridge implementation for type '%1$s'";
    private static final String missingBinderReferenceInBridgeMapping = "HSEARCH700003: Annotation type '%2$s' is annotated with '%1$s', but the binder reference is empty.";
    private static final String missingBinderReferenceInMarkerMapping = "HSEARCH700004: Annotation type '%2$s' is annotated with '%1$s', but the binder reference is empty.";
    private static final String invalidFieldDefiningBothBridgeReferenceAndBinderReference = "HSEARCH700005: Annotation @GenericField on property '%1$s' defines both valueBridge and valueBinder. Only one of those can be defined, not both.";
    private static final String invalidDocumentIdDefiningBothBridgeReferenceAndBinderReference = "HSEARCH700006: Annotation @DocumentId on property '%1$s' defines both identifierBridge and identifierBinder. Only one of those can be defined, not both.";
    private static final String invalidEmptyTargetForScope = "HSEARCH700007: Invalid empty target for a scoped operation. If you want to target all indexes, use 'Object.class' as the target type.";
    private static final String invalidInputTypeForBridge = "HSEARCH700010: Bridge '%1$s' cannot be applied to input type '%2$s'.";
    private static final String missingFieldNameForGeoPointBridgeOnType = "HSEARCH700011: Missing field name for GeoPointBinding on type %1$s. The field name is mandatory when the bridge is applied on an type, optional when applied on a property.";
    private static final String cannotInferContainerExtractorClassTypePattern = "HSEARCH700015: Cannot interpret the type arguments to the ContainerExtractor interface in  implementation '%1$s'. Only the following implementations of ContainerExtractor are valid:  1) implementations setting both type parameters to *raw* types, e.g. class MyExtractor implements ContainerExtractor<MyBean, String>; 2) implementations setting the first type parameter to an array of an unbounded type variable, and setting the second parameter to the same type variable, e.g. MyExtractor<T> implements ContainerExtractor<T[], T> 3) implementations setting the first type parameter to a parameterized type with one argument set to an unbounded type variable and the other to unbounded wildcards, and setting the second type parameter to the same type variable, e.g. MyExtractor<T> implements ContainerExtractor<MyParameterizedBean<?, T, ?>, T>";
    private static final String invalidContainerExtractorForType = "HSEARCH700016: Cannot apply the requested container value extractor '%1$s' (implementation class: '%2$s') to type '%3$s'";
    private static final String createdPojoIndexedTypeManager = "HSEARCH700017: Created POJO indexed type manager: %1$s";
    private static final String detectedEntityTypes = "HSEARCH700018: Detected entity types: %1$s";
    private static final String createdPojoContainedTypeManager = "HSEARCH700019: Created POJO contained type manager: %1$s";
    private static final String cannotInvertAssociationForReindexing = "HSEARCH700020: Cannot find the inverse side of the association on type '%2$s' at path '%3$s'. Hibernate Search needs this information in order to reindex '%2$s' when '%1$s' is modified. You can solve this error by defining the inverse side of this association,  either with annotations specific to your integration (@OneToMany(mappedBy = ...) in Hibernate ORM)  or with the Hibernate Search @AssociationInverseSide annotation. Alternatively, if you do not need to reindex '%2$s' when '%1$s' is modified, you can disable reindexing with @IndexingDependency(reindexOnUpdate = ReindexOnUpdate.NO).";
    private static final String cannotApplyImplicitInverseAssociationPath = "HSEARCH700021: Cannot apply the path '%2$s' to type '%1$s'. This path was resolved as the inverse side of the association '%4$s' on type '%3$s'. Hibernate Search needs to apply this path in order to reindex '%3$s' when '%1$s' is modified. Error was: '%5$s'";
    private static final String incorrectTargetTypeForInverseAssociation = "HSEARCH700022: The inverse association targets type '%1$s', but a supertype or subtype of '%2$s' was expected.";
    private static final String missingInversePathInAssociationInverseSideMapping = "HSEARCH700023: Property '%2$s' from type '%1$s' is annotated with @AssociationInverseSide, but the inverse path is empty.";
    private static final String infiniteRecursionForAssociationEmbeddeds = "HSEARCH700024: Found an infinite embedded recursion involving path '%2$s' on type '%1$s'";
    private static final String conflictingBridgeReferenceInBridgeMapping = "HSEARCH700026: Annotation type '%2$s' is annotated with '%1$s', but both a bridge reference and a binder reference were provided. Only one can be provided.";
    private static final String missingEntityTypeMetadata = "HSEARCH700027: Type '%1$s' is not marked as an entity type, yet it is indexed or targeted by an association from an indexed type. Please check your configuration.";
    private static final String missingIdentifierMapping = "HSEARCH700028: There isn't any explicit document ID mapping for indexed type '%1$s', and the entity ID cannot be used as a default because it is unknown.";
    private static final String missingPathInIndexingDependencyDerivedFrom = "HSEARCH700029: Property '%2$s' from type '%1$s' is annotated with @IndexingDependency, but 'derivedFrom' contains an empty path.";
    private static final String infiniteRecursionForDerivedFrom = "HSEARCH700030: Found a cyclic dependency between derived properties involving path '%2$s' on type '%1$s'. Derived properties cannot be marked as derived from themselves, even indirectly through other  derived properties. If your model actually contains such cyclic dependency,  you should consider disabling automatic reindexing, at least partially  using @IndexingDependency(reindexOnUpdate = ReindexOnUpdate.NO) on one of the properties in the cycle.";
    private static final String invalidFieldEncodingForFullTextFieldMapping = "HSEARCH700031: This property is mapped to a full-text field, but with a value bridge that binds to a non-String or otherwise incompatible field. Make sure to use a compatible bridge. Details: encountered type DSL step '%1$s', which does not extend the expected '%2$s' interface.";
    private static final String invalidFieldEncodingForKeywordFieldMapping = "HSEARCH700032: This property is mapped to a keyword field, but with a value bridge that binds to a non-String or otherwise incompatible field. Make sure to use a compatible bridge. Details: encountered type DSL step '%1$s', which does not extend the expected '%2$s' interface.";
    private static final String propertyMarkerNotFound = "HSEARCH700034: Could not find a property with the '%1$s' marker for field '%2$s' (marker set: '%3$s').";
    private static final String multiplePropertiesForMarker = "HSEARCH700035: Found multiple properties with the '%1$s' marker for field '%2$s' (marker set: '%3$s').";
    private static final String invalidScopeTarget = "HSEARCH700036: Some of the given types cannot be targeted. These types are not indexed, nor is any of their subtypes: %1$s. Note that some of them are indexed-embedded in an indexed entity, but this is not enough to be targeted (only indexed types can be targeted): %2$s.";
    private static final String notIndexedTypeNorAsDelegate = "HSEARCH700037: Cannot work on type %1$s, because it is not indexed, neither directly nor as a contained entity in another type.";
    private static final String nullProvidedIdentifier = "HSEARCH700038: The identifier for this entity should always be provided, but the provided identifier was null.";
    private static final String incompatibleRequestedType = "HSEARCH700039: Requested incompatible type for '%1$s': '%2$s'";
    private static final String notDirectlyIndexedType = "HSEARCH700040: Cannot work on type %1$s, because it is not directly indexed.";
    private static final String cannotUseDefaultExtractorsInMultiExtractorChain = "HSEARCH700041: A chain of multiple container extractors cannot include the default extractors. Either use only the default extractors, or explicitly reference every single extractor to be applied instead.";
    private static final String malformedURL = "HSEARCH700043: Error creating URL from String '%1$s'.";
    private static final String badURISyntax = "HSEARCH700044: Error creating URI from String '%1$s'.";
    private static final String cannotDefinePojoModelPathWithoutProperty = "HSEARCH700045: A PojoModelPath must include at least one property.";
    private static final String cannotApplyExplicitInverseAssociationPath = "HSEARCH700046: Cannot apply the path '%2$s' to type '%1$s'. This path was declared as a path to collect entities of type '%3$s' to be reindexed. Hibernate Search needs to apply this path in order to reindex '%3$s' when '%1$s' is modified. Error was: '%4$s'";
    private static final String cannotDefineOtherEntityDependencyOnNonEntityBridgedType = "HSEARCH700047: 'fromOtherEntity' can only be used when the bridged element has an entity type, but the bridged element has type '%1$s', which is not an entity type.";
    private static final String cannotDefineOtherEntityDependencyFromNonEntityType = "HSEARCH700048: 'fromOtherEntity' expects an entity type; type '%1$s' is not an entity type.";
    private static final String missingBridgeDependencyDeclaration = "HSEARCH700049: The binder did not declare any dependency to the entity model during binding. Declare dependencies using context.getDependencies().use(...) or, if the bridge really does not depend on the entity model, context.getDependencies().useRootOnly().";
    private static final String inconsistentBridgeDependencyDeclaration = "HSEARCH700050: The binder called context.getDependencies().useRootOnly() during binding, but also declared extra dependencies to the entity model.";
    private static final String invalidFieldEncodingForScaledNumberFieldMapping = "HSEARCH700051: This property is mapped to a scaled number field, but with a value bridge that binds neither to a BigDecimal nor to a BigInteger field. Make sure to use a compatible bridge. Details: encountered type DSL step '%1$s', which does not extend the expected '%2$s' interface.";
    private static final String cannotReferenceExtractorsWhenExtractionDisabled = "HSEARCH700052: Extractors cannot be defined explicitly when extract = ContainerExtract.NO. Either leave 'extract' to its default value to define extractors explicitly or leave the 'extractor' list to its default, empty value to disable extraction.";
    private static final String cannotResolveContainerExtractorName = "HSEARCH700053: Cannot resolve container extractor name '%1$s'. Check that this name matches a container extractor, either a builtin one whose name is a constant in '%2$s' or a custom one that was properly registered.";
    private static final String invalidAnnotationTypeForBinder = "HSEARCH700054: Binder '%1$s' cannot be initialized with annotations of type '%2$s'.";
    private static final String cannotPurgeNonIndexedContainedType = "HSEARCH700055: Type '%1$s' is contained in an indexed type but is not itself indexed, thus entity with identifier '%2$s' cannot be purged. Use delete() and pass the entity instead of just the identifier.";
    private static final String cannotAccessPropertyMember = "HSEARCH700056: Could not access to the org.hibernate.annotations.common.reflection.java.JavaXMember#getMember method";
    private static final String cannotAccessPropertyMethod = "HSEARCH700057: The underlying member of property '%1$s' is supposed to be a method";
    private static final String missingBridgeForBinder = "HSEARCH700058: The bind() method of binder '%1$s' is not implemented correctly: it did not call context.setBridge().";
    private static final String missingMarkerForBinder = "HSEARCH700059: The bind() method of binder '%1$s' is not implemented correctly: it did not call context.setMarker(...).";
    private static final String recursiveWorkPlanPrepare = "HSEARCH700060: Entity processing was triggered while already processing entities, which is not supported. Make sure you do not change entities within an entity getter or a custom bridge used for indexing, and avoid any event that could trigger entity processing. Hibernate ORM flushes, in particular, must be avoided in entity getters and bridges.";
    private static final String invalidIndexedEmbedded = "HSEARCH700061: Type '%1$s' cannot be indexed-embedded, because no index mapping (@GenericField, @FullTextField, ...) is defined for that type.";

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String uselessIncludePathFilters$str() {
        return uselessIncludePathFilters;
    }

    @Override
    public final SearchException uselessIncludePathFilters(Set<String> nonMatchingIncludePaths, Set<String> encounteredFieldPaths) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.uselessIncludePathFilters$str(), nonMatchingIncludePaths, encounteredFieldPaths));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String parseException$str() {
        return parseException;
    }

    @Override
    public final SearchException parseException(String text, Class<?> readerClass, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.parseException$str(), text, new ClassFormatter(readerClass)), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String valueTooLargeForConversionException$str() {
        return valueTooLargeForConversionException;
    }

    @Override
    public final SearchException valueTooLargeForConversionException(Class<?> type, Object duration, Exception ae) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.valueTooLargeForConversionException$str(), new ClassFormatter(type), duration), (Throwable)ae);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToResolveDefaultIdentifierBridgeFromSourceType$str() {
        return unableToResolveDefaultIdentifierBridgeFromSourceType;
    }

    @Override
    public final SearchException unableToResolveDefaultIdentifierBridgeFromSourceType(PojoTypeModel<?> sourceType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToResolveDefaultIdentifierBridgeFromSourceType$str(), new PojoTypeModelFormatter(sourceType)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToResolveDefaultValueBridgeFromSourceType$str() {
        return unableToResolveDefaultValueBridgeFromSourceType;
    }

    @Override
    public final SearchException unableToResolveDefaultValueBridgeFromSourceType(PojoTypeModel<?> sourceType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToResolveDefaultValueBridgeFromSourceType$str(), new PojoTypeModelFormatter(sourceType)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String missingBinderReferenceInBridgeMapping$str() {
        return missingBinderReferenceInBridgeMapping;
    }

    @Override
    public final SearchException missingBinderReferenceInBridgeMapping(Class<? extends Annotation> metaAnnotationType, Class<? extends Annotation> annotationType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.missingBinderReferenceInBridgeMapping$str(), new ClassFormatter(metaAnnotationType), new ClassFormatter(annotationType)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String missingBinderReferenceInMarkerMapping$str() {
        return missingBinderReferenceInMarkerMapping;
    }

    @Override
    public final SearchException missingBinderReferenceInMarkerMapping(Class<? extends Annotation> metaAnnotationType, Class<? extends Annotation> annotationType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.missingBinderReferenceInMarkerMapping$str(), new ClassFormatter(metaAnnotationType), new ClassFormatter(annotationType)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidFieldDefiningBothBridgeReferenceAndBinderReference$str() {
        return invalidFieldDefiningBothBridgeReferenceAndBinderReference;
    }

    @Override
    public final SearchException invalidFieldDefiningBothBridgeReferenceAndBinderReference(String property) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidFieldDefiningBothBridgeReferenceAndBinderReference$str(), property));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidDocumentIdDefiningBothBridgeReferenceAndBinderReference$str() {
        return invalidDocumentIdDefiningBothBridgeReferenceAndBinderReference;
    }

    @Override
    public final SearchException invalidDocumentIdDefiningBothBridgeReferenceAndBinderReference(String property) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidDocumentIdDefiningBothBridgeReferenceAndBinderReference$str(), property));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidEmptyTargetForScope$str() {
        return invalidEmptyTargetForScope;
    }

    @Override
    public final SearchException invalidEmptyTargetForScope() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidEmptyTargetForScope$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidInputTypeForBridge$str() {
        return invalidInputTypeForBridge;
    }

    @Override
    public final SearchException invalidInputTypeForBridge(Object bridge, PojoTypeModel<?> typeModel) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidInputTypeForBridge$str(), bridge, new PojoTypeModelFormatter(typeModel)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String missingFieldNameForGeoPointBridgeOnType$str() {
        return missingFieldNameForGeoPointBridgeOnType;
    }

    @Override
    public final SearchException missingFieldNameForGeoPointBridgeOnType(String typeName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.missingFieldNameForGeoPointBridgeOnType$str(), typeName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotInferContainerExtractorClassTypePattern$str() {
        return cannotInferContainerExtractorClassTypePattern;
    }

    @Override
    public final SearchException cannotInferContainerExtractorClassTypePattern(Class<?> extractorClass, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotInferContainerExtractorClassTypePattern$str(), new ClassFormatter(extractorClass)), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidContainerExtractorForType$str() {
        return invalidContainerExtractorForType;
    }

    @Override
    public final SearchException invalidContainerExtractorForType(String extractorName, Class<? extends ContainerExtractor> extractorClass, PojoGenericTypeModel<?> extractedType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidContainerExtractorForType$str(), extractorName, new ClassFormatter(extractorClass), new PojoTypeModelFormatter(extractedType)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void createdPojoIndexedTypeManager(PojoIndexedTypeManager<?, ?, ?> typeManager) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.createdPojoIndexedTypeManager$str(), (Object)new ToStringTreeAppendableMultilineFormatter(typeManager));
    }

    protected String createdPojoIndexedTypeManager$str() {
        return createdPojoIndexedTypeManager;
    }

    @Override
    public final void detectedEntityTypes(Set<PojoRawTypeModel<?>> entityTypes) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.detectedEntityTypes$str(), entityTypes);
    }

    protected String detectedEntityTypes$str() {
        return detectedEntityTypes;
    }

    @Override
    public final void createdPojoContainedTypeManager(PojoContainedTypeManager<?> typeManager) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.createdPojoContainedTypeManager$str(), (Object)new ToStringTreeAppendableMultilineFormatter(typeManager));
    }

    protected String createdPojoContainedTypeManager$str() {
        return createdPojoContainedTypeManager;
    }

    protected String cannotInvertAssociationForReindexing$str() {
        return cannotInvertAssociationForReindexing;
    }

    @Override
    public final SearchException cannotInvertAssociationForReindexing(PojoRawTypeModel<?> inverseSideTypeModel, PojoRawTypeModel<?> typeModel, PojoModelPathValueNode associationPath) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotInvertAssociationForReindexing$str(), new PojoTypeModelFormatter(inverseSideTypeModel), new PojoTypeModelFormatter(typeModel), new PojoModelPathFormatter(associationPath)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotApplyImplicitInverseAssociationPath$str() {
        return cannotApplyImplicitInverseAssociationPath;
    }

    @Override
    public final SearchException cannotApplyImplicitInverseAssociationPath(PojoRawTypeModel<?> inverseSideTypeModel, PojoModelPathValueNode inverseSideAssociationPath, PojoRawTypeModel<?> originalSideTypeModel, PojoModelPathValueNode originalSideAssociationPath, String errorMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotApplyImplicitInverseAssociationPath$str(), new PojoTypeModelFormatter(inverseSideTypeModel), new PojoModelPathFormatter(inverseSideAssociationPath), new PojoTypeModelFormatter(originalSideTypeModel), new PojoModelPathFormatter(originalSideAssociationPath), errorMessage), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String incorrectTargetTypeForInverseAssociation$str() {
        return incorrectTargetTypeForInverseAssociation;
    }

    @Override
    public final SearchException incorrectTargetTypeForInverseAssociation(PojoRawTypeModel<?> inverseAssociationTargetType, PojoRawTypeModel<?> entityType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.incorrectTargetTypeForInverseAssociation$str(), new PojoTypeModelFormatter(inverseAssociationTargetType), new PojoTypeModelFormatter(entityType)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String missingInversePathInAssociationInverseSideMapping$str() {
        return missingInversePathInAssociationInverseSideMapping;
    }

    @Override
    public final SearchException missingInversePathInAssociationInverseSideMapping(PojoRawTypeModel<?> typeModel, String propertyName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.missingInversePathInAssociationInverseSideMapping$str(), new PojoTypeModelFormatter(typeModel), propertyName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String infiniteRecursionForAssociationEmbeddeds$str() {
        return infiniteRecursionForAssociationEmbeddeds;
    }

    @Override
    public final SearchException infiniteRecursionForAssociationEmbeddeds(PojoRawTypeModel<?> typeModel, PojoModelPathValueNode path) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.infiniteRecursionForAssociationEmbeddeds$str(), new PojoTypeModelFormatter(typeModel), new PojoModelPathFormatter(path)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String conflictingBridgeReferenceInBridgeMapping$str() {
        return conflictingBridgeReferenceInBridgeMapping;
    }

    @Override
    public final SearchException conflictingBridgeReferenceInBridgeMapping(Class<? extends Annotation> metaAnnotationType, Class<? extends Annotation> annotationType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.conflictingBridgeReferenceInBridgeMapping$str(), new ClassFormatter(metaAnnotationType), new ClassFormatter(annotationType)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String missingEntityTypeMetadata$str() {
        return missingEntityTypeMetadata;
    }

    @Override
    public final SearchException missingEntityTypeMetadata(PojoRawTypeModel<?> typeModel) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.missingEntityTypeMetadata$str(), new PojoTypeModelFormatter(typeModel)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String missingIdentifierMapping$str() {
        return missingIdentifierMapping;
    }

    @Override
    public final SearchException missingIdentifierMapping(PojoRawTypeModel<?> typeModel) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.missingIdentifierMapping$str(), new PojoTypeModelFormatter(typeModel)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String missingPathInIndexingDependencyDerivedFrom$str() {
        return missingPathInIndexingDependencyDerivedFrom;
    }

    @Override
    public final SearchException missingPathInIndexingDependencyDerivedFrom(PojoRawTypeModel<?> typeModel, String propertyName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.missingPathInIndexingDependencyDerivedFrom$str(), new PojoTypeModelFormatter(typeModel), propertyName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String infiniteRecursionForDerivedFrom$str() {
        return infiniteRecursionForDerivedFrom;
    }

    @Override
    public final SearchException infiniteRecursionForDerivedFrom(PojoRawTypeModel<?> typeModel, PojoModelPathValueNode path) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.infiniteRecursionForDerivedFrom$str(), new PojoTypeModelFormatter(typeModel), new PojoModelPathFormatter(path)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidFieldEncodingForFullTextFieldMapping$str() {
        return invalidFieldEncodingForFullTextFieldMapping;
    }

    @Override
    public final SearchException invalidFieldEncodingForFullTextFieldMapping(StandardIndexFieldTypeOptionsStep<?, ?> context, Class<?> expectedContextType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidFieldEncodingForFullTextFieldMapping$str(), context, new ClassFormatter(expectedContextType)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidFieldEncodingForKeywordFieldMapping$str() {
        return invalidFieldEncodingForKeywordFieldMapping;
    }

    @Override
    public final SearchException invalidFieldEncodingForKeywordFieldMapping(StandardIndexFieldTypeOptionsStep<?, ?> context, Class<?> expectedContextType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidFieldEncodingForKeywordFieldMapping$str(), context, new ClassFormatter(expectedContextType)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String propertyMarkerNotFound$str() {
        return propertyMarkerNotFound;
    }

    @Override
    public final SearchException propertyMarkerNotFound(String markerName, String fieldName, String markerSet) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.propertyMarkerNotFound$str(), markerName, fieldName, markerSet));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String multiplePropertiesForMarker$str() {
        return multiplePropertiesForMarker;
    }

    @Override
    public final SearchException multiplePropertiesForMarker(String markerName, String fieldName, String markerSet) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.multiplePropertiesForMarker$str(), markerName, fieldName, markerSet));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidScopeTarget$str() {
        return invalidScopeTarget;
    }

    @Override
    public final SearchException invalidScopeTarget(Collection<Class<?>> nonIndexedTypes, Collection<Class<?>> containedTypes) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidScopeTarget$str(), nonIndexedTypes, containedTypes));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String notIndexedTypeNorAsDelegate$str() {
        return notIndexedTypeNorAsDelegate;
    }

    @Override
    public final SearchException notIndexedTypeNorAsDelegate(Class<?> targetedType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.notIndexedTypeNorAsDelegate$str(), new ClassFormatter(targetedType)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullProvidedIdentifier$str() {
        return nullProvidedIdentifier;
    }

    @Override
    public final SearchException nullProvidedIdentifier() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.nullProvidedIdentifier$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String incompatibleRequestedType$str() {
        return incompatibleRequestedType;
    }

    @Override
    public final SearchException incompatibleRequestedType(PojoModelPathValueNode accessor, Class<?> requestedType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.incompatibleRequestedType$str(), new PojoModelPathFormatter(accessor), new ClassFormatter(requestedType)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String notDirectlyIndexedType$str() {
        return notDirectlyIndexedType;
    }

    @Override
    public final SearchException notDirectlyIndexedType(Class<?> targetedType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.notDirectlyIndexedType$str(), new ClassFormatter(targetedType)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotUseDefaultExtractorsInMultiExtractorChain$str() {
        return cannotUseDefaultExtractorsInMultiExtractorChain;
    }

    @Override
    public final SearchException cannotUseDefaultExtractorsInMultiExtractorChain() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotUseDefaultExtractorsInMultiExtractorChain$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String malformedURL$str() {
        return malformedURL;
    }

    @Override
    public final SearchException malformedURL(String value, MalformedURLException e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.malformedURL$str(), value), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String badURISyntax$str() {
        return badURISyntax;
    }

    @Override
    public final SearchException badURISyntax(String value, URISyntaxException e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.badURISyntax$str(), value), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotDefinePojoModelPathWithoutProperty$str() {
        return cannotDefinePojoModelPathWithoutProperty;
    }

    @Override
    public final SearchException cannotDefinePojoModelPathWithoutProperty() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotDefinePojoModelPathWithoutProperty$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotApplyExplicitInverseAssociationPath$str() {
        return cannotApplyExplicitInverseAssociationPath;
    }

    @Override
    public final SearchException cannotApplyExplicitInverseAssociationPath(PojoRawTypeModel<?> inverseSideTypeModel, PojoModelPathValueNode inverseSideAssociationPath, PojoRawTypeModel<?> originalSideTypeModel, String errorMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotApplyExplicitInverseAssociationPath$str(), new PojoTypeModelFormatter(inverseSideTypeModel), new PojoModelPathFormatter(inverseSideAssociationPath), new PojoTypeModelFormatter(originalSideTypeModel), errorMessage), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotDefineOtherEntityDependencyOnNonEntityBridgedType$str() {
        return cannotDefineOtherEntityDependencyOnNonEntityBridgedType;
    }

    @Override
    public final SearchException cannotDefineOtherEntityDependencyOnNonEntityBridgedType(PojoRawTypeModel<?> bridgedTypeModel) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotDefineOtherEntityDependencyOnNonEntityBridgedType$str(), new PojoTypeModelFormatter(bridgedTypeModel)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotDefineOtherEntityDependencyFromNonEntityType$str() {
        return cannotDefineOtherEntityDependencyFromNonEntityType;
    }

    @Override
    public final SearchException cannotDefineOtherEntityDependencyFromNonEntityType(PojoRawTypeModel<?> otherType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotDefineOtherEntityDependencyFromNonEntityType$str(), new PojoTypeModelFormatter(otherType)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String missingBridgeDependencyDeclaration$str() {
        return missingBridgeDependencyDeclaration;
    }

    @Override
    public final SearchException missingBridgeDependencyDeclaration() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.missingBridgeDependencyDeclaration$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String inconsistentBridgeDependencyDeclaration$str() {
        return inconsistentBridgeDependencyDeclaration;
    }

    @Override
    public final SearchException inconsistentBridgeDependencyDeclaration() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.inconsistentBridgeDependencyDeclaration$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidFieldEncodingForScaledNumberFieldMapping$str() {
        return invalidFieldEncodingForScaledNumberFieldMapping;
    }

    @Override
    public final SearchException invalidFieldEncodingForScaledNumberFieldMapping(StandardIndexFieldTypeOptionsStep<?, ?> context, Class<?> expectedContextType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidFieldEncodingForScaledNumberFieldMapping$str(), context, new ClassFormatter(expectedContextType)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotReferenceExtractorsWhenExtractionDisabled$str() {
        return cannotReferenceExtractorsWhenExtractionDisabled;
    }

    @Override
    public final SearchException cannotReferenceExtractorsWhenExtractionDisabled() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotReferenceExtractorsWhenExtractionDisabled$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotResolveContainerExtractorName$str() {
        return cannotResolveContainerExtractorName;
    }

    @Override
    public final SearchException cannotResolveContainerExtractorName(String extractorName, Class<?> builtinExtractorConstantsClass) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotResolveContainerExtractorName$str(), extractorName, new ClassFormatter(builtinExtractorConstantsClass)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidAnnotationTypeForBinder$str() {
        return invalidAnnotationTypeForBinder;
    }

    @Override
    public final SearchException invalidAnnotationTypeForBinder(Object binder, Class<?> annotationType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidAnnotationTypeForBinder$str(), binder, new ClassFormatter(annotationType)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotPurgeNonIndexedContainedType$str() {
        return cannotPurgeNonIndexedContainedType;
    }

    @Override
    public final SearchException cannotPurgeNonIndexedContainedType(Class<?> typeManager, Object providedId) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotPurgeNonIndexedContainedType$str(), new ClassFormatter(typeManager), providedId));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotAccessPropertyMember$str() {
        return cannotAccessPropertyMember;
    }

    @Override
    public final SearchException cannotAccessPropertyMember(Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotAccessPropertyMember$str(), new Object[0]), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotAccessPropertyMethod$str() {
        return cannotAccessPropertyMethod;
    }

    @Override
    public final SearchException cannotAccessPropertyMethod(String propertyName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotAccessPropertyMethod$str(), propertyName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String missingBridgeForBinder$str() {
        return missingBridgeForBinder;
    }

    @Override
    public final SearchException missingBridgeForBinder(Object binder) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.missingBridgeForBinder$str(), binder));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String missingMarkerForBinder$str() {
        return missingMarkerForBinder;
    }

    @Override
    public final SearchException missingMarkerForBinder(Object binder) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.missingMarkerForBinder$str(), binder));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String recursiveWorkPlanPrepare$str() {
        return recursiveWorkPlanPrepare;
    }

    @Override
    public final SearchException recursiveWorkPlanPrepare() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.recursiveWorkPlanPrepare$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidIndexedEmbedded$str() {
        return invalidIndexedEmbedded;
    }

    @Override
    public final SearchException invalidIndexedEmbedded(PojoTypeModel<?> typeModel) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidIndexedEmbedded$str(), new PojoTypeModelFormatter(typeModel)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

