package org.hibernate.search.mapper.pojo.logging.impl;

import java.util.Locale;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathValueNode;
import java.io.Serializable;
import java.net.MalformedURLException;
import org.jboss.logging.DelegatingBasicLogger;
import org.hibernate.search.util.common.SearchException;
import java.lang.String;
import java.net.URISyntaxException;
import org.jboss.logging.Logger;
import java.lang.Exception;
import org.jboss.logging.BasicLogger;
import java.lang.Object;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.DEBUG;

/**
 * Warning this class consists of generated code.
 */
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    private static final String uselessIncludePathFilters = "HSEARCH000216: An IndexedEmbedded defines includePaths filters that do not match anything. Non-matching includePaths filters: %1$s. Encountered field paths: %2$s. Check the filters for typos, or remove them if they are not useful.";
    protected String uselessIncludePathFilters$str() {
        return uselessIncludePathFilters;
    }
    @Override
    public final SearchException uselessIncludePathFilters(final java.util.Set<String> nonMatchingIncludePaths, final java.util.Set<String> encounteredFieldPaths) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), uselessIncludePathFilters$str(), nonMatchingIncludePaths, encounteredFieldPaths));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String parseException = "HSEARCH000295: String '$1%s' cannot be parsed into a '$2%s'";
    protected String parseException$str() {
        return parseException;
    }
    @Override
    public final SearchException parseException(final String text, final Class<?> readerClass, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), parseException$str(), text, new org.hibernate.search.util.common.logging.impl.ClassFormatter(readerClass)), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String valueTooLargeForConversionException = "HSEARCH000297:  Value of '%2$s' for type '%1$s' is too big for the conversion";
    protected String valueTooLargeForConversionException$str() {
        return valueTooLargeForConversionException;
    }
    @Override
    public final SearchException valueTooLargeForConversionException(final Class<?> type, final Object duration, final Exception ae) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), valueTooLargeForConversionException$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(type), duration), ae);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToResolveDefaultIdentifierBridgeFromSourceType = "HSEARCH700001: Unable to find a default identifier bridge implementation for type '%1$s'";
    protected String unableToResolveDefaultIdentifierBridgeFromSourceType$str() {
        return unableToResolveDefaultIdentifierBridgeFromSourceType;
    }
    @Override
    public final SearchException unableToResolveDefaultIdentifierBridgeFromSourceType(final org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel<?> sourceType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToResolveDefaultIdentifierBridgeFromSourceType$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(sourceType)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToResolveDefaultValueBridgeFromSourceType = "HSEARCH700002: Unable to find a default value bridge implementation for type '%1$s'";
    protected String unableToResolveDefaultValueBridgeFromSourceType$str() {
        return unableToResolveDefaultValueBridgeFromSourceType;
    }
    @Override
    public final SearchException unableToResolveDefaultValueBridgeFromSourceType(final org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel<?> sourceType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToResolveDefaultValueBridgeFromSourceType$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(sourceType)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingBinderReferenceInBridgeMapping = "HSEARCH700003: Annotation type '%2$s' is annotated with '%1$s', but the binder reference is empty.";
    protected String missingBinderReferenceInBridgeMapping$str() {
        return missingBinderReferenceInBridgeMapping;
    }
    @Override
    public final SearchException missingBinderReferenceInBridgeMapping(final Class<? extends java.lang.annotation.Annotation> metaAnnotationType, final Class<? extends java.lang.annotation.Annotation> annotationType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingBinderReferenceInBridgeMapping$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(metaAnnotationType), new org.hibernate.search.util.common.logging.impl.ClassFormatter(annotationType)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingBinderReferenceInMarkerMapping = "HSEARCH700004: Annotation type '%2$s' is annotated with '%1$s', but the binder reference is empty.";
    protected String missingBinderReferenceInMarkerMapping$str() {
        return missingBinderReferenceInMarkerMapping;
    }
    @Override
    public final SearchException missingBinderReferenceInMarkerMapping(final Class<? extends java.lang.annotation.Annotation> metaAnnotationType, final Class<? extends java.lang.annotation.Annotation> annotationType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingBinderReferenceInMarkerMapping$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(metaAnnotationType), new org.hibernate.search.util.common.logging.impl.ClassFormatter(annotationType)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidFieldDefiningBothBridgeReferenceAndBinderReference = "HSEARCH700005: Annotation @GenericField on property '%1$s' defines both valueBridge and valueBinder. Only one of those can be defined, not both.";
    protected String invalidFieldDefiningBothBridgeReferenceAndBinderReference$str() {
        return invalidFieldDefiningBothBridgeReferenceAndBinderReference;
    }
    @Override
    public final SearchException invalidFieldDefiningBothBridgeReferenceAndBinderReference(final String property) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidFieldDefiningBothBridgeReferenceAndBinderReference$str(), property));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidDocumentIdDefiningBothBridgeReferenceAndBinderReference = "HSEARCH700006: Annotation @DocumentId on property '%1$s' defines both identifierBridge and identifierBinder. Only one of those can be defined, not both.";
    protected String invalidDocumentIdDefiningBothBridgeReferenceAndBinderReference$str() {
        return invalidDocumentIdDefiningBothBridgeReferenceAndBinderReference;
    }
    @Override
    public final SearchException invalidDocumentIdDefiningBothBridgeReferenceAndBinderReference(final String property) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidDocumentIdDefiningBothBridgeReferenceAndBinderReference$str(), property));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidEmptyTargetForScope = "HSEARCH700007: Invalid empty target for a scoped operation. If you want to target all indexes, use 'Object.class' as the target type.";
    protected String invalidEmptyTargetForScope$str() {
        return invalidEmptyTargetForScope;
    }
    @Override
    public final SearchException invalidEmptyTargetForScope() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidEmptyTargetForScope$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidInputTypeForBridge = "HSEARCH700010: Bridge '%1$s' cannot be applied to input type '%2$s'.";
    protected String invalidInputTypeForBridge$str() {
        return invalidInputTypeForBridge;
    }
    @Override
    public final SearchException invalidInputTypeForBridge(final Object bridge, final org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel<?> typeModel) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidInputTypeForBridge$str(), bridge, new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(typeModel)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingFieldNameForGeoPointBridgeOnType = "HSEARCH700011: Missing field name for GeoPointBinding on type %1$s. The field name is mandatory when the bridge is applied on an type, optional when applied on a property.";
    protected String missingFieldNameForGeoPointBridgeOnType$str() {
        return missingFieldNameForGeoPointBridgeOnType;
    }
    @Override
    public final SearchException missingFieldNameForGeoPointBridgeOnType(final String typeName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingFieldNameForGeoPointBridgeOnType$str(), typeName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotInferContainerExtractorClassTypePattern = "HSEARCH700015: Cannot interpret the type arguments to the ContainerExtractor interface in  implementation '%1$s'. Only the following implementations of ContainerExtractor are valid:  1) implementations setting both type parameters to *raw* types, e.g. class MyExtractor implements ContainerExtractor<MyBean, String>; 2) implementations setting the first type parameter to an array of an unbounded type variable, and setting the second parameter to the same type variable, e.g. MyExtractor<T> implements ContainerExtractor<T[], T> 3) implementations setting the first type parameter to a parameterized type with one argument set to an unbounded type variable and the other to unbounded wildcards, and setting the second type parameter to the same type variable, e.g. MyExtractor<T> implements ContainerExtractor<MyParameterizedBean<?, T, ?>, T>";
    protected String cannotInferContainerExtractorClassTypePattern$str() {
        return cannotInferContainerExtractorClassTypePattern;
    }
    @Override
    public final SearchException cannotInferContainerExtractorClassTypePattern(final Class<?> extractorClass, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotInferContainerExtractorClassTypePattern$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(extractorClass)), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidContainerExtractorForType = "HSEARCH700016: Cannot apply the requested container value extractor '%1$s' (implementation class: '%2$s') to type '%3$s'";
    protected String invalidContainerExtractorForType$str() {
        return invalidContainerExtractorForType;
    }
    @Override
    public final SearchException invalidContainerExtractorForType(final String extractorName, final Class<? extends org.hibernate.search.mapper.pojo.extractor.ContainerExtractor> extractorClass, final org.hibernate.search.mapper.pojo.model.spi.PojoGenericTypeModel<?> extractedType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidContainerExtractorForType$str(), extractorName, new org.hibernate.search.util.common.logging.impl.ClassFormatter(extractorClass), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(extractedType)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void createdPojoIndexedTypeManager(final org.hibernate.search.mapper.pojo.mapping.impl.PojoIndexedTypeManager<?, ?, ?> typeManager) {
        super.log.logf(FQCN, DEBUG, null, createdPojoIndexedTypeManager$str(), new org.hibernate.search.util.common.logging.impl.ToStringTreeAppendableMultilineFormatter(typeManager));
    }
    private static final String createdPojoIndexedTypeManager = "HSEARCH700017: Created POJO indexed type manager: %1$s";
    protected String createdPojoIndexedTypeManager$str() {
        return createdPojoIndexedTypeManager;
    }
    @Override
    public final void detectedEntityTypes(final java.util.Set<org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel<?>> entityTypes) {
        super.log.logf(FQCN, DEBUG, null, detectedEntityTypes$str(), entityTypes);
    }
    private static final String detectedEntityTypes = "HSEARCH700018: Detected entity types: %1$s";
    protected String detectedEntityTypes$str() {
        return detectedEntityTypes;
    }
    @Override
    public final void createdPojoContainedTypeManager(final org.hibernate.search.mapper.pojo.mapping.impl.PojoContainedTypeManager<?> typeManager) {
        super.log.logf(FQCN, DEBUG, null, createdPojoContainedTypeManager$str(), new org.hibernate.search.util.common.logging.impl.ToStringTreeAppendableMultilineFormatter(typeManager));
    }
    private static final String createdPojoContainedTypeManager = "HSEARCH700019: Created POJO contained type manager: %1$s";
    protected String createdPojoContainedTypeManager$str() {
        return createdPojoContainedTypeManager;
    }
    private static final String cannotInvertAssociationForReindexing = "HSEARCH700020: Cannot find the inverse side of the association on type '%2$s' at path '%3$s'. Hibernate Search needs this information in order to reindex '%2$s' when '%1$s' is modified. You can solve this error by defining the inverse side of this association,  either with annotations specific to your integration (@OneToMany(mappedBy = ...) in Hibernate ORM)  or with the Hibernate Search @AssociationInverseSide annotation. Alternatively, if you do not need to reindex '%2$s' when '%1$s' is modified, you can disable reindexing with @IndexingDependency(reindexOnUpdate = ReindexOnUpdate.NO).";
    protected String cannotInvertAssociationForReindexing$str() {
        return cannotInvertAssociationForReindexing;
    }
    @Override
    public final SearchException cannotInvertAssociationForReindexing(final org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel<?> inverseSideTypeModel, final org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel<?> typeModel, final PojoModelPathValueNode associationPath) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotInvertAssociationForReindexing$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(inverseSideTypeModel), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(typeModel), new org.hibernate.search.mapper.pojo.logging.spi.PojoModelPathFormatter(associationPath)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotApplyImplicitInverseAssociationPath = "HSEARCH700021: Cannot apply the path '%2$s' to type '%1$s'. This path was resolved as the inverse side of the association '%4$s' on type '%3$s'. Hibernate Search needs to apply this path in order to reindex '%3$s' when '%1$s' is modified. Error was: '%5$s'";
    protected String cannotApplyImplicitInverseAssociationPath$str() {
        return cannotApplyImplicitInverseAssociationPath;
    }
    @Override
    public final SearchException cannotApplyImplicitInverseAssociationPath(final org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel<?> inverseSideTypeModel, final PojoModelPathValueNode inverseSideAssociationPath, final org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel<?> originalSideTypeModel, final PojoModelPathValueNode originalSideAssociationPath, final String errorMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotApplyImplicitInverseAssociationPath$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(inverseSideTypeModel), new org.hibernate.search.mapper.pojo.logging.spi.PojoModelPathFormatter(inverseSideAssociationPath), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(originalSideTypeModel), new org.hibernate.search.mapper.pojo.logging.spi.PojoModelPathFormatter(originalSideAssociationPath), errorMessage), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String incorrectTargetTypeForInverseAssociation = "HSEARCH700022: The inverse association targets type '%1$s', but a supertype or subtype of '%2$s' was expected.";
    protected String incorrectTargetTypeForInverseAssociation$str() {
        return incorrectTargetTypeForInverseAssociation;
    }
    @Override
    public final SearchException incorrectTargetTypeForInverseAssociation(final org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel<?> inverseAssociationTargetType, final org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel<?> entityType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), incorrectTargetTypeForInverseAssociation$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(inverseAssociationTargetType), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(entityType)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingInversePathInAssociationInverseSideMapping = "HSEARCH700023: Property '%2$s' from type '%1$s' is annotated with @AssociationInverseSide, but the inverse path is empty.";
    protected String missingInversePathInAssociationInverseSideMapping$str() {
        return missingInversePathInAssociationInverseSideMapping;
    }
    @Override
    public final SearchException missingInversePathInAssociationInverseSideMapping(final org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel<?> typeModel, final String propertyName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingInversePathInAssociationInverseSideMapping$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(typeModel), propertyName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String infiniteRecursionForAssociationEmbeddeds = "HSEARCH700024: Found an infinite embedded recursion involving path '%2$s' on type '%1$s'";
    protected String infiniteRecursionForAssociationEmbeddeds$str() {
        return infiniteRecursionForAssociationEmbeddeds;
    }
    @Override
    public final SearchException infiniteRecursionForAssociationEmbeddeds(final org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel<?> typeModel, final PojoModelPathValueNode path) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), infiniteRecursionForAssociationEmbeddeds$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(typeModel), new org.hibernate.search.mapper.pojo.logging.spi.PojoModelPathFormatter(path)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String conflictingBridgeReferenceInBridgeMapping = "HSEARCH700026: Annotation type '%2$s' is annotated with '%1$s', but both a bridge reference and a binder reference were provided. Only one can be provided.";
    protected String conflictingBridgeReferenceInBridgeMapping$str() {
        return conflictingBridgeReferenceInBridgeMapping;
    }
    @Override
    public final SearchException conflictingBridgeReferenceInBridgeMapping(final Class<? extends java.lang.annotation.Annotation> metaAnnotationType, final Class<? extends java.lang.annotation.Annotation> annotationType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), conflictingBridgeReferenceInBridgeMapping$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(metaAnnotationType), new org.hibernate.search.util.common.logging.impl.ClassFormatter(annotationType)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingEntityTypeMetadata = "HSEARCH700027: Type '%1$s' is not marked as an entity type, yet it is indexed or targeted by an association from an indexed type. Please check your configuration.";
    protected String missingEntityTypeMetadata$str() {
        return missingEntityTypeMetadata;
    }
    @Override
    public final SearchException missingEntityTypeMetadata(final org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel<?> typeModel) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingEntityTypeMetadata$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(typeModel)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingIdentifierMapping = "HSEARCH700028: There isn't any explicit document ID mapping for indexed type '%1$s', and the entity ID cannot be used as a default because it is unknown.";
    protected String missingIdentifierMapping$str() {
        return missingIdentifierMapping;
    }
    @Override
    public final SearchException missingIdentifierMapping(final org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel<?> typeModel) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingIdentifierMapping$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(typeModel)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingPathInIndexingDependencyDerivedFrom = "HSEARCH700029: Property '%2$s' from type '%1$s' is annotated with @IndexingDependency, but 'derivedFrom' contains an empty path.";
    protected String missingPathInIndexingDependencyDerivedFrom$str() {
        return missingPathInIndexingDependencyDerivedFrom;
    }
    @Override
    public final SearchException missingPathInIndexingDependencyDerivedFrom(final org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel<?> typeModel, final String propertyName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingPathInIndexingDependencyDerivedFrom$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(typeModel), propertyName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String infiniteRecursionForDerivedFrom = "HSEARCH700030: Found a cyclic dependency between derived properties involving path '%2$s' on type '%1$s'. Derived properties cannot be marked as derived from themselves, even indirectly through other  derived properties. If your model actually contains such cyclic dependency,  you should consider disabling automatic reindexing, at least partially  using @IndexingDependency(reindexOnUpdate = ReindexOnUpdate.NO) on one of the properties in the cycle.";
    protected String infiniteRecursionForDerivedFrom$str() {
        return infiniteRecursionForDerivedFrom;
    }
    @Override
    public final SearchException infiniteRecursionForDerivedFrom(final org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel<?> typeModel, final PojoModelPathValueNode path) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), infiniteRecursionForDerivedFrom$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(typeModel), new org.hibernate.search.mapper.pojo.logging.spi.PojoModelPathFormatter(path)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidFieldEncodingForFullTextFieldMapping = "HSEARCH700031: This property is mapped to a full-text field, but with a value bridge that binds to a non-String or otherwise incompatible field. Make sure to use a compatible bridge. Details: encountered type DSL step '%1$s', which does not extend the expected '%2$s' interface.";
    protected String invalidFieldEncodingForFullTextFieldMapping$str() {
        return invalidFieldEncodingForFullTextFieldMapping;
    }
    @Override
    public final SearchException invalidFieldEncodingForFullTextFieldMapping(final org.hibernate.search.engine.backend.types.dsl.StandardIndexFieldTypeOptionsStep<?, ?> context, final Class<?> expectedContextType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidFieldEncodingForFullTextFieldMapping$str(), context, new org.hibernate.search.util.common.logging.impl.ClassFormatter(expectedContextType)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidFieldEncodingForKeywordFieldMapping = "HSEARCH700032: This property is mapped to a keyword field, but with a value bridge that binds to a non-String or otherwise incompatible field. Make sure to use a compatible bridge. Details: encountered type DSL step '%1$s', which does not extend the expected '%2$s' interface.";
    protected String invalidFieldEncodingForKeywordFieldMapping$str() {
        return invalidFieldEncodingForKeywordFieldMapping;
    }
    @Override
    public final SearchException invalidFieldEncodingForKeywordFieldMapping(final org.hibernate.search.engine.backend.types.dsl.StandardIndexFieldTypeOptionsStep<?, ?> context, final Class<?> expectedContextType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidFieldEncodingForKeywordFieldMapping$str(), context, new org.hibernate.search.util.common.logging.impl.ClassFormatter(expectedContextType)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String propertyMarkerNotFound = "HSEARCH700034: Could not find a property with the '%1$s' marker for field '%2$s' (marker set: '%3$s').";
    protected String propertyMarkerNotFound$str() {
        return propertyMarkerNotFound;
    }
    @Override
    public final SearchException propertyMarkerNotFound(final String markerName, final String fieldName, final String markerSet) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), propertyMarkerNotFound$str(), markerName, fieldName, markerSet));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String multiplePropertiesForMarker = "HSEARCH700035: Found multiple properties with the '%1$s' marker for field '%2$s' (marker set: '%3$s').";
    protected String multiplePropertiesForMarker$str() {
        return multiplePropertiesForMarker;
    }
    @Override
    public final SearchException multiplePropertiesForMarker(final String markerName, final String fieldName, final String markerSet) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), multiplePropertiesForMarker$str(), markerName, fieldName, markerSet));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidScopeTarget = "HSEARCH700036: Some of the given types cannot be targeted. These types are not indexed, nor is any of their subtypes: %1$s. Note that some of them are indexed-embedded in an indexed entity, but this is not enough to be targeted (only indexed types can be targeted): %2$s.";
    protected String invalidScopeTarget$str() {
        return invalidScopeTarget;
    }
    @Override
    public final SearchException invalidScopeTarget(final java.util.Collection<Class<?>> nonIndexedTypes, final java.util.Collection<Class<?>> containedTypes) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidScopeTarget$str(), nonIndexedTypes, containedTypes));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String notIndexedTypeNorAsDelegate = "HSEARCH700037: Cannot work on type %1$s, because it is not indexed, neither directly nor as a contained entity in another type.";
    protected String notIndexedTypeNorAsDelegate$str() {
        return notIndexedTypeNorAsDelegate;
    }
    @Override
    public final SearchException notIndexedTypeNorAsDelegate(final Class<?> targetedType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), notIndexedTypeNorAsDelegate$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(targetedType)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nullProvidedIdentifier = "HSEARCH700038: The identifier for this entity should always be provided, but the provided identifier was null.";
    protected String nullProvidedIdentifier$str() {
        return nullProvidedIdentifier;
    }
    @Override
    public final SearchException nullProvidedIdentifier() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), nullProvidedIdentifier$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String incompatibleRequestedType = "HSEARCH700039: Requested incompatible type for '%1$s': '%2$s'";
    protected String incompatibleRequestedType$str() {
        return incompatibleRequestedType;
    }
    @Override
    public final SearchException incompatibleRequestedType(final PojoModelPathValueNode accessor, final Class<?> requestedType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), incompatibleRequestedType$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoModelPathFormatter(accessor), new org.hibernate.search.util.common.logging.impl.ClassFormatter(requestedType)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String notDirectlyIndexedType = "HSEARCH700040: Cannot work on type %1$s, because it is not directly indexed.";
    protected String notDirectlyIndexedType$str() {
        return notDirectlyIndexedType;
    }
    @Override
    public final SearchException notDirectlyIndexedType(final Class<?> targetedType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), notDirectlyIndexedType$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(targetedType)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotUseDefaultExtractorsInMultiExtractorChain = "HSEARCH700041: A chain of multiple container extractors cannot include the default extractors. Either use only the default extractors, or explicitly reference every single extractor to be applied instead.";
    protected String cannotUseDefaultExtractorsInMultiExtractorChain$str() {
        return cannotUseDefaultExtractorsInMultiExtractorChain;
    }
    @Override
    public final SearchException cannotUseDefaultExtractorsInMultiExtractorChain() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotUseDefaultExtractorsInMultiExtractorChain$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String malformedURL = "HSEARCH700043: Error creating URL from String '%1$s'.";
    protected String malformedURL$str() {
        return malformedURL;
    }
    @Override
    public final SearchException malformedURL(final String value, final MalformedURLException e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), malformedURL$str(), value), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String badURISyntax = "HSEARCH700044: Error creating URI from String '%1$s'.";
    protected String badURISyntax$str() {
        return badURISyntax;
    }
    @Override
    public final SearchException badURISyntax(final String value, final URISyntaxException e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), badURISyntax$str(), value), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotDefinePojoModelPathWithoutProperty = "HSEARCH700045: A PojoModelPath must include at least one property.";
    protected String cannotDefinePojoModelPathWithoutProperty$str() {
        return cannotDefinePojoModelPathWithoutProperty;
    }
    @Override
    public final SearchException cannotDefinePojoModelPathWithoutProperty() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotDefinePojoModelPathWithoutProperty$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotApplyExplicitInverseAssociationPath = "HSEARCH700046: Cannot apply the path '%2$s' to type '%1$s'. This path was declared as a path to collect entities of type '%3$s' to be reindexed. Hibernate Search needs to apply this path in order to reindex '%3$s' when '%1$s' is modified. Error was: '%4$s'";
    protected String cannotApplyExplicitInverseAssociationPath$str() {
        return cannotApplyExplicitInverseAssociationPath;
    }
    @Override
    public final SearchException cannotApplyExplicitInverseAssociationPath(final org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel<?> inverseSideTypeModel, final PojoModelPathValueNode inverseSideAssociationPath, final org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel<?> originalSideTypeModel, final String errorMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotApplyExplicitInverseAssociationPath$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(inverseSideTypeModel), new org.hibernate.search.mapper.pojo.logging.spi.PojoModelPathFormatter(inverseSideAssociationPath), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(originalSideTypeModel), errorMessage), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotDefineOtherEntityDependencyOnNonEntityBridgedType = "HSEARCH700047: 'fromOtherEntity' can only be used when the bridged element has an entity type, but the bridged element has type '%1$s', which is not an entity type.";
    protected String cannotDefineOtherEntityDependencyOnNonEntityBridgedType$str() {
        return cannotDefineOtherEntityDependencyOnNonEntityBridgedType;
    }
    @Override
    public final SearchException cannotDefineOtherEntityDependencyOnNonEntityBridgedType(final org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel<?> bridgedTypeModel) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotDefineOtherEntityDependencyOnNonEntityBridgedType$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(bridgedTypeModel)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotDefineOtherEntityDependencyFromNonEntityType = "HSEARCH700048: 'fromOtherEntity' expects an entity type; type '%1$s' is not an entity type.";
    protected String cannotDefineOtherEntityDependencyFromNonEntityType$str() {
        return cannotDefineOtherEntityDependencyFromNonEntityType;
    }
    @Override
    public final SearchException cannotDefineOtherEntityDependencyFromNonEntityType(final org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel<?> otherType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotDefineOtherEntityDependencyFromNonEntityType$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(otherType)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingBridgeDependencyDeclaration = "HSEARCH700049: The binder did not declare any dependency to the entity model during binding. Declare dependencies using context.getDependencies().use(...) or, if the bridge really does not depend on the entity model, context.getDependencies().useRootOnly().";
    protected String missingBridgeDependencyDeclaration$str() {
        return missingBridgeDependencyDeclaration;
    }
    @Override
    public final SearchException missingBridgeDependencyDeclaration() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingBridgeDependencyDeclaration$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String inconsistentBridgeDependencyDeclaration = "HSEARCH700050: The binder called context.getDependencies().useRootOnly() during binding, but also declared extra dependencies to the entity model.";
    protected String inconsistentBridgeDependencyDeclaration$str() {
        return inconsistentBridgeDependencyDeclaration;
    }
    @Override
    public final SearchException inconsistentBridgeDependencyDeclaration() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), inconsistentBridgeDependencyDeclaration$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidFieldEncodingForScaledNumberFieldMapping = "HSEARCH700051: This property is mapped to a scaled number field, but with a value bridge that binds neither to a BigDecimal nor to a BigInteger field. Make sure to use a compatible bridge. Details: encountered type DSL step '%1$s', which does not extend the expected '%2$s' interface.";
    protected String invalidFieldEncodingForScaledNumberFieldMapping$str() {
        return invalidFieldEncodingForScaledNumberFieldMapping;
    }
    @Override
    public final SearchException invalidFieldEncodingForScaledNumberFieldMapping(final org.hibernate.search.engine.backend.types.dsl.StandardIndexFieldTypeOptionsStep<?, ?> context, final Class<?> expectedContextType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidFieldEncodingForScaledNumberFieldMapping$str(), context, new org.hibernate.search.util.common.logging.impl.ClassFormatter(expectedContextType)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotReferenceExtractorsWhenExtractionDisabled = "HSEARCH700052: Extractors cannot be defined explicitly when extract = ContainerExtract.NO. Either leave 'extract' to its default value to define extractors explicitly or leave the 'extractor' list to its default, empty value to disable extraction.";
    protected String cannotReferenceExtractorsWhenExtractionDisabled$str() {
        return cannotReferenceExtractorsWhenExtractionDisabled;
    }
    @Override
    public final SearchException cannotReferenceExtractorsWhenExtractionDisabled() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotReferenceExtractorsWhenExtractionDisabled$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotResolveContainerExtractorName = "HSEARCH700053: Cannot resolve container extractor name '%1$s'. Check that this name matches a container extractor, either a builtin one whose name is a constant in '%2$s' or a custom one that was properly registered.";
    protected String cannotResolveContainerExtractorName$str() {
        return cannotResolveContainerExtractorName;
    }
    @Override
    public final SearchException cannotResolveContainerExtractorName(final String extractorName, final Class<?> builtinExtractorConstantsClass) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotResolveContainerExtractorName$str(), extractorName, new org.hibernate.search.util.common.logging.impl.ClassFormatter(builtinExtractorConstantsClass)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidAnnotationTypeForBinder = "HSEARCH700054: Binder '%1$s' cannot be initialized with annotations of type '%2$s'.";
    protected String invalidAnnotationTypeForBinder$str() {
        return invalidAnnotationTypeForBinder;
    }
    @Override
    public final SearchException invalidAnnotationTypeForBinder(final Object binder, final Class<?> annotationType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidAnnotationTypeForBinder$str(), binder, new org.hibernate.search.util.common.logging.impl.ClassFormatter(annotationType)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotPurgeNonIndexedContainedType = "HSEARCH700055: Type '%1$s' is contained in an indexed type but is not itself indexed, thus entity with identifier '%2$s' cannot be purged. Use delete() and pass the entity instead of just the identifier.";
    protected String cannotPurgeNonIndexedContainedType$str() {
        return cannotPurgeNonIndexedContainedType;
    }
    @Override
    public final SearchException cannotPurgeNonIndexedContainedType(final Class<?> typeManager, final Object providedId) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotPurgeNonIndexedContainedType$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(typeManager), providedId));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotAccessPropertyMember = "HSEARCH700056: Could not access to the org.hibernate.annotations.common.reflection.java.JavaXMember#getMember method";
    protected String cannotAccessPropertyMember$str() {
        return cannotAccessPropertyMember;
    }
    @Override
    public final SearchException cannotAccessPropertyMember(final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotAccessPropertyMember$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotAccessPropertyMethod = "HSEARCH700057: The underlying member of property '%1$s' is supposed to be a method";
    protected String cannotAccessPropertyMethod$str() {
        return cannotAccessPropertyMethod;
    }
    @Override
    public final SearchException cannotAccessPropertyMethod(final String propertyName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotAccessPropertyMethod$str(), propertyName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingBridgeForBinder = "HSEARCH700058: The bind() method of binder '%1$s' is not implemented correctly: it did not call context.setBridge().";
    protected String missingBridgeForBinder$str() {
        return missingBridgeForBinder;
    }
    @Override
    public final SearchException missingBridgeForBinder(final Object binder) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingBridgeForBinder$str(), binder));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingMarkerForBinder = "HSEARCH700059: The bind() method of binder '%1$s' is not implemented correctly: it did not call context.setMarker(...).";
    protected String missingMarkerForBinder$str() {
        return missingMarkerForBinder;
    }
    @Override
    public final SearchException missingMarkerForBinder(final Object binder) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingMarkerForBinder$str(), binder));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String recursiveWorkPlanPrepare = "HSEARCH700060: Entity processing was triggered while already processing entities, which is not supported. Make sure you do not change entities within an entity getter or a custom bridge used for indexing, and avoid any event that could trigger entity processing. Hibernate ORM flushes, in particular, must be avoided in entity getters and bridges.";
    protected String recursiveWorkPlanPrepare$str() {
        return recursiveWorkPlanPrepare;
    }
    @Override
    public final SearchException recursiveWorkPlanPrepare() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), recursiveWorkPlanPrepare$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidIndexedEmbedded = "HSEARCH700061: Type '%1$s' cannot be indexed-embedded, because no index mapping (@GenericField, @FullTextField, ...) is defined for that type.";
    protected String invalidIndexedEmbedded$str() {
        return invalidIndexedEmbedded;
    }
    @Override
    public final SearchException invalidIndexedEmbedded(final org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel<?> typeModel) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidIndexedEmbedded$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(typeModel)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
