/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.standalone.session.impl;

import java.util.Collection;
import java.util.function.Consumer;
import org.hibernate.search.engine.common.EntityReference;
import org.hibernate.search.engine.search.common.NonStaticMetamodelScope;
import org.hibernate.search.engine.search.query.dsl.SearchQuerySelectStep;
import org.hibernate.search.mapper.pojo.loading.spi.PojoSelectionLoadingContext;
import org.hibernate.search.mapper.pojo.model.spi.PojoRuntimeIntrospector;
import org.hibernate.search.mapper.pojo.scope.spi.PojoScopeSessionContext;
import org.hibernate.search.mapper.pojo.session.spi.AbstractPojoSearchSession;
import org.hibernate.search.mapper.pojo.session.spi.PojoSearchSessionMappingContext;
import org.hibernate.search.mapper.pojo.standalone.loading.dsl.SelectionLoadingOptionsStep;
import org.hibernate.search.mapper.pojo.standalone.loading.impl.StandalonePojoLoadingContext;
import org.hibernate.search.mapper.pojo.standalone.loading.impl.StandalonePojoLoadingSessionContext;
import org.hibernate.search.mapper.pojo.standalone.loading.impl.StandalonePojoSelectionLoadingContextBuilder;
import org.hibernate.search.mapper.pojo.standalone.logging.impl.SessionLog;
import org.hibernate.search.mapper.pojo.standalone.mapping.impl.ConfiguredIndexingPlanSynchronizationStrategyHolder;
import org.hibernate.search.mapper.pojo.standalone.massindexing.MassIndexer;
import org.hibernate.search.mapper.pojo.standalone.massindexing.impl.StandalonePojoMassIndexingSessionContext;
import org.hibernate.search.mapper.pojo.standalone.reporting.impl.StandalonePojoMapperHints;
import org.hibernate.search.mapper.pojo.standalone.schema.management.SearchSchemaManager;
import org.hibernate.search.mapper.pojo.standalone.scope.SearchScope;
import org.hibernate.search.mapper.pojo.standalone.scope.StandalonePojoRootReferenceScope;
import org.hibernate.search.mapper.pojo.standalone.scope.TypedSearchScope;
import org.hibernate.search.mapper.pojo.standalone.scope.impl.SearchScopeImpl;
import org.hibernate.search.mapper.pojo.standalone.session.SearchSession;
import org.hibernate.search.mapper.pojo.standalone.session.SearchSessionBuilder;
import org.hibernate.search.mapper.pojo.standalone.session.impl.StandalonePojoSearchSessionMappingContext;
import org.hibernate.search.mapper.pojo.standalone.session.impl.StandalonePojoSearchSessionTypeContextProvider;
import org.hibernate.search.mapper.pojo.standalone.work.SearchIndexer;
import org.hibernate.search.mapper.pojo.standalone.work.SearchIndexingPlan;
import org.hibernate.search.mapper.pojo.standalone.work.SearchWorkspace;
import org.hibernate.search.mapper.pojo.standalone.work.impl.SearchIndexerImpl;
import org.hibernate.search.mapper.pojo.standalone.work.impl.SearchIndexingPlanImpl;
import org.hibernate.search.mapper.pojo.work.IndexingPlanSynchronizationStrategy;
import org.hibernate.search.mapper.pojo.work.spi.ConfiguredIndexingPlanSynchronizationStrategy;
import org.hibernate.search.mapper.pojo.work.spi.ConfiguredSearchIndexingPlanFilter;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexer;
import org.hibernate.search.mapper.pojo.work.spi.PojoWorkSessionContext;
import org.hibernate.search.util.common.impl.CollectionHelper;

public class StandalonePojoSearchSession
extends AbstractPojoSearchSession
implements SearchSession,
StandalonePojoMassIndexingSessionContext,
StandalonePojoLoadingSessionContext {
    private static final ConfiguredSearchIndexingPlanFilter ACCEPT_ALL = typeIdentifier -> true;
    private final StandalonePojoSearchSessionMappingContext mappingContext;
    private final StandalonePojoSearchSessionTypeContextProvider typeContextProvider;
    private final String tenantId;
    private final Consumer<SelectionLoadingOptionsStep> loadingOptionsContributor;
    private final ConfiguredIndexingPlanSynchronizationStrategyHolder synchronizationStrategyHolder;
    private final ConfiguredSearchIndexingPlanFilter configuredIndexingPlanFilter;
    private SearchIndexingPlanImpl indexingPlan;
    private SearchIndexer indexer;
    private boolean open = true;
    private ConfiguredIndexingPlanSynchronizationStrategy indexingPlanSynchronizationStrategy;

    private StandalonePojoSearchSession(Builder builder) {
        super((PojoSearchSessionMappingContext)builder.mappingContext);
        this.mappingContext = builder.mappingContext;
        this.typeContextProvider = builder.typeContextProvider;
        this.tenantId = builder.tenantId;
        this.loadingOptionsContributor = builder.loadingOptionsContributor;
        this.synchronizationStrategyHolder = builder.synchronizationStrategyHolder;
        this.indexingPlanSynchronizationStrategy = this.synchronizationStrategyHolder.configureOverriddenSynchronizationStrategy(builder.synchronizationStrategy);
        this.configuredIndexingPlanFilter = ACCEPT_ALL;
    }

    private void checkOpenAndThrow() {
        if (!this.open) {
            throw SessionLog.INSTANCE.hibernateSessionAccessError(StandalonePojoMapperHints.INSTANCE.closedSession());
        }
    }

    @Override
    public void close() {
        if (!this.open) {
            return;
        }
        this.open = false;
        if (this.indexingPlan != null) {
            this.indexingPlan.execute();
        }
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public MassIndexer massIndexer(Collection<? extends Class<?>> classes) {
        this.checkOpenAndThrow();
        return ((SearchScopeImpl)this.scope(classes)).massIndexer(CollectionHelper.asSetIgnoreNull((Object[])new Object[]{this.tenantIdentifierValue()}));
    }

    @Override
    public String tenantIdentifier() {
        return this.tenantId;
    }

    @Override
    public Object tenantIdentifierValue() {
        return this.mappingContext.tenancyConfiguration().convert(this.tenantId);
    }

    @Override
    public void indexingPlanSynchronizationStrategy(IndexingPlanSynchronizationStrategy synchronizationStrategy) {
        this.indexingPlanSynchronizationStrategy = this.synchronizationStrategyHolder.configureOverriddenSynchronizationStrategy(synchronizationStrategy);
    }

    public PojoIndexer createIndexer() {
        return this.mappingContext.createIndexer((PojoWorkSessionContext)this);
    }

    @Override
    public PojoRuntimeIntrospector runtimeIntrospector() {
        return this.mappingContext.runtimeIntrospector();
    }

    @Override
    public <T> SearchQuerySelectStep<NonStaticMetamodelScope, ?, EntityReference, T, ?, ?, ?> search(Collection<? extends Class<? extends T>> classes) {
        return this.search((SearchScopeImpl)this.scope((Collection)classes));
    }

    @Override
    public <T> SearchQuerySelectStep<?, ?, EntityReference, T, ?, ?, ?> search(SearchScope<T> scope) {
        return this.search((SearchScopeImpl)scope);
    }

    @Override
    public <SR, T> SearchQuerySelectStep<SR, ?, EntityReference, T, ?, ?, ?> search(TypedSearchScope<SR, T> scope) {
        return this.search((SearchScopeImpl)scope);
    }

    @Override
    public <SR, T> SearchQuerySelectStep<SR, ?, EntityReference, T, ?, ?, ?> search(StandalonePojoRootReferenceScope<SR, T> referenceScope) {
        TypedSearchScope<SR, T> scope = referenceScope.scope(this);
        return this.search(scope);
    }

    @Override
    public SearchSchemaManager schemaManager(Collection<? extends Class<?>> classes) {
        return ((SearchScopeImpl)this.scope(classes)).schemaManager();
    }

    @Override
    public SearchWorkspace workspace(Collection<? extends Class<?>> classes) {
        return ((SearchScopeImpl)this.scope(classes)).workspace(this.tenantIdentifierValue());
    }

    public <T> SearchScopeImpl<NonStaticMetamodelScope, T> scope(Collection<? extends Class<? extends T>> types) {
        return this.mappingContext.createScope(NonStaticMetamodelScope.class, types);
    }

    public <T> SearchScopeImpl<NonStaticMetamodelScope, T> scope(Class<T> expectedSuperType, Collection<String> entityNames) {
        return this.mappingContext.createScope(NonStaticMetamodelScope.class, expectedSuperType, entityNames);
    }

    public <SR, T> SearchScopeImpl<SR, T> typedScope(Class<SR> rootScope, Collection<? extends Class<? extends T>> classes) {
        return this.mappingContext().createScope(rootScope, classes);
    }

    @Override
    public SearchIndexingPlan indexingPlan() {
        if (this.indexingPlan == null) {
            this.indexingPlan = new SearchIndexingPlanImpl(this.typeContextProvider, this.runtimeIntrospector(), this.mappingContext().createIndexingPlan((PojoWorkSessionContext)this, this.indexingPlanSynchronizationStrategy.documentCommitStrategy(), this.indexingPlanSynchronizationStrategy.documentRefreshStrategy()), this.indexingPlanSynchronizationStrategy);
        }
        return this.indexingPlan;
    }

    @Override
    public SearchIndexer indexer() {
        if (this.indexer == null) {
            this.indexer = new SearchIndexerImpl(this.runtimeIntrospector(), this.mappingContext().createIndexer((PojoWorkSessionContext)this), this.indexingPlanSynchronizationStrategy.documentCommitStrategy(), this.indexingPlanSynchronizationStrategy.documentRefreshStrategy());
        }
        return this.indexer;
    }

    public PojoSelectionLoadingContext defaultLoadingContext() {
        return this.loadingContextBuilder().build();
    }

    public ConfiguredSearchIndexingPlanFilter configuredIndexingPlanFilter() {
        return this.configuredIndexingPlanFilter;
    }

    public StandalonePojoSearchSessionMappingContext mappingContext() {
        return this.mappingContext;
    }

    private <SR, T> SearchQuerySelectStep<SR, ?, EntityReference, T, ?, ?, ?> search(SearchScopeImpl<SR, T> scope) {
        return scope.search((PojoScopeSessionContext)this, this.loadingContextBuilder());
    }

    private StandalonePojoSelectionLoadingContextBuilder loadingContextBuilder() {
        StandalonePojoLoadingContext.Builder builder = this.mappingContext.loadingContextBuilder();
        if (this.loadingOptionsContributor != null) {
            this.loadingOptionsContributor.accept(builder);
        }
        return builder;
    }

    public static class Builder
    implements SearchSessionBuilder {
        private final StandalonePojoSearchSessionMappingContext mappingContext;
        private final StandalonePojoSearchSessionTypeContextProvider typeContextProvider;
        private final ConfiguredIndexingPlanSynchronizationStrategyHolder synchronizationStrategyHolder;
        private IndexingPlanSynchronizationStrategy synchronizationStrategy;
        private String tenantId;
        private Consumer<SelectionLoadingOptionsStep> loadingOptionsContributor;

        public Builder(StandalonePojoSearchSessionMappingContext mappingContext, ConfiguredIndexingPlanSynchronizationStrategyHolder synchronizationStrategyHolder, StandalonePojoSearchSessionTypeContextProvider typeContextProvider) {
            this.synchronizationStrategyHolder = synchronizationStrategyHolder;
            this.mappingContext = mappingContext;
            this.typeContextProvider = typeContextProvider;
        }

        @Override
        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Override
        public SearchSessionBuilder tenantId(Object tenantId) {
            this.tenantId = this.mappingContext.tenancyConfiguration().convert(tenantId);
            return this;
        }

        @Override
        public SearchSessionBuilder indexingPlanSynchronizationStrategy(IndexingPlanSynchronizationStrategy synchronizationStrategy) {
            this.synchronizationStrategy = synchronizationStrategy;
            return this;
        }

        @Override
        public SearchSessionBuilder loading(Consumer<SelectionLoadingOptionsStep> loadingOptionsContributor) {
            this.loadingOptionsContributor = loadingOptionsContributor;
            return this;
        }

        @Override
        public StandalonePojoSearchSession build() {
            return new StandalonePojoSearchSession(this);
        }
    }
}

