/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.standalone.logging.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.hibernate.search.engine.environment.bean.spi.BeanProvider;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.standalone.logging.impl.ConfigurationLog;
import org.hibernate.search.mapper.pojo.standalone.logging.impl.MappingLog;
import org.hibernate.search.mapper.pojo.standalone.logging.impl.SessionLog;
import org.hibernate.search.mapper.pojo.standalone.logging.impl.StandaloneMapperLog;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.hibernate.search.util.common.logging.impl.CommaSeparatedClassesFormatter;
import org.jboss.logging.Logger;

public class StandaloneMapperLog_$logger
implements StandaloneMapperLog,
ConfigurationLog,
MappingLog,
SessionLog,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = StandaloneMapperLog_$logger.class.getName();
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;

    public StandaloneMapperLog_$logger(Logger log) {
        this.log = log;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void nextLoggerIdForConvenience() {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.nextLoggerIdForConvenience$str(), new Object[0]);
    }

    protected String nextLoggerIdForConvenience$str() {
        return "HSEARCH750019: ";
    }

    protected String invalidStringForBeanProvider$str() {
        return "HSEARCH750011: Invalid String value for the bean provider: '%s'. The bean provider must be an instance of '%s'.";
    }

    @Override
    public final SearchException invalidStringForBeanProvider(String value, Class<BeanProvider> expectedType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidStringForBeanProvider$str(), value, expectedType));
        StandaloneMapperLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) {
            e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        }
    }

    protected String invalidSchemaManagementStrategyName$str() {
        return "HSEARCH750015: Invalid schema management strategy name: '%1$s'. Valid names are: %2$s.";
    }

    @Override
    public final SearchException invalidSchemaManagementStrategyName(String invalidRepresentation, List<String> validRepresentations) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidSchemaManagementStrategyName$str(), invalidRepresentation, validRepresentations));
        StandaloneMapperLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String errorRetrievingTypeModel$str() {
        return "HSEARCH750003: Unable to retrieve type model for class '%1$s'.";
    }

    @Override
    public final SearchException errorRetrievingTypeModel(Class<?> clazz, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.errorRetrievingTypeModel$str(), new ClassFormatter(clazz)), (Throwable)cause);
        StandaloneMapperLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String namedTypesNotSupported$str() {
        return "HSEARCH750007: Type with name '%1$s' does not exist: the standalone POJO mapper does not support named types.";
    }

    @Override
    public final SearchException namedTypesNotSupported(String name) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.namedTypesNotSupported$str(), name));
        StandaloneMapperLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unknownClassForIndexedEntityType$str() {
        return "HSEARCH750009: No matching indexed entity type for class '%1$s'. Either this class is not an entity type, or the entity type is not indexed in Hibernate Search. Valid classes for indexed entity types are: %2$s";
    }

    @Override
    public final SearchException unknownClassForIndexedEntityType(Class<?> invalidClass, Collection<Class<?>> validClasses) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownClassForIndexedEntityType$str(), new ClassFormatter(invalidClass), new CommaSeparatedClassesFormatter(validClasses)));
        StandaloneMapperLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unknownEntityNameForIndexedEntityType$str() {
        return "HSEARCH750010: No matching indexed entity type for name '%1$s'. Either this is not the name of an entity type, or the entity type is not indexed in Hibernate Search. Valid names for indexed entity types are: %2$s";
    }

    @Override
    public final SearchException unknownEntityNameForIndexedEntityType(String invalidName, Collection<String> validNames) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownEntityNameForIndexedEntityType$str(), invalidName, validNames));
        StandaloneMapperLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unknownTypeIdentifierForMappedEntityType$str() {
        return "HSEARCH750016: No matching entity type for type identifier '%1$s'. Either this type is not an entity type, or the entity type is not mapped in Hibernate Search. Valid identifiers for mapped entity types are: %2$s";
    }

    @Override
    public final SearchException unknownTypeIdentifierForMappedEntityType(PojoRawTypeIdentifier<?> invalidTypeId, Collection<PojoRawTypeIdentifier<?>> validTypeIds) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownTypeIdentifierForMappedEntityType$str(), invalidTypeId, validTypeIds));
        StandaloneMapperLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unknownTypeIdentifierForIndexedEntityType$str() {
        return "HSEARCH750017: No matching indexed entity type for type identifier '%1$s'. Either this type is not an entity type, or the entity type is not indexed in Hibernate Search. Valid identifiers for indexed entity types are: %2$s";
    }

    @Override
    public final SearchException unknownTypeIdentifierForIndexedEntityType(PojoRawTypeIdentifier<?> invalidTypeId, Collection<PojoRawTypeIdentifier<?>> validTypeIds) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownTypeIdentifierForIndexedEntityType$str(), invalidTypeId, validTypeIds));
        StandaloneMapperLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unknownClassForMappedEntityType$str() {
        return "HSEARCH750018: No matching entity type for class '%1$s'. Either this class is not an entity type, or the entity type is not mapped in Hibernate Search. Valid classes for mapped entity types are: %2$s";
    }

    @Override
    public final SearchException unknownClassForMappedEntityType(Class<?> invalidClass, Collection<Class<?>> validClasses) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownClassForMappedEntityType$str(), new ClassFormatter(invalidClass), new CommaSeparatedClassesFormatter(validClasses)));
        StandaloneMapperLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String hibernateSessionAccessError$str() {
        return "HSEARCH750014: Unable to access search session: %1$s";
    }

    @Override
    public final SearchException hibernateSessionAccessError(String causeMessage) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.hibernateSessionAccessError$str(), causeMessage));
        StandaloneMapperLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }
}

