/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.standalone.logging.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.standalone.logging.impl.MappingLog;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.hibernate.search.util.common.logging.impl.CommaSeparatedClassesFormatter;
import org.jboss.logging.Logger;

public class MappingLog_$logger
implements MappingLog,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = MappingLog_$logger.class.getName();
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;

    public MappingLog_$logger(Logger log) {
        this.log = log;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String errorRetrievingTypeModel$str() {
        return "HSEARCH750003: Unable to retrieve type model for class '%1$s'.";
    }

    @Override
    public final SearchException errorRetrievingTypeModel(Class<?> clazz, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.errorRetrievingTypeModel$str(), new ClassFormatter(clazz)), (Throwable)cause);
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) {
            e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        }
    }

    protected String namedTypesNotSupported$str() {
        return "HSEARCH750007: Type with name '%1$s' does not exist: the standalone POJO mapper does not support named types.";
    }

    @Override
    public final SearchException namedTypesNotSupported(String name) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.namedTypesNotSupported$str(), name));
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unknownClassForIndexedEntityType$str() {
        return "HSEARCH750009: No matching indexed entity type for class '%1$s'. Either this class is not an entity type, or the entity type is not indexed in Hibernate Search. Valid classes for indexed entity types are: %2$s";
    }

    @Override
    public final SearchException unknownClassForIndexedEntityType(Class<?> invalidClass, Collection<Class<?>> validClasses) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownClassForIndexedEntityType$str(), new ClassFormatter(invalidClass), new CommaSeparatedClassesFormatter(validClasses)));
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unknownEntityNameForIndexedEntityType$str() {
        return "HSEARCH750010: No matching indexed entity type for name '%1$s'. Either this is not the name of an entity type, or the entity type is not indexed in Hibernate Search. Valid names for indexed entity types are: %2$s";
    }

    @Override
    public final SearchException unknownEntityNameForIndexedEntityType(String invalidName, Collection<String> validNames) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownEntityNameForIndexedEntityType$str(), invalidName, validNames));
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unknownTypeIdentifierForMappedEntityType$str() {
        return "HSEARCH750016: No matching entity type for type identifier '%1$s'. Either this type is not an entity type, or the entity type is not mapped in Hibernate Search. Valid identifiers for mapped entity types are: %2$s";
    }

    @Override
    public final SearchException unknownTypeIdentifierForMappedEntityType(PojoRawTypeIdentifier<?> invalidTypeId, Collection<PojoRawTypeIdentifier<?>> validTypeIds) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownTypeIdentifierForMappedEntityType$str(), invalidTypeId, validTypeIds));
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unknownTypeIdentifierForIndexedEntityType$str() {
        return "HSEARCH750017: No matching indexed entity type for type identifier '%1$s'. Either this type is not an entity type, or the entity type is not indexed in Hibernate Search. Valid identifiers for indexed entity types are: %2$s";
    }

    @Override
    public final SearchException unknownTypeIdentifierForIndexedEntityType(PojoRawTypeIdentifier<?> invalidTypeId, Collection<PojoRawTypeIdentifier<?>> validTypeIds) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownTypeIdentifierForIndexedEntityType$str(), invalidTypeId, validTypeIds));
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unknownClassForMappedEntityType$str() {
        return "HSEARCH750018: No matching entity type for class '%1$s'. Either this class is not an entity type, or the entity type is not mapped in Hibernate Search. Valid classes for mapped entity types are: %2$s";
    }

    @Override
    public final SearchException unknownClassForMappedEntityType(Class<?> invalidClass, Collection<Class<?>> validClasses) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownClassForMappedEntityType$str(), new ClassFormatter(invalidClass), new CommaSeparatedClassesFormatter(validClasses)));
        MappingLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }
}

