/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.standalone.logging.impl;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.CategorizedLogger;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.hibernate.search.util.common.logging.impl.CommaSeparatedClassesFormatter;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.FormatWith;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@CategorizedLogger(category="org.hibernate.search.mapping.mapper.standalone")
@MessageLogger(projectCode="HSEARCH")
public interface MappingLog {
    public static final String CATEGORY_NAME = "org.hibernate.search.mapping.mapper.standalone";
    public static final MappingLog INSTANCE = (MappingLog)LoggerFactory.make(MappingLog.class, (String)"org.hibernate.search.mapping.mapper.standalone", (MethodHandles.Lookup)MethodHandles.lookup());

    @Message(id=750003, value="Unable to retrieve type model for class '%1$s'.")
    public SearchException errorRetrievingTypeModel(@FormatWith(value=ClassFormatter.class) Class<?> var1, @Cause Exception var2);

    @Message(id=750007, value="Type with name '%1$s' does not exist: the standalone POJO mapper does not support named types.")
    public SearchException namedTypesNotSupported(String var1);

    @Message(id=750009, value="No matching indexed entity type for class '%1$s'. Either this class is not an entity type, or the entity type is not indexed in Hibernate Search. Valid classes for indexed entity types are: %2$s")
    public SearchException unknownClassForIndexedEntityType(@FormatWith(value=ClassFormatter.class) Class<?> var1, @FormatWith(value=CommaSeparatedClassesFormatter.class) Collection<Class<?>> var2);

    @Message(id=750010, value="No matching indexed entity type for name '%1$s'. Either this is not the name of an entity type, or the entity type is not indexed in Hibernate Search. Valid names for indexed entity types are: %2$s")
    public SearchException unknownEntityNameForIndexedEntityType(String var1, Collection<String> var2);

    @Message(id=750016, value="No matching entity type for type identifier '%1$s'. Either this type is not an entity type, or the entity type is not mapped in Hibernate Search. Valid identifiers for mapped entity types are: %2$s")
    public SearchException unknownTypeIdentifierForMappedEntityType(PojoRawTypeIdentifier<?> var1, Collection<PojoRawTypeIdentifier<?>> var2);

    @Message(id=750017, value="No matching indexed entity type for type identifier '%1$s'. Either this type is not an entity type, or the entity type is not indexed in Hibernate Search. Valid identifiers for indexed entity types are: %2$s")
    public SearchException unknownTypeIdentifierForIndexedEntityType(PojoRawTypeIdentifier<?> var1, Collection<PojoRawTypeIdentifier<?>> var2);

    @Message(id=750018, value="No matching entity type for class '%1$s'. Either this class is not an entity type, or the entity type is not mapped in Hibernate Search. Valid classes for mapped entity types are: %2$s")
    public SearchException unknownClassForMappedEntityType(@FormatWith(value=ClassFormatter.class) Class<?> var1, @FormatWith(value=CommaSeparatedClassesFormatter.class) Collection<Class<?>> var2);
}

