/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.standalone.tenancy.impl;

import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.tenancy.spi.TenancyMode;
import org.hibernate.search.mapper.pojo.standalone.cfg.StandalonePojoMapperSettings;
import org.hibernate.search.mapper.pojo.tenancy.TenantIdentifierConverter;

public class TenancyConfiguration
implements AutoCloseable {
    private static final ConfigurationProperty<BeanReference<? extends TenantIdentifierConverter>> MULTI_TENANCY_TENANT_IDENTIFIER_CONVERTER = ConfigurationProperty.forKey((String)"mapping.multi_tenancy.tenant_identifier_converter").asBeanReference(TenantIdentifierConverter.class).withDefault(StandalonePojoMapperSettings.Defaults.MULTI_TENANCY_TENANT_IDENTIFIER_CONVERTER).build();
    private final TenancyMode tenancyMode;
    private final BeanHolder<? extends TenantIdentifierConverter> tenantIdentifierConverter;

    public static TenancyConfiguration create(BeanResolver beanResolver, TenancyMode tenancyMode, ConfigurationPropertySource configurationPropertySource) {
        BeanHolder tenantIdentifierConverter = (BeanHolder)MULTI_TENANCY_TENANT_IDENTIFIER_CONVERTER.getAndTransform(configurationPropertySource, arg_0 -> ((BeanResolver)beanResolver).resolve(arg_0));
        return new TenancyConfiguration(tenancyMode, (BeanHolder<? extends TenantIdentifierConverter>)tenantIdentifierConverter);
    }

    private TenancyConfiguration(TenancyMode tenancyMode, BeanHolder<? extends TenantIdentifierConverter> tenantIdentifierConverter) {
        this.tenancyMode = tenancyMode;
        this.tenantIdentifierConverter = tenantIdentifierConverter;
    }

    public Object convert(String tenantIdentifier) {
        return ((TenantIdentifierConverter)this.tenantIdentifierConverter.get()).fromStringValue(tenantIdentifier);
    }

    public String convert(Object tenantIdentifier) {
        return ((TenantIdentifierConverter)this.tenantIdentifierConverter.get()).toStringValue(tenantIdentifier);
    }

    public TenancyMode tenancyMode() {
        return this.tenancyMode;
    }

    @Override
    public void close() {
        if (this.tenantIdentifierConverter != null) {
            this.tenantIdentifierConverter.close();
        }
    }
}

