/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.standalone.massindexing.impl;

import java.util.concurrent.CompletionStage;
import org.hibernate.search.mapper.pojo.massindexing.MassIndexingEnvironment;
import org.hibernate.search.mapper.pojo.massindexing.MassIndexingFailureHandler;
import org.hibernate.search.mapper.pojo.massindexing.MassIndexingMonitor;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexer;
import org.hibernate.search.mapper.pojo.standalone.loading.impl.StandalonePojoLoadingContext;
import org.hibernate.search.mapper.pojo.standalone.massindexing.MassIndexer;

public class StandalonePojoMassIndexer
implements MassIndexer {
    private final PojoMassIndexer delegate;
    private final StandalonePojoLoadingContext context;

    public StandalonePojoMassIndexer(PojoMassIndexer delegate, StandalonePojoLoadingContext context) {
        this.delegate = delegate;
        this.context = context;
    }

    @Override
    public MassIndexer typesToIndexInParallel(int threadsToIndexObjects) {
        this.delegate.typesToIndexInParallel(threadsToIndexObjects);
        return this;
    }

    @Override
    public MassIndexer threadsToLoadObjects(int numberOfThreads) {
        this.delegate.threadsToLoadObjects(numberOfThreads);
        return this;
    }

    @Override
    public MassIndexer batchSizeToLoadObjects(int batchSize) {
        this.context.batchSize(batchSize);
        return this;
    }

    @Override
    public MassIndexer mergeSegmentsOnFinish(boolean enable) {
        this.delegate.mergeSegmentsOnFinish(enable);
        return this;
    }

    @Override
    public MassIndexer mergeSegmentsAfterPurge(boolean enable) {
        this.delegate.mergeSegmentsAfterPurge(enable);
        return this;
    }

    @Override
    public MassIndexer dropAndCreateSchemaOnStart(boolean dropAndCreateSchema) {
        this.delegate.dropAndCreateSchemaOnStart(dropAndCreateSchema);
        return this;
    }

    @Override
    public MassIndexer purgeAllOnStart(boolean purgeAll) {
        this.delegate.purgeAllOnStart(purgeAll);
        return this;
    }

    @Override
    public CompletionStage<?> start() {
        return this.delegate.start();
    }

    @Override
    public void startAndWait() throws InterruptedException {
        this.delegate.startAndWait();
    }

    @Override
    public MassIndexer monitor(MassIndexingMonitor monitor) {
        this.delegate.monitor(monitor);
        return this;
    }

    @Override
    public MassIndexer failureHandler(MassIndexingFailureHandler failureHandler) {
        this.delegate.failureHandler(failureHandler);
        return this;
    }

    @Override
    public MassIndexer failureFloodingThreshold(long threshold) {
        this.delegate.failureFloodingThreshold(threshold);
        return this;
    }

    @Override
    public <T> MassIndexer context(Class<T> contextType, T context) {
        this.context.context(contextType, context);
        return this;
    }

    @Override
    public MassIndexer environment(MassIndexingEnvironment environment) {
        this.delegate.environment(environment);
        return this;
    }
}

