/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.standalone.mapping.impl;

import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingFinalizationContext;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingPartialBuildState;
import org.hibernate.search.mapper.pojo.mapping.spi.PojoMappingDelegate;
import org.hibernate.search.mapper.pojo.massindexing.MassIndexingDefaultCleanOperation;
import org.hibernate.search.mapper.pojo.standalone.cfg.StandalonePojoMapperSettings;
import org.hibernate.search.mapper.pojo.standalone.mapping.impl.StandalonePojoMapping;
import org.hibernate.search.mapper.pojo.standalone.mapping.impl.StandalonePojoTypeContextContainer;
import org.hibernate.search.mapper.pojo.standalone.schema.management.SchemaManagementStrategyName;
import org.hibernate.search.mapper.pojo.standalone.schema.management.impl.SchemaManagementListener;

public class StandalonePojoMappingPartialBuildState
implements MappingPartialBuildState {
    private static final ConfigurationProperty<SchemaManagementStrategyName> SCHEMA_MANAGEMENT_STRATEGY = ConfigurationProperty.forKey((String)"schema_management.strategy").as(SchemaManagementStrategyName.class, SchemaManagementStrategyName::of).withDefault((Object)StandalonePojoMapperSettings.Defaults.SCHEMA_MANAGEMENT_STRATEGY).build();
    private static final ConfigurationProperty<MassIndexingDefaultCleanOperation> INDEXING_MASS_DEFAULT_CLEAN_OPERATION = ConfigurationProperty.forKey((String)"indexing.mass.default_clean_operation").as(MassIndexingDefaultCleanOperation.class, MassIndexingDefaultCleanOperation::of).withDefault((Object)StandalonePojoMapperSettings.Defaults.INDEXING_MASS_DEFAULT_CLEAN_OPERATION).build();
    private final PojoMappingDelegate mappingDelegate;
    private final StandalonePojoTypeContextContainer typeContextContainer;

    StandalonePojoMappingPartialBuildState(PojoMappingDelegate mappingDelegate, StandalonePojoTypeContextContainer typeContextContainer) {
        this.mappingDelegate = mappingDelegate;
        this.typeContextContainer = typeContextContainer;
    }

    public void closeOnFailure() {
        this.mappingDelegate.close();
    }

    public StandalonePojoMapping finalizeMapping(MappingFinalizationContext context) {
        SchemaManagementStrategyName schemaManagementStrategyName = (SchemaManagementStrategyName)((Object)SCHEMA_MANAGEMENT_STRATEGY.get(context.configurationPropertySource()));
        SchemaManagementListener schemaManagementListener = new SchemaManagementListener(schemaManagementStrategyName);
        return new StandalonePojoMapping(this.mappingDelegate, this.typeContextContainer, schemaManagementListener, (MassIndexingDefaultCleanOperation)INDEXING_MASS_DEFAULT_CLEAN_OPERATION.get(context.configurationPropertySource()));
    }
}

