/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.standalone.work.impl;

import java.util.BitSet;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.model.spi.PojoRuntimeIntrospector;
import org.hibernate.search.mapper.pojo.route.DocumentRoutesDescriptor;
import org.hibernate.search.mapper.pojo.standalone.work.SearchIndexingPlan;
import org.hibernate.search.mapper.pojo.standalone.work.impl.SearchIndexingPlanTypeContext;
import org.hibernate.search.mapper.pojo.standalone.work.impl.SearchIndexingPlanTypeContextProvider;
import org.hibernate.search.mapper.pojo.work.spi.ConfiguredIndexingPlanSynchronizationStrategy;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexingPlan;
import org.hibernate.search.mapper.pojo.work.spi.PojoTypeIndexingPlan;

public class SearchIndexingPlanImpl
implements SearchIndexingPlan {
    private final SearchIndexingPlanTypeContextProvider typeContextProvider;
    private final PojoRuntimeIntrospector introspector;
    private final PojoIndexingPlan delegate;
    private final ConfiguredIndexingPlanSynchronizationStrategy indexingPlanSynchronizationStrategy;

    public SearchIndexingPlanImpl(SearchIndexingPlanTypeContextProvider typeContextProvider, PojoRuntimeIntrospector introspector, PojoIndexingPlan delegate, ConfiguredIndexingPlanSynchronizationStrategy indexingPlanSynchronizationStrategy) {
        this.typeContextProvider = typeContextProvider;
        this.introspector = introspector;
        this.delegate = delegate;
        this.indexingPlanSynchronizationStrategy = indexingPlanSynchronizationStrategy;
    }

    @Override
    public void add(Object entity) {
        this.add(null, null, entity);
    }

    @Override
    public void add(Object providedId, DocumentRoutesDescriptor providedRoutes, Object entity) {
        PojoTypeIndexingPlan typeDelegate = this.delegate.typeIfIncludedOrNull(this.getTypeIdentifier(entity));
        if (typeDelegate == null) {
            return;
        }
        typeDelegate.add(providedId, providedRoutes, entity);
    }

    @Override
    public void add(Class<?> entityClass, Object providedId, DocumentRoutesDescriptor providedRoutes) {
        PojoTypeIndexingPlan typeDelegate = this.delegate.typeIfIncludedOrNull(this.getTypeIdentifier(entityClass));
        if (typeDelegate == null) {
            return;
        }
        typeDelegate.add(providedId, providedRoutes, null);
    }

    @Override
    public void addOrUpdate(Object entity) {
        this.addOrUpdate(null, null, entity);
    }

    @Override
    public void addOrUpdate(Object providedId, DocumentRoutesDescriptor providedRoutes, Object entity) {
        PojoTypeIndexingPlan typeDelegate = this.delegate.typeIfIncludedOrNull(this.getTypeIdentifier(entity));
        if (typeDelegate == null) {
            return;
        }
        typeDelegate.addOrUpdate(providedId, providedRoutes, entity, true, true, null);
    }

    @Override
    public void addOrUpdate(Object entity, String ... dirtyPaths) {
        this.addOrUpdate(null, null, entity, false, false, dirtyPaths);
    }

    @Override
    public void addOrUpdate(Object providedId, DocumentRoutesDescriptor providedRoutes, Object entity, String ... dirtyPaths) {
        this.addOrUpdate(providedId, providedRoutes, entity, false, false, dirtyPaths);
    }

    @Override
    public void addOrUpdate(Object providedId, DocumentRoutesDescriptor providedRoutes, Object entity, boolean forceSelfDirty, boolean forceContainingDirty, String ... dirtyPathsAsStrings) {
        PojoRawTypeIdentifier<Object> typeIdentifier = this.getTypeIdentifier(entity);
        PojoTypeIndexingPlan typeDelegate = this.delegate.typeIfIncludedOrNull(typeIdentifier);
        if (typeDelegate == null) {
            return;
        }
        SearchIndexingPlanTypeContext<Object> typeContext = this.typeContextProvider.forExactType(typeIdentifier);
        BitSet dirtyPaths = typeContext.dirtyFilter().filter(dirtyPathsAsStrings);
        typeDelegate.addOrUpdate(providedId, providedRoutes, entity, forceSelfDirty, forceContainingDirty, dirtyPaths);
    }

    @Override
    public void addOrUpdate(Class<?> entityClass, Object providedId, DocumentRoutesDescriptor providedRoutes) {
        PojoRawTypeIdentifier<?> typeIdentifier = this.getTypeIdentifier(entityClass);
        PojoTypeIndexingPlan typeDelegate = this.delegate.typeIfIncludedOrNull(typeIdentifier);
        if (typeDelegate == null) {
            return;
        }
        typeDelegate.addOrUpdate(providedId, providedRoutes, null, true, true, null);
    }

    @Override
    public void delete(Object entity) {
        this.delete(null, null, entity);
    }

    @Override
    public void delete(Object providedId, DocumentRoutesDescriptor providedRoutes, Object entity) {
        PojoTypeIndexingPlan typeDelegate = this.delegate.typeIfIncludedOrNull(this.getTypeIdentifier(entity));
        if (typeDelegate == null) {
            return;
        }
        typeDelegate.delete(providedId, providedRoutes, entity);
    }

    @Override
    public void purge(Class<?> entityClass, Object providedId, DocumentRoutesDescriptor providedRoutes) {
        PojoTypeIndexingPlan typeDelegate = this.delegate.typeIfIncludedOrNull(this.getTypeIdentifier(entityClass));
        if (typeDelegate == null) {
            return;
        }
        typeDelegate.delete(providedId, providedRoutes, null);
    }

    @Override
    public void addOrUpdateOrDelete(Class<?> entityClass, Object providedId, DocumentRoutesDescriptor providedRoutes, boolean forceSelfDirty, boolean forceContainingDirty, String ... dirtyPathsAsStrings) {
        SearchIndexingPlanTypeContext<?> typeContext = this.typeContextProvider.forExactClass(entityClass);
        PojoTypeIndexingPlan typeDelegate = this.delegate.typeIfIncludedOrNull(typeContext.typeIdentifier());
        if (typeDelegate == null) {
            return;
        }
        BitSet dirtyPaths = typeContext.dirtyFilter().filter(dirtyPathsAsStrings);
        typeDelegate.addOrUpdateOrDelete(providedId, providedRoutes, forceSelfDirty, forceContainingDirty, dirtyPaths);
    }

    public void execute() {
        this.indexingPlanSynchronizationStrategy.executeAndSynchronize(this.delegate);
    }

    private <T> PojoRawTypeIdentifier<? extends T> getTypeIdentifier(T entity) {
        return this.introspector.detectEntityType(entity);
    }

    private <T> PojoRawTypeIdentifier<T> getTypeIdentifier(Class<T> entityType) {
        return this.typeContextProvider.forExactClass(entityType).typeIdentifier();
    }
}

