/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.binding.impl;

import org.hibernate.search.engine.backend.types.dsl.IndexFieldTypeOptionsStep;
import org.hibernate.search.engine.backend.types.dsl.ScaledNumberIndexFieldTypeOptionsStep;
import org.hibernate.search.engine.backend.types.dsl.SearchableProjectableIndexFieldTypeOptionsStep;
import org.hibernate.search.engine.backend.types.dsl.StandardIndexFieldTypeOptionsStep;
import org.hibernate.search.engine.backend.types.dsl.StringIndexFieldTypeOptionsStep;
import org.hibernate.search.engine.backend.types.dsl.VectorFieldTypeOptionsStep;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.spi.FieldModelContributorContext;
import org.hibernate.search.mapper.pojo.logging.impl.MappingLog;

final class FieldModelContributorContextImpl<F>
implements FieldModelContributorContext {
    private final ValueBridge<?, F> bridge;
    private final IndexFieldTypeOptionsStep<?, ? super F> fieldTypeOptionsStep;

    FieldModelContributorContextImpl(ValueBridge<?, F> bridge, IndexFieldTypeOptionsStep<?, ? super F> fieldTypeOptionsStep) {
        this.bridge = bridge;
        this.fieldTypeOptionsStep = fieldTypeOptionsStep;
    }

    @Override
    public void indexNullAs(String value) {
        this.searchableProjectableIndexFieldTypeOptionsStep().indexNullAs(this.bridge.parse(value));
    }

    public StandardIndexFieldTypeOptionsStep<?, ? super F> standardTypeOptionsStep() {
        if (this.fieldTypeOptionsStep instanceof StandardIndexFieldTypeOptionsStep) {
            return (StandardIndexFieldTypeOptionsStep)this.fieldTypeOptionsStep;
        }
        throw MappingLog.INSTANCE.invalidFieldEncodingForStandardFieldMapping(this.fieldTypeOptionsStep, StandardIndexFieldTypeOptionsStep.class);
    }

    @Override
    public StringIndexFieldTypeOptionsStep<?> stringTypeOptionsStep() {
        if (this.fieldTypeOptionsStep instanceof StringIndexFieldTypeOptionsStep) {
            return (StringIndexFieldTypeOptionsStep)this.fieldTypeOptionsStep;
        }
        throw MappingLog.INSTANCE.invalidFieldEncodingForStringFieldMapping(this.fieldTypeOptionsStep, StringIndexFieldTypeOptionsStep.class);
    }

    @Override
    public ScaledNumberIndexFieldTypeOptionsStep<?, ?> scaledNumberTypeOptionsStep() {
        if (this.fieldTypeOptionsStep instanceof ScaledNumberIndexFieldTypeOptionsStep) {
            return (ScaledNumberIndexFieldTypeOptionsStep)this.fieldTypeOptionsStep;
        }
        throw MappingLog.INSTANCE.invalidFieldEncodingForScaledNumberFieldMapping(this.fieldTypeOptionsStep, ScaledNumberIndexFieldTypeOptionsStep.class);
    }

    @Override
    public VectorFieldTypeOptionsStep<?, ?> vectorTypeOptionsStep() {
        if (this.fieldTypeOptionsStep instanceof VectorFieldTypeOptionsStep) {
            return (VectorFieldTypeOptionsStep)this.fieldTypeOptionsStep;
        }
        throw MappingLog.INSTANCE.invalidFieldEncodingForVectorFieldMapping(this.fieldTypeOptionsStep, VectorFieldTypeOptionsStep.class);
    }

    public SearchableProjectableIndexFieldTypeOptionsStep<?, ? super F> searchableProjectableIndexFieldTypeOptionsStep() {
        if (this.fieldTypeOptionsStep instanceof VectorFieldTypeOptionsStep) {
            return (VectorFieldTypeOptionsStep)this.fieldTypeOptionsStep;
        }
        return this.standardTypeOptionsStep();
    }

    @Override
    public void checkNonStandardTypeOptionsStep() {
        if (this.fieldTypeOptionsStep instanceof StandardIndexFieldTypeOptionsStep) {
            throw MappingLog.INSTANCE.invalidFieldEncodingForNonStandardFieldMapping(this.fieldTypeOptionsStep, StandardIndexFieldTypeOptionsStep.class);
        }
    }
}

