/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.search.definition.binding.builtin;

import java.util.Optional;
import org.hibernate.search.engine.common.tree.TreeFilterDefinition;
import org.hibernate.search.engine.search.projection.ProjectionCollector;
import org.hibernate.search.mapper.pojo.logging.impl.ProjectionLog;
import org.hibernate.search.mapper.pojo.model.PojoModelValue;
import org.hibernate.search.mapper.pojo.search.definition.binding.ProjectionBinder;
import org.hibernate.search.mapper.pojo.search.definition.binding.ProjectionBindingContext;

public final class ObjectProjectionBinder
implements ProjectionBinder {
    private final String fieldPathOrNull;
    private TreeFilterDefinition filter = TreeFilterDefinition.includeAll();

    public static ObjectProjectionBinder create() {
        return ObjectProjectionBinder.create(null);
    }

    public static ObjectProjectionBinder create(String fieldPath) {
        return new ObjectProjectionBinder(fieldPath);
    }

    private ObjectProjectionBinder(String fieldPathOrNull) {
        this.fieldPathOrNull = fieldPathOrNull;
    }

    public String toString() {
        return "ObjectProjectionBinder(...)";
    }

    public ObjectProjectionBinder filter(TreeFilterDefinition filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public void bind(ProjectionBindingContext context) {
        Class<?> containerClass;
        Class<?> containerElementClass;
        Optional<PojoModelValue<?>> containerElementOptional = context.containerElement();
        String fieldPath = this.fieldPathOrFail(context);
        if (containerElementOptional.isPresent()) {
            PojoModelValue<?> containerElement = containerElementOptional.get();
            containerElementClass = containerElement.rawType();
            containerClass = context.constructorParameter().rawType();
        } else {
            containerElementClass = context.constructorParameter().rawType();
            containerClass = null;
        }
        this.bind(context, fieldPath, containerClass, containerElementClass);
    }

    private <T, C> void bind(ProjectionBindingContext context, String fieldPath, Class<C> containerType, Class<T> containerElementType) {
        ProjectionCollector.Provider collector = context.projectionCollectorProviderFactory().projectionCollectorProvider(containerType, containerElementType);
        context.definition(containerElementType, context.createObjectDefinition(fieldPath, containerElementType, this.filter, collector));
    }

    private String fieldPathOrFail(ProjectionBindingContext context) {
        if (this.fieldPathOrNull != null) {
            return this.fieldPathOrNull;
        }
        Optional<String> paramName = context.constructorParameter().name();
        if (!paramName.isPresent()) {
            throw ProjectionLog.INSTANCE.missingParameterNameForObjectProjectionInProjectionConstructor();
        }
        return paramName.get();
    }
}

