/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.search.definition.binding.builtin;

import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.definition.ProjectionDefinitionContext;
import org.hibernate.search.engine.search.projection.definition.spi.AbstractProjectionDefinition;
import org.hibernate.search.mapper.pojo.search.definition.binding.ProjectionBinder;
import org.hibernate.search.mapper.pojo.search.definition.binding.ProjectionBindingContext;
import org.hibernate.search.util.common.spi.ToStringTreeAppender;

public final class IdProjectionBinder
implements ProjectionBinder {
    private static final IdProjectionBinder INSTANCE = new IdProjectionBinder();

    public static IdProjectionBinder create() {
        return INSTANCE;
    }

    private IdProjectionBinder() {
    }

    @Override
    public void bind(ProjectionBindingContext context) {
        this.bind(context, context.constructorParameter().rawType());
    }

    private <T> void bind(ProjectionBindingContext context, Class<T> constructorParameterType) {
        context.definition(constructorParameterType, new Definition<T>(constructorParameterType));
    }

    private static class Definition<I>
    extends AbstractProjectionDefinition<I> {
        private final Class<I> requestedIdentifierType;

        private Definition(Class<I> requestedIdentifierType) {
            this.requestedIdentifierType = requestedIdentifierType;
        }

        protected String type() {
            return "id";
        }

        public void appendTo(ToStringTreeAppender appender) {
            super.appendTo(appender);
            appender.attribute("requestedIdentifierType", this.requestedIdentifierType);
        }

        public SearchProjection<I> create(ProjectionDefinitionContext context) {
            return context.projection().id(this.requestedIdentifierType).toProjection();
        }
    }
}

