/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.common.spi;

import java.util.Objects;
import org.hibernate.search.engine.common.EntityReference;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;

public final class PojoEntityReference
implements EntityReference {
    private final PojoRawTypeIdentifier<?> typeIdentifier;
    private final String name;
    private final Object id;

    public static EntityReference withDefaultName(Class<?> javaClass, Object id) {
        return PojoEntityReference.withName(javaClass, javaClass.getSimpleName(), id);
    }

    public static EntityReference withName(Class<?> javaClass, String entityName, Object id) {
        return new PojoEntityReference(PojoRawTypeIdentifier.of(javaClass), entityName, id);
    }

    public PojoEntityReference(PojoRawTypeIdentifier<?> typeIdentifier, String name, Object id) {
        this.typeIdentifier = typeIdentifier;
        this.name = name;
        this.id = id;
    }

    public Class<?> type() {
        return this.typeIdentifier.javaClass();
    }

    public String name() {
        return this.name;
    }

    public Object id() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EntityReference)) {
            return false;
        }
        EntityReference other = (EntityReference)obj;
        return this.name.equals(other.name()) && Objects.equals(this.id, other.id());
    }

    public int hashCode() {
        return Objects.hash(this.name, this.id);
    }

    public String toString() {
        return this.name + "#" + String.valueOf(this.id);
    }
}

