/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.model.models.spi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.FieldDetails;
import org.hibernate.models.spi.MemberDetails;
import org.hibernate.search.engine.mapper.model.spi.MappableTypeModel;
import org.hibernate.search.mapper.pojo.model.models.spi.AbstractPojoModelsBootstrapIntrospector;
import org.hibernate.search.mapper.pojo.model.models.spi.PojoModelsConstructorModel;
import org.hibernate.search.mapper.pojo.model.spi.AbstractPojoRawTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.GenericContextAwarePojoGenericTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoConstructorModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel;

public abstract class AbstractPojoModelsRawTypeModel<T, I extends AbstractPojoModelsBootstrapIntrospector>
extends AbstractPojoRawTypeModel<T, I> {
    protected final ClassDetails classDetails;
    final GenericContextAwarePojoGenericTypeModel.RawTypeDeclaringContext<T> rawTypeDeclaringContext;
    private Map<String, MemberDetails> declaredFieldAccessPropertiesByName;
    private Map<String, List<MemberDetails>> declaredMethodAccessPropertiesByName;

    public AbstractPojoModelsRawTypeModel(I introspector, PojoRawTypeIdentifier<T> typeIdentifier, GenericContextAwarePojoGenericTypeModel.RawTypeDeclaringContext<T> rawTypeDeclaringContext) {
        super(introspector, typeIdentifier);
        this.classDetails = ((AbstractPojoModelsBootstrapIntrospector)introspector).toModelsClass(typeIdentifier.javaClass());
        this.rawTypeDeclaringContext = rawTypeDeclaringContext;
    }

    public boolean isAbstract() {
        return this.classDetails.isAbstract();
    }

    public final boolean isSubTypeOf(MappableTypeModel other) {
        return other instanceof AbstractPojoModelsRawTypeModel && ((AbstractPojoModelsRawTypeModel)other).classDetails.toJavaClass().isAssignableFrom(this.classDetails.toJavaClass());
    }

    @Override
    public Optional<PojoTypeModel<?>> typeArgument(Class<?> rawSuperType, int typeParameterIndex) {
        return this.rawTypeDeclaringContext.typeArgument(rawSuperType, typeParameterIndex);
    }

    @Override
    public Optional<PojoTypeModel<?>> arrayElementType() {
        return this.rawTypeDeclaringContext.arrayElementType();
    }

    @Override
    public Stream<? extends Annotation> annotations() {
        return ((AbstractPojoModelsBootstrapIntrospector)this.introspector).annotations((AnnotationTarget)this.classDetails);
    }

    @Override
    protected List<PojoConstructorModel<T>> createDeclaredConstructors() {
        return Arrays.stream(this.javaClass().getDeclaredConstructors()).map(constructor -> new PojoModelsConstructorModel((AbstractPojoModelsBootstrapIntrospector)this.introspector, this, constructor)).collect(Collectors.toList());
    }

    Class<T> javaClass() {
        return this.typeIdentifier.javaClass();
    }

    @Override
    protected final Stream<String> declaredPropertyNames() {
        return Stream.concat(this.declaredFieldAccessPropertiesByName().keySet().stream(), this.declaredMethodAccessPropertiesByName().keySet().stream()).distinct();
    }

    protected final Map<String, MemberDetails> declaredFieldAccessPropertiesByName() {
        if (this.declaredFieldAccessPropertiesByName == null) {
            this.declaredFieldAccessPropertiesByName = ((AbstractPojoModelsBootstrapIntrospector)this.introspector).declaredFieldAccessPropertiesByName(this.classDetails);
        }
        return this.declaredFieldAccessPropertiesByName;
    }

    protected final Map<String, List<MemberDetails>> declaredMethodAccessPropertiesByName() {
        if (this.declaredMethodAccessPropertiesByName == null) {
            this.declaredMethodAccessPropertiesByName = ((AbstractPojoModelsBootstrapIntrospector)this.introspector).declaredMethodAccessPropertiesByName(this.classDetails);
        }
        return this.declaredMethodAccessPropertiesByName;
    }

    protected final List<Member> declaredPropertyGetters(String propertyName) {
        List<MemberDetails> methodAccessProperties = this.declaredMethodAccessPropertiesByName().get(propertyName);
        if (methodAccessProperties != null) {
            return methodAccessProperties.stream().map(MemberDetails::toJavaMember).collect(Collectors.toList());
        }
        return null;
    }

    protected final Member declaredPropertyField(String propertyName) {
        FieldDetails fieldAccessProperty = this.classDetails.findFieldByName(propertyName);
        if (fieldAccessProperty != null) {
            return fieldAccessProperty.toJavaMember();
        }
        return null;
    }
}

