/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.massindexing.impl;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.search.mapper.pojo.loading.spi.PojoMassIdentifierLoader;
import org.hibernate.search.mapper.pojo.loading.spi.PojoMassIdentifierLoadingContext;
import org.hibernate.search.mapper.pojo.loading.spi.PojoMassIdentifierSink;
import org.hibernate.search.mapper.pojo.loading.spi.PojoMassLoadingContext;
import org.hibernate.search.mapper.pojo.loading.spi.PojoMassLoadingStrategy;
import org.hibernate.search.mapper.pojo.logging.impl.MassIndexingLog;
import org.hibernate.search.mapper.pojo.massindexing.MassIndexingEnvironment;
import org.hibernate.search.mapper.pojo.massindexing.MassIndexingTypeGroupMonitor;
import org.hibernate.search.mapper.pojo.massindexing.impl.MassIndexingTypeGroupContext;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoMassIndexingFailureHandledRunnable;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoMassIndexingIndexedTypeGroup;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoMassIndexingNotifier;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoProducerConsumerQueue;
import org.hibernate.search.mapper.pojo.reporting.impl.PojoMassIndexerMessages;

public class PojoMassIndexingEntityIdentifierLoadingRunnable<E, I>
extends PojoMassIndexingFailureHandledRunnable {
    private final MassIndexingTypeGroupMonitor typeGroupMonitor;
    private final MassIndexingTypeGroupContext<E> massIndexingTypeGroupContext;
    private final PojoMassIndexingIndexedTypeGroup<E> typeGroup;
    private final PojoMassLoadingStrategy<E, I> loadingStrategy;
    private final PojoProducerConsumerQueue<List<I>> identifierQueue;
    private final MassIndexingEnvironment.EntityIdentifierLoadingContext identifierLoadingContext;

    public PojoMassIndexingEntityIdentifierLoadingRunnable(PojoMassIndexingNotifier notifier, MassIndexingTypeGroupMonitor typeGroupMonitor, MassIndexingTypeGroupContext<E> massIndexingTypeGroupContext, MassIndexingEnvironment environment, PojoMassIndexingIndexedTypeGroup<E> typeGroup, PojoMassLoadingStrategy<E, I> loadingStrategy, PojoProducerConsumerQueue<List<I>> identifierQueue) {
        super(notifier, environment);
        this.typeGroupMonitor = typeGroupMonitor;
        this.massIndexingTypeGroupContext = massIndexingTypeGroupContext;
        this.loadingStrategy = loadingStrategy;
        this.typeGroup = typeGroup;
        this.identifierQueue = identifierQueue;
        this.identifierLoadingContext = new EntityIdentifierLoadingContextImpl();
    }

    @Override
    protected void runWithFailureHandler() throws InterruptedException {
        MassIndexingLog.INSTANCE.identifierLoadingStarted(this.typeGroup.notifiedGroupName());
        LoadingContext context = new LoadingContext();
        try (PojoMassIdentifierLoader loader = this.loadingStrategy.createIdentifierLoader(this.typeGroup.includedTypes(), context);){
            this.typeGroupMonitor.indexingStarted(this.massIndexingTypeGroupContext.withIdentifierLoader(loader));
            do {
                loader.loadNext();
            } while (!context.done);
            this.identifierQueue.producerStopping();
        }
        MassIndexingLog.INSTANCE.identifierLoadingFinished(this.typeGroup.notifiedGroupName());
    }

    @Override
    protected void cleanUpOnFailure() {
    }

    @Override
    protected void cleanUpOnInterruption() {
    }

    @Override
    protected MassIndexingEnvironment.Context createMassIndexingEnvironmentContext() {
        return this.identifierLoadingContext;
    }

    @Override
    protected boolean supportsThreadLifecycleHooks() {
        return true;
    }

    @Override
    protected String operationName() {
        return PojoMassIndexerMessages.INSTANCE.massIndexerFetchingIds(this.typeGroup.notifiedGroupName());
    }

    private static final class EntityIdentifierLoadingContextImpl
    implements MassIndexingEnvironment.EntityIdentifierLoadingContext {
        private EntityIdentifierLoadingContextImpl() {
        }
    }

    private class LoadingContext
    implements PojoMassIdentifierLoadingContext<I> {
        private boolean done = false;

        private LoadingContext() {
        }

        @Override
        public PojoMassLoadingContext parent() {
            return PojoMassIndexingEntityIdentifierLoadingRunnable.this.massIndexingTypeGroupContext.massIndexingContext();
        }

        @Override
        public PojoMassIdentifierSink<I> createSink() {
            return new PojoMassIdentifierSink<I>(){

                @Override
                public void accept(List<? extends I> batch) throws InterruptedException {
                    MassIndexingLog.INSTANCE.identifierLoadingLoadedIds(batch);
                    ArrayList copy = new ArrayList(batch);
                    PojoMassIndexingEntityIdentifierLoadingRunnable.this.identifierQueue.put(copy);
                }

                @Override
                public void complete() {
                    LoadingContext.this.done = true;
                }
            };
        }

        @Override
        public String tenantIdentifier() {
            return PojoMassIndexingEntityIdentifierLoadingRunnable.this.massIndexingTypeGroupContext.tenantIdentifier();
        }
    }
}

