/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.impl;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Optional;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.mapping.annotation.ValueBinderRef;
import org.hibernate.search.mapper.pojo.bridge.mapping.annotation.ValueBridgeRef;
import org.hibernate.search.mapper.pojo.bridge.mapping.impl.BeanBinder;
import org.hibernate.search.mapper.pojo.bridge.mapping.impl.BeanDelegatingBinder;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.ValueBinder;
import org.hibernate.search.mapper.pojo.extractor.mapping.annotation.ContainerExtraction;
import org.hibernate.search.mapper.pojo.extractor.mapping.programmatic.ContainerExtractorPath;
import org.hibernate.search.mapper.pojo.logging.impl.MappingLog;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.MappingAnnotationProcessorContext;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.PropertyMappingAnnotationProcessor;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.PropertyMappingAnnotationProcessorContext;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.PropertyMappingFieldOptionsStep;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.PropertyMappingStep;

abstract class AbstractFieldAnnotationProcessor<A extends Annotation>
implements PropertyMappingAnnotationProcessor<A> {
    AbstractFieldAnnotationProcessor() {
    }

    @Override
    public final void process(PropertyMappingStep mappingContext, A annotation, PropertyMappingAnnotationProcessorContext context) {
        String cleanedUpRelativeFieldName = context.toNullIfDefault(this.getName(annotation), "");
        PropertyMappingFieldOptionsStep<?> fieldContext = this.initFieldMappingContext(mappingContext, annotation, cleanedUpRelativeFieldName);
        ValueBinderRef valueBinder = this.getValueBinder(annotation);
        ValueBinder binder = this.createValueBinder(this.getValueBridge(annotation), valueBinder, context);
        Map<String, Object> params = context.toMap(valueBinder.params());
        fieldContext.valueBinder(binder, params);
        ContainerExtractorPath extractorPath = context.toContainerExtractorPath(this.getExtraction(annotation));
        fieldContext.extractors(extractorPath);
    }

    abstract PropertyMappingFieldOptionsStep<?> initFieldMappingContext(PropertyMappingStep var1, A var2, String var3);

    abstract ContainerExtraction getExtraction(A var1);

    abstract String getName(A var1);

    abstract ValueBridgeRef getValueBridge(A var1);

    abstract ValueBinderRef getValueBinder(A var1);

    private ValueBinder createValueBinder(ValueBridgeRef bridgeReferenceAnnotation, ValueBinderRef binderReferenceAnnotation, MappingAnnotationProcessorContext context) {
        Optional<Object> bridgeReference = Optional.empty();
        if (bridgeReferenceAnnotation != null) {
            bridgeReference = context.toBeanReference(ValueBridge.class, ValueBridgeRef.UndefinedBridgeImplementationType.class, bridgeReferenceAnnotation.type(), bridgeReferenceAnnotation.name(), bridgeReferenceAnnotation.retrieval());
        }
        Optional<BeanReference<? extends ValueBinder>> binderReference = context.toBeanReference(ValueBinder.class, ValueBinderRef.UndefinedBinderImplementationType.class, binderReferenceAnnotation.type(), binderReferenceAnnotation.name(), binderReferenceAnnotation.retrieval());
        if (bridgeReference.isPresent() && binderReference.isPresent()) {
            throw MappingLog.INSTANCE.invalidFieldDefiningBothBridgeReferenceAndBinderReference();
        }
        if (bridgeReference.isPresent()) {
            return new BeanBinder((BeanReference)bridgeReference.get());
        }
        if (binderReference.isPresent()) {
            return new BeanDelegatingBinder(binderReference.get());
        }
        return null;
    }
}

