package org.hibernate.search.mapper.pojo.logging.impl;

import java.util.Locale;
import java.io.Serializable;
import org.hibernate.search.util.common.SearchException;
import java.util.Collection;
import java.lang.String;
import org.jboss.logging.Logger;
import java.util.Arrays;

/**
 * Warning this class consists of generated code.
 */
public class LoadingLog_$logger implements LoadingLog, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = LoadingLog_$logger.class.getName();
    public LoadingLog_$logger(final Logger log) {
        this.log = log;
    }
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String unexpectedEntityNameForEntityLoading$str() {
        return "HSEARCH700086: Unexpected entity name for entity loading: '%1$s'. Expected one of %2$s.";
    }
    @Override
    public final SearchException unexpectedEntityNameForEntityLoading(final String entityName, final Collection<String> expectedNames) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unexpectedEntityNameForEntityLoading$str(), entityName, expectedNames));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
}
