/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.search.definition.impl;

import java.util.Map;
import java.util.Optional;
import org.hibernate.search.engine.search.projection.definition.spi.CompositeProjectionDefinition;
import org.hibernate.search.engine.search.projection.definition.spi.ProjectionRegistry;
import org.hibernate.search.mapper.pojo.logging.impl.ProjectionLog;
import org.hibernate.search.util.common.impl.Closer;

public final class PojoSearchQueryElementRegistry
implements ProjectionRegistry,
AutoCloseable {
    private final Map<Class<?>, CompositeProjectionDefinition<?>> compositeProjectionDefinitions;

    public PojoSearchQueryElementRegistry(Map<Class<?>, CompositeProjectionDefinition<?>> compositeProjectionDefinitions) {
        this.compositeProjectionDefinitions = compositeProjectionDefinitions;
    }

    public <T> CompositeProjectionDefinition<T> composite(Class<T> objectClass) {
        Optional<CompositeProjectionDefinition<T>> definition = this.compositeOptional(objectClass);
        if (!definition.isPresent()) {
            throw ProjectionLog.INSTANCE.invalidObjectClassForProjection(objectClass);
        }
        return definition.get();
    }

    public <T> Optional<CompositeProjectionDefinition<T>> compositeOptional(Class<T> objectClass) {
        CompositeProjectionDefinition<?> definition = this.compositeProjectionDefinitions.get(objectClass);
        return Optional.ofNullable(definition);
    }

    @Override
    public void close() throws Exception {
        try (Closer closer = new Closer();){
            closer.pushAll(CompositeProjectionDefinition::close, this.compositeProjectionDefinitions.values());
        }
    }
}

