package org.hibernate.search.mapper.pojo.logging.impl;

import java.util.Locale;
import org.hibernate.search.util.common.data.impl.LinkedNode;
import java.io.Serializable;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.ObjectPath;
import java.util.Set;
import org.hibernate.search.engine.backend.types.dsl.IndexFieldTypeOptionsStep;
import org.hibernate.search.util.common.SearchException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.util.List;
import java.lang.reflect.Member;
import java.lang.IllegalArgumentException;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoIndexedTypeManager;
import java.nio.file.Path;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel;
import java.lang.reflect.Constructor;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoContainedTypeManager;
import java.lang.Exception;
import org.hibernate.search.util.common.reporting.EventContext;
import java.lang.reflect.Type;
import org.hibernate.search.engine.mapper.model.spi.MappingElement;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import java.util.Collection;
import java.lang.Object;
import java.lang.Class;
import java.util.Arrays;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoConstructorModel;
import java.util.Map;


import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
public class MappingLog_$logger implements MappingLog, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = MappingLog_$logger.class.getName();
    public MappingLog_$logger(final Logger log) {
        this.log = log;
    }
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String schemaExporterTargetIsNotEmptyDirectory$str() {
        return "HSEARCH700126: Target path '%1$s' already exists and is not an empty directory. Use a path to an empty or non-existing directory.";
    }
    @Override
    public final SearchException schemaExporterTargetIsNotEmptyDirectory(final Path targetDirectory) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), schemaExporterTargetIsNotEmptyDirectory$str(), targetDirectory));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String unableToExportSchema$str() {
        return "HSEARCH700127: Unable to export the schema: %1$s";
    }
    @Override
    public final SearchException unableToExportSchema(final String cause, final Exception e, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToExportSchema$str(), cause), e, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToResolveDefaultValueBridgeFromSourceType$str() {
        return "HSEARCH000135: No default value bridge implementation for type '%1$s'. Use a custom bridge.";
    }
    @Override
    public final SearchException unableToResolveDefaultValueBridgeFromSourceType(final PojoTypeModel<?> sourceType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToResolveDefaultValueBridgeFromSourceType$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(sourceType)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToFindLongitudeOrLatitudeProperty$str() {
        return "HSEARCH000159: No property annotated with %1$s(markerSet = \"%3$s\"). There must be exactly one such property in order to map it to geo-point field '%2$s'.";
    }
    @Override
    public final SearchException unableToFindLongitudeOrLatitudeProperty(final String annotation, final String fieldName, final String markerSet) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToFindLongitudeOrLatitudeProperty$str(), annotation, fieldName, markerSet));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multipleLatitudeOrLongitudeProperties$str() {
        return "HSEARCH000160: Multiple properties annotated with %1$s(markerSet = \"%3$s\"). There must be exactly one such property in order to map it to geo-point field '%2$s'.";
    }
    @Override
    public final SearchException multipleLatitudeOrLongitudeProperties(final String annotation, final String fieldName, final String markerSet) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), multipleLatitudeOrLongitudeProperties$str(), annotation, fieldName, markerSet));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingIdentifierMapping$str() {
        return "HSEARCH000177: Unable to define a document identifier for indexed type '%1$s', The property representing the entity identifier is unknown. Define the document identifier explicitly by annotating a property whose values are unique with @DocumentId.";
    }
    @Override
    public final SearchException missingIdentifierMapping(final PojoRawTypeModel<?> typeModel) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingIdentifierMapping$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(typeModel)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String uselessIncludePathFilters$str() {
        return "HSEARCH000216: %1$s defines includePaths filters that do not match anything. Non-matching includePaths filters: %2$s. Encountered field paths: %3$s. Check the filters for typos, or remove them if they are not useful.";
    }
    @Override
    public final SearchException uselessIncludePathFilters(final MappingElement mappingElement, final Set<String> nonMatchingIncludePaths, final Set<String> encounteredFieldPaths, final EventContext eventContext) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), uselessIncludePathFilters$str(), mappingElement, nonMatchingIncludePaths, encounteredFieldPaths), eventContext);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String infiniteRecursionForAssociationEmbeddeds$str() {
        return "HSEARCH000221: Infinite embedded recursion involving path '%2$s' on type '%1$s'";
    }
    @Override
    public final SearchException infiniteRecursionForAssociationEmbeddeds(final PojoRawTypeModel<?> typeModel, final PojoModelPathValueNode path) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), infiniteRecursionForAssociationEmbeddeds$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(typeModel), new org.hibernate.search.mapper.pojo.logging.spi.PojoModelPathFormatter(path)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidIndexedSuperTypes$str() {
        return "HSEARCH000234: No matching indexed entity types for types %1$s These types are not indexed entity types, nor is any of their subtypes. Valid indexed entity classes, superclasses and superinterfaces are: %2$s.";
    }
    @Override
    public final SearchException invalidIndexedSuperTypes(final Collection<PojoRawTypeIdentifier<?>> nonIndexedTypes, final Collection<PojoRawTypeIdentifier<?>> validSuperTypes) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidIndexedSuperTypes$str(), nonIndexedTypes, validSuperTypes));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String conflictingParameterDefined$str() {
        return "HSEARCH000337: Conflicting usage of @Param annotation for parameter name: '%1$s'. Can't assign both value '%2$s' and '%3$s'";
    }
    @Override
    public final SearchException conflictingParameterDefined(final String name, final Object value1, final Object value2) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), conflictingParameterDefined$str(), name, value1, value2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToResolveDefaultIdentifierBridgeFromSourceType$str() {
        return "HSEARCH700001: No default identifier bridge implementation for type '%1$s'. Implement a custom bridge and assign it to the identifier property with @DocumentId(identifierBridge = ...). See the reference documentation for more information about bridges.";
    }
    @Override
    public final SearchException unableToResolveDefaultIdentifierBridgeFromSourceType(final PojoTypeModel<?> sourceType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToResolveDefaultIdentifierBridgeFromSourceType$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(sourceType)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingBinderReferenceInBinding$str() {
        return "HSEARCH700003: Empty binder reference.";
    }
    @Override
    public final SearchException missingBinderReferenceInBinding() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingBinderReferenceInBinding$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidFieldDefiningBothBridgeReferenceAndBinderReference$str() {
        return "HSEARCH700005: Ambiguous value bridge reference: both 'valueBridge' and 'valueBinder' are set. Only one can be set.";
    }
    @Override
    public final SearchException invalidFieldDefiningBothBridgeReferenceAndBinderReference() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidFieldDefiningBothBridgeReferenceAndBinderReference$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidDocumentIdDefiningBothBridgeReferenceAndBinderReference$str() {
        return "HSEARCH700006: Ambiguous identifier bridge reference: both 'identifierBridge' and 'identifierBinder' are set. Only one can be set.";
    }
    @Override
    public final SearchException invalidDocumentIdDefiningBothBridgeReferenceAndBinderReference() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidDocumentIdDefiningBothBridgeReferenceAndBinderReference$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidEmptyTargetForScope$str() {
        return "HSEARCH700007: Empty scope. If you want to target all indexes, pass 'Object.class' as the target type.";
    }
    @Override
    public final SearchException invalidEmptyTargetForScope() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidEmptyTargetForScope$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidInputTypeForBridge$str() {
        return "HSEARCH700010: Invalid bridge for input type '%2$s': '%1$s'. This bridge expects an input of type '%3$s'.";
    }
    @Override
    public final SearchException invalidInputTypeForBridge(final Object bridge, final PojoTypeModel<?> typeModel, final PojoTypeModel<?> expectedTypeModel) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidInputTypeForBridge$str(), bridge, new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(typeModel), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(expectedTypeModel)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingFieldNameForGeoPointBridgeOnType$str() {
        return "HSEARCH700011: Missing field name for @GeoPointBinding on type %1$s. The field name is mandatory when the bridge is applied to a type, optional when applied to a property.";
    }
    @Override
    public final SearchException missingFieldNameForGeoPointBridgeOnType(final String typeName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingFieldNameForGeoPointBridgeOnType$str(), typeName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotInferContainerExtractorClassTypePattern$str() {
        return "HSEARCH700015: Unable to interpret the type arguments to the ContainerExtractor interface in  implementation '%1$s'. Only the following implementations of ContainerExtractor are valid:  1) implementations setting both type parameters to *raw* types, e.g. class MyExtractor implements ContainerExtractor<MyBean, String>; 2) implementations setting the first type parameter to an array of an unbounded type variable, and setting the second parameter to the same type variable, e.g. MyExtractor<T> implements ContainerExtractor<T[], T> 3) implementations setting the first type parameter to a parameterized type with one argument set to an unbounded type variable and the other to unbounded wildcards, and setting the second type parameter to the same type variable, e.g. MyExtractor<T> implements ContainerExtractor<MyParameterizedBean<?, T, ?>, T>";
    }
    @Override
    public final SearchException cannotInferContainerExtractorClassTypePattern(final Class<?> extractorClass, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotInferContainerExtractorClassTypePattern$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(extractorClass)), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidContainerExtractorForType$str() {
        return "HSEARCH700016: Invalid container extractor for type '%3$s': '%1$s' (implementation class: '%2$s')";
    }
    @Override
    public final SearchException invalidContainerExtractorForType(final String extractorName, final Class<? extends org.hibernate.search.mapper.pojo.extractor.ContainerExtractor> extractorClass, final PojoTypeModel<?> extractedType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidContainerExtractorForType$str(), extractorName, new org.hibernate.search.util.common.logging.impl.ClassFormatter(extractorClass), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(extractedType)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void indexedTypeManager(final PojoRawTypeModel<?> typeModel, final PojoIndexedTypeManager<?, ?> typeManager) {
        log.logf(FQCN, DEBUG, null, indexedTypeManager$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(typeModel), new org.hibernate.search.util.common.logging.impl.ToStringTreeMultilineFormatter(typeManager));
    }
    protected String indexedTypeManager$str() {
        return "HSEARCH700017: Type manager for indexed type '%1$s': %2$s";
    }
    @Override
    public final void detectedMappedTypes(final Set<PojoRawTypeModel<?>> entityTypes, final Set<PojoRawTypeModel<?>> indexedTypes, final Set<PojoRawTypeModel<?>> initialMappedTypes) {
        log.logf(FQCN, DEBUG, null, detectedMappedTypes$str(), entityTypes, indexedTypes, initialMappedTypes);
    }
    protected String detectedMappedTypes$str() {
        return "HSEARCH700018: Detected entity types: %1$s, indexed types: %2$s, initial mapped types: %3$s.";
    }
    @Override
    public final void containedTypeManager(final PojoRawTypeModel<?> typeModel, final PojoContainedTypeManager<?, ?> typeManager) {
        log.logf(FQCN, DEBUG, null, containedTypeManager$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(typeModel), new org.hibernate.search.util.common.logging.impl.ToStringTreeMultilineFormatter(typeManager));
    }
    protected String containedTypeManager$str() {
        return "HSEARCH700019: Type manager for contained type '%1$s': %2$s";
    }
    protected String cannotInvertAssociationForReindexing$str() {
        return "HSEARCH700020: Unable to find the inverse side of the association on type '%2$s' at path '%3$s'. Hibernate Search needs this information in order to reindex '%2$s' when '%1$s' is modified. You can solve this error by defining the inverse side of this association,  either with annotations specific to your integration (@OneToMany(mappedBy = ...) in Hibernate ORM)  or with the Hibernate Search @AssociationInverseSide annotation. Alternatively, if you do not need to reindex '%2$s' when '%1$s' is modified, you can disable automatic reindexing with @IndexingDependency(reindexOnUpdate = ReindexOnUpdate.SHALLOW).";
    }
    @Override
    public final SearchException cannotInvertAssociationForReindexing(final PojoRawTypeModel<?> inverseSideTypeModel, final PojoRawTypeModel<?> typeModel, final PojoModelPathValueNode associationPath) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotInvertAssociationForReindexing$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(inverseSideTypeModel), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(typeModel), new org.hibernate.search.mapper.pojo.logging.spi.PojoModelPathFormatter(associationPath)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotApplyImplicitInverseAssociationPath$str() {
        return "HSEARCH700021: Unable to apply path '%2$s' to type '%1$s'. This path was resolved as the inverse side of the association '%4$s' on type '%3$s'. Hibernate Search needs to apply this path in order to reindex '%3$s' when '%1$s' is modified. Nested exception: %5$s";
    }
    @Override
    public final SearchException cannotApplyImplicitInverseAssociationPath(final PojoRawTypeModel<?> inverseSideTypeModel, final PojoModelPathValueNode inverseSideAssociationPath, final PojoRawTypeModel<?> originalSideTypeModel, final PojoModelPathValueNode originalSideAssociationPath, final String errorMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotApplyImplicitInverseAssociationPath$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(inverseSideTypeModel), new org.hibernate.search.mapper.pojo.logging.spi.PojoModelPathFormatter(inverseSideAssociationPath), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(originalSideTypeModel), new org.hibernate.search.mapper.pojo.logging.spi.PojoModelPathFormatter(originalSideAssociationPath), errorMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String incorrectTargetTypeForInverseAssociation$str() {
        return "HSEARCH700022: The inverse association targets type '%1$s', but a supertype or subtype of '%2$s' was expected.";
    }
    @Override
    public final SearchException incorrectTargetTypeForInverseAssociation(final PojoRawTypeModel<?> inverseAssociationTargetType, final PojoRawTypeModel<?> entityType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), incorrectTargetTypeForInverseAssociation$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(inverseAssociationTargetType), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(entityType)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingInversePathInAssociationInverseSideMapping$str() {
        return "HSEARCH700023: @AssociationInverseSide.inversePath is empty.";
    }
    @Override
    public final SearchException missingInversePathInAssociationInverseSideMapping() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingInversePathInAssociationInverseSideMapping$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingEntityTypeMetadata$str() {
        return "HSEARCH700027: Unable to index type '%1$s': this type is not an entity type. If you only expect subtypes to be instantiated, make this type abstract. If you expect this exact type to be instantiated and want it to be indexed, make it an entity type. Otherwise, ensure this type and its subtypes are never indexed by removing the @Indexed annotation or by annotating the type with @Indexed(enabled = false).";
    }
    @Override
    public final SearchException missingEntityTypeMetadata(final PojoRawTypeModel<?> typeModel) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingEntityTypeMetadata$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(typeModel)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingPathInIndexingDependencyDerivedFrom$str() {
        return "HSEARCH700029: @IndexingDependency.derivedFrom contains an empty path.";
    }
    @Override
    public final SearchException missingPathInIndexingDependencyDerivedFrom() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingPathInIndexingDependencyDerivedFrom$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String infiniteRecursionForDerivedFrom$str() {
        return "HSEARCH700030: Unable to resolve dependencies of a derived property: there is a cyclic dependency starting from type '%1$s'.\nDerivation chain starting from that type and ending with a cycle:%2$s\n A derived property cannot be marked as derived from itself, even indirectly through other  derived properties. If your model actually contains such cyclic dependency,  you should consider disabling automatic reindexing, at least partially  using @IndexingDependency(reindexOnUpdate = ReindexOnUpdate.NO) on one of the properties in the cycle.";
    }
    @Override
    public final SearchException infiniteRecursionForDerivedFrom(final PojoRawTypeModel<?> typeModel, final LinkedNode<org.hibernate.search.mapper.pojo.automaticindexing.building.impl.DerivedDependencyWalkingInfo> cycle) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), infiniteRecursionForDerivedFrom$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(typeModel), new org.hibernate.search.util.common.logging.impl.ToStringTreeMultilineFormatter(cycle)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidFieldEncodingForStringFieldMapping$str() {
        return "HSEARCH700031: Unable to apply property mapping: this property mapping must target an index field of standard String type, but the resolved field type is non-standard or non-String. This generally means you need to use a different field annotation or to convert property values using a custom ValueBridge or ValueBinder. If you are already using a custom ValueBridge or ValueBinder, check its field type. Details: encountered type DSL step '%1$s', which does not extend the expected interface '%2$s'.";
    }
    @Override
    public final SearchException invalidFieldEncodingForStringFieldMapping(final IndexFieldTypeOptionsStep<?, ?> step, final Class<?> expectedContextType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidFieldEncodingForStringFieldMapping$str(), step, new org.hibernate.search.util.common.logging.impl.ClassFormatter(expectedContextType)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownTypeIdentifierForMappedEntityType$str() {
        return "HSEARCH700037: No matching entity type for type identifier '%1$s'. Either this type is not an entity type, or the entity type is not mapped in Hibernate Search. Valid identifiers for mapped entity types are: %2$s";
    }
    @Override
    public final SearchException unknownTypeIdentifierForMappedEntityType(final PojoRawTypeIdentifier<?> invalidTypeId, final Collection<PojoRawTypeIdentifier<?>> validTypeIds) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownTypeIdentifierForMappedEntityType$str(), invalidTypeId, validTypeIds));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String incompatibleRequestedType$str() {
        return "HSEARCH700039: '%1$s' cannot be assigned to '%2$s'";
    }
    @Override
    public final SearchException incompatibleRequestedType(final PojoModelPathValueNode accessor, final Class<?> requestedType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), incompatibleRequestedType$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoModelPathFormatter(accessor), new org.hibernate.search.util.common.logging.impl.ClassFormatter(requestedType)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownTypeIdentifierForIndexedEntityType$str() {
        return "HSEARCH700040: No matching indexed entity type for type identifier '%1$s'. Either this type is not an entity type, or the entity type is not indexed in Hibernate Search. Valid identifiers for indexed entity types are: %2$s";
    }
    @Override
    public final SearchException unknownTypeIdentifierForIndexedEntityType(final PojoRawTypeIdentifier<?> invalidTypeId, final Collection<PojoRawTypeIdentifier<?>> validTypeIds) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownTypeIdentifierForIndexedEntityType$str(), invalidTypeId, validTypeIds));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotUseDefaultExtractorsInMultiExtractorChain$str() {
        return "HSEARCH700041: Invalid reference to default extractors: a chain of multiple container extractors must not include the default extractors. Either use only the default extractors, or explicitly reference every single extractor to be applied.";
    }
    @Override
    public final SearchException cannotUseDefaultExtractorsInMultiExtractorChain() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotUseDefaultExtractorsInMultiExtractorChain$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotDefinePojoModelPathWithoutProperty$str() {
        return "HSEARCH700045: A PojoModelPath must include at least one property.";
    }
    @Override
    public final SearchException cannotDefinePojoModelPathWithoutProperty() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotDefinePojoModelPathWithoutProperty$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotApplyExplicitInverseAssociationPath$str() {
        return "HSEARCH700046: Unable to apply path '%2$s' to type '%1$s'. This path was declared as a path to collect entities of type '%3$s' to be reindexed. Hibernate Search needs to apply this path in order to reindex '%3$s' when '%1$s' is modified. Nested exception: %4$s";
    }
    @Override
    public final SearchException cannotApplyExplicitInverseAssociationPath(final PojoRawTypeModel<?> inverseSideTypeModel, final PojoModelPathValueNode inverseSideAssociationPath, final PojoRawTypeModel<?> originalSideTypeModel, final String errorMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotApplyExplicitInverseAssociationPath$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(inverseSideTypeModel), new org.hibernate.search.mapper.pojo.logging.spi.PojoModelPathFormatter(inverseSideAssociationPath), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(originalSideTypeModel), errorMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotDefineOtherEntityDependencyOnNonEntityBridgedType$str() {
        return "HSEARCH700047: Invalid use of 'fromOtherEntity': this method can only be used when the bridged element has an entity type, but the bridged element has type '%1$s', which is not an entity type.";
    }
    @Override
    public final SearchException cannotDefineOtherEntityDependencyOnNonEntityBridgedType(final PojoRawTypeModel<?> bridgedTypeModel) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotDefineOtherEntityDependencyOnNonEntityBridgedType$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(bridgedTypeModel)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotDefineOtherEntityDependencyFromNonEntityType$str() {
        return "HSEARCH700048: Invalid type passed to 'fromOtherEntity': the type must be an entity type. Type '%1$s' is not an entity type.";
    }
    @Override
    public final SearchException cannotDefineOtherEntityDependencyFromNonEntityType(final PojoRawTypeModel<?> otherType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotDefineOtherEntityDependencyFromNonEntityType$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(otherType)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingBridgeDependencyDeclaration$str() {
        return "HSEARCH700049: Incorrect binder implementation: the binder did not declare any dependency to the entity model during binding. Declare dependencies using context.dependencies().use(...) or, if the bridge really does not depend on the entity model, context.dependencies().useRootOnly().";
    }
    @Override
    public final SearchException missingBridgeDependencyDeclaration() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingBridgeDependencyDeclaration$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String inconsistentBridgeDependencyDeclaration$str() {
        return "HSEARCH700050: Incorrect binder implementation: the binder called context.dependencies().useRootOnly() during binding, but also declared extra dependencies to the entity model.";
    }
    @Override
    public final SearchException inconsistentBridgeDependencyDeclaration() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), inconsistentBridgeDependencyDeclaration$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidFieldEncodingForScaledNumberFieldMapping$str() {
        return "HSEARCH700051: Unable to apply property mapping: this property mapping must target an index field of standard, scaled-number type (BigDecimal or BigInteger), but the resolved field type is non-standard or non-scaled. This generally means you need to use a different field annotation or to convert property values using a custom ValueBridge or ValueBinder. If you are already using a custom ValueBridge or ValueBinder, check its field type. Details: encountered type DSL step '%1$s', which does not extend the expected interface '%2$s'.";
    }
    @Override
    public final SearchException invalidFieldEncodingForScaledNumberFieldMapping(final IndexFieldTypeOptionsStep<?, ?> step, final Class<?> expectedContextType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidFieldEncodingForScaledNumberFieldMapping$str(), step, new org.hibernate.search.util.common.logging.impl.ClassFormatter(expectedContextType)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotReferenceExtractorsWhenExtractionDisabled$str() {
        return "HSEARCH700052: Unexpected extractor references: extractors cannot be defined explicitly when extract = ContainerExtract.NO. Either leave 'extract' to its default value to define extractors explicitly or leave the 'extractor' list to its default, empty value to disable extraction.";
    }
    @Override
    public final SearchException cannotReferenceExtractorsWhenExtractionDisabled() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotReferenceExtractorsWhenExtractionDisabled$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotResolveContainerExtractorName$str() {
        return "HSEARCH700053: No container extractor with name '%1$s'. Check that this name matches a container extractor, either a builtin one whose name is a constant in '%2$s' or a custom one that was properly registered.";
    }
    @Override
    public final SearchException cannotResolveContainerExtractorName(final String extractorName, final Class<?> builtinExtractorConstantsClass) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotResolveContainerExtractorName$str(), extractorName, new org.hibernate.search.util.common.logging.impl.ClassFormatter(builtinExtractorConstantsClass)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingBridgeForBinder$str() {
        return "HSEARCH700058: Incorrect binder implementation: binder '%1$s' did not call context.bridge(...).";
    }
    @Override
    public final SearchException missingBridgeForBinder(final Object binder) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingBridgeForBinder$str(), binder));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingMarkerForBinder$str() {
        return "HSEARCH700059: Incorrect binder implementation: binder '%1$s' did not call context.marker(...).";
    }
    @Override
    public final SearchException missingMarkerForBinder(final Object binder) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingMarkerForBinder$str(), binder));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidIndexedEmbedded$str() {
        return "HSEARCH700061: Unable to index-embed type '%1$s': no index mapping (@GenericField, @FullTextField, custom bridges, ...) is defined for that type.";
    }
    @Override
    public final SearchException invalidIndexedEmbedded(final PojoTypeModel<?> typeModel) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidIndexedEmbedded$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(typeModel)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multipleEntityNames$str() {
        return "HSEARCH700064: Multiple entity names assigned to the same type: '%1$s', '%2$s'.";
    }
    @Override
    public final SearchException multipleEntityNames(final String entityName, final String otherEntityName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), multipleEntityNames$str(), entityName, otherEntityName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidFieldEncodingForStandardFieldMapping$str() {
        return "HSEARCH700065: Unable to apply property mapping: this property mapping must target an index field of standard type, but the resolved field type is non-standard. This generally means you need to use a different field annotation or to convert property values using a custom ValueBridge or ValueBinder. If you are already using a custom ValueBridge or ValueBinder, check its field type. Details: encountered type DSL step '%1$s', which does not extend the expected interface '%2$s'.";
    }
    @Override
    public final SearchException invalidFieldEncodingForStandardFieldMapping(final IndexFieldTypeOptionsStep<?, ?> step, final Class<?> expectedContextType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidFieldEncodingForStandardFieldMapping$str(), step, new org.hibernate.search.util.common.logging.impl.ClassFormatter(expectedContextType)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidFieldEncodingForNonStandardFieldMapping$str() {
        return "HSEARCH700066: Unable to apply property mapping: this property mapping must target an index field of non-standard type, but the resolved field type is standard. Switch to a standard field annotation such as @GenericField. Details: encountered type DSL step '%1$s', which does extend the interface '%2$s'.";
    }
    @Override
    public final SearchException invalidFieldEncodingForNonStandardFieldMapping(final IndexFieldTypeOptionsStep<?, ?> step, final Class<?> expectedContextType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidFieldEncodingForNonStandardFieldMapping$str(), step, new org.hibernate.search.util.common.logging.impl.ClassFormatter(expectedContextType)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidAnnotationTypeForAnnotationProcessor$str() {
        return "HSEARCH700067: Invalid annotation processor: '%1$s'. This processor expects annotations of a different type: '%2$s'.";
    }
    @Override
    public final SearchException invalidAnnotationTypeForAnnotationProcessor(final Object annotationProcessor, final Class<?> processorAnnotationType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidAnnotationTypeForAnnotationProcessor$str(), annotationProcessor, new org.hibernate.search.util.common.logging.impl.ClassFormatter(processorAnnotationType)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingProcessorReferenceInMappingAnnotation$str() {
        return "HSEARCH700068: Empty annotation processor reference in meta-annotation '%1$s'.";
    }
    @Override
    public final SearchException missingProcessorReferenceInMappingAnnotation(final Class<? extends java.lang.annotation.Annotation> metaAnnotationType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingProcessorReferenceInMappingAnnotation$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(metaAnnotationType)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotSetBothIndexedEmbeddedNameAndPrefix$str() {
        return "HSEARCH700069: Ambiguous @IndexedEmbedded name: both 'name' and 'prefix' are set. Only one can be set. Name is '%1$s', prefix is '%2$s'.";
    }
    @Override
    public final SearchException cannotSetBothIndexedEmbeddedNameAndPrefix(final String relativeFieldName, final String prefix) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotSetBothIndexedEmbeddedNameAndPrefix$str(), relativeFieldName, prefix));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidFieldNameDotNotAllowed$str() {
        return "HSEARCH700070: Invalid index field name '%1$s': field names cannot contain a dot ('.').";
    }
    @Override
    public final SearchException invalidFieldNameDotNotAllowed(final String relativeFieldName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidFieldNameDotNotAllowed$str(), relativeFieldName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotFindAlternativeDiscriminator$str() {
        return "HSEARCH700071: No property annotated with @Alternative(id = %1$s). There must be exactly one such property in order to map property '%2$s' to multi-alternative fields.";
    }
    @Override
    public final SearchException cannotFindAlternativeDiscriminator(final String alternativeId, final String fieldValueSourcePropertyName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotFindAlternativeDiscriminator$str(), alternativeId, fieldValueSourcePropertyName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String conflictingAlternativeDiscriminators$str() {
        return "HSEARCH700072: Multiple properties annotated with @Alternative(id = %1$s). There must be exactly one such property in order to map property '%2$s' to multi-alternative fields.";
    }
    @Override
    public final SearchException conflictingAlternativeDiscriminators(final String alternativeId, final String fieldValueSourcePropertyName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), conflictingAlternativeDiscriminators$str(), alternativeId, fieldValueSourcePropertyName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidInputTypeForRoutingBridge$str() {
        return "HSEARCH700073: Invalid routing bridge for entity type '%2$s': '%1$s' This bridge expects an entity type extending '%3$s'.";
    }
    @Override
    public final SearchException invalidInputTypeForRoutingBridge(final Object routingBridge, final PojoTypeModel<?> typeModel, final PojoTypeModel<?> expectedTypeModel) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidInputTypeForRoutingBridge$str(), routingBridge, new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(typeModel), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(expectedTypeModel)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noCurrentRoute$str() {
        return "HSEARCH700075: Incorrect routing bridge implementation: routing bridge '%1$s' did not define any current route. In the implementation of RoutingBridge.route(...), define exactly one current route by calling 'routes.addRoute()', or explicitly indicate indexing is not required by calling 'routes.notIndexed()'.";
    }
    @Override
    public final SearchException noCurrentRoute(final Object routingBridge) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), noCurrentRoute$str(), routingBridge));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multipleCurrentRoutes$str() {
        return "HSEARCH700076: Incorrect routing bridge implementation: routing bridge '%1$s' defined multiple current routes. In the implementation of RoutingBridge.route(...), define at most one current route by calling 'routes.addRoute()' at most once.";
    }
    @Override
    public final SearchException multipleCurrentRoutes(final Object routingBridge) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), multipleCurrentRoutes$str(), routingBridge));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noPreviousRoute$str() {
        return "HSEARCH700077: Incorrect routing bridge implementation: routing bridge '%1$s' did not define any previous route. In the implementation of RoutingBridge.previousRoutes(...), define at least one previous route by calling 'routes.addRoute()' at least once, or explicitly indicate no prior indexing was performed by calling 'routes.notIndexed()'.";
    }
    @Override
    public final SearchException noPreviousRoute(final Object routingBridge) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), noPreviousRoute$str(), routingBridge));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotFindReadableProperty$str() {
        return "HSEARCH700078: No readable property named '%2$s' on type '%1$s'.";
    }
    @Override
    public final SearchException cannotFindReadableProperty(final PojoRawTypeModel<?> typeModel, final String propertyName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotFindReadableProperty$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(typeModel), propertyName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorRetrievingPropertyTypeModel$str() {
        return "HSEARCH700079: Exception while retrieving property type model for '%1$s' on '%2$s'.";
    }
    @Override
    public final SearchException errorRetrievingPropertyTypeModel(final String propertyModelName, final PojoRawTypeModel<?> parentTypeModel, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), errorRetrievingPropertyTypeModel$str(), propertyModelName, new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(parentTypeModel)), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidGenericParameterToInferFieldType$str() {
        return "HSEARCH700080: Unable to infer index field type for value bridge '%1$s': this bridge implements ValueBridge<V, F>, but sets the generic type parameter F to '%2$s'. The index field type can only be inferred automatically when this type parameter is set to a raw class. Use a ValueBinder to set the index field type explicitly, or set the type parameter F to a definite, raw type.";
    }
    @Override
    public final SearchException invalidGenericParameterToInferFieldType(final Object bridge, final Type type) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidGenericParameterToInferFieldType$str(), bridge, new org.hibernate.search.util.common.logging.impl.TypeFormatter(type)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidGenericParameterToInferIdentifierType$str() {
        return "HSEARCH700081: Unable to infer expected identifier type for identifier bridge '%1$s': this bridge implements IdentifierBridge<I>, but sets the generic type parameter I to '%2$s'. The expected identifier type can only be inferred automatically when this type parameter is set to a raw class. Use an IdentifierBinder to set the expected identifier type explicitly, or set the type parameter I to a definite, raw type.";
    }
    @Override
    public final SearchException invalidGenericParameterToInferIdentifierType(final Object bridge, final Type type) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidGenericParameterToInferIdentifierType$str(), bridge, new org.hibernate.search.util.common.logging.impl.TypeFormatter(type)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidGenericParameterToInferValueType$str() {
        return "HSEARCH700082: Unable to infer expected value type for value bridge '%1$s': this bridge implements ValueBridge<V, F>, but sets the generic type parameter V to '%2$s'. The expected value type can only be inferred automatically when this type parameter is set to a raw class. Use a ValueBinder to set the expected value type explicitly, or set the type parameter V to a definite, raw type.";
    }
    @Override
    public final SearchException invalidGenericParameterToInferValueType(final Object bridge, final Type type) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidGenericParameterToInferValueType$str(), bridge, new org.hibernate.search.util.common.logging.impl.TypeFormatter(type)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void arbitraryMemberSelection(final PojoRawTypeModel<?> typeModel, final String propertyName, final Member selectedMember, final List<Member> otherMembers) {
        log.logf(FQCN, WARN, null, arbitraryMemberSelection$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(typeModel), propertyName, selectedMember, otherMembers);
    }
    protected String arbitraryMemberSelection$str() {
        return "HSEARCH700085: Multiple getters exist for property named '%2$s' on type '%1$s'. Hibernate Search will use '%3$s' and ignore %4$s. The selected getter may change from one startup to the next. To get rid of this warning, either remove the extra getters or configure the access type for this property to 'FIELD'.";
    }
    protected String unknownEntityNameForMappedEntityType$str() {
        return "HSEARCH700089: No matching entity type for name '%1$s'. Either this is not the name of an entity type, or the entity type is not mapped in Hibernate Search. Valid names for mapped entity types are: %2$s";
    }
    @Override
    public final SearchException unknownEntityNameForMappedEntityType(final String invalidName, final Collection<String> validNames) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownEntityNameForMappedEntityType$str(), invalidName, validNames));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorRetrievingConstructorParameterTypeModel$str() {
        return "HSEARCH700110: Exception while retrieving parameter type model for parameter #%1$s of '%2$s'.";
    }
    @Override
    public final SearchException errorRetrievingConstructorParameterTypeModel(final int parameterIndex, final PojoConstructorModel<?> constructorModel, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), errorRetrievingConstructorParameterTypeModel$str(), parameterIndex, constructorModel), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotWorkWithIdentifierBecauseUnconfiguredIdentifierMapping$str() {
        return "HSEARCH700105: Cannot work with the identifier of entities of type '%1$s': identifier mapping (@DocumentId, ...) is not configured for this type.";
    }
    @Override
    public final SearchException cannotWorkWithIdentifierBecauseUnconfiguredIdentifierMapping(final PojoRawTypeIdentifier<?> typeIdentifier) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotWorkWithIdentifierBecauseUnconfiguredIdentifierMapping$str(), typeIdentifier));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotFindMainConstructorNotExactlyOneConstructor$str() {
        return "HSEARCH700107: No main constructor for type '%1$s': this type does not declare exactly one constructor.";
    }
    @Override
    public final SearchException cannotFindMainConstructorNotExactlyOneConstructor(final PojoRawTypeModel<?> typeModel) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotFindMainConstructorNotExactlyOneConstructor$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(typeModel)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotFindConstructorWithParameterTypes$str() {
        return "HSEARCH700109: No constructor with parameter types %2$s on type '%1$s'. Available constructors: %3$s";
    }
    @Override
    public final SearchException cannotFindConstructorWithParameterTypes(final PojoRawTypeModel<?> typeModel, final Class<?>[] parameterTypes, final Collection<? extends PojoConstructorModel<?>> constructors) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotFindConstructorWithParameterTypes$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(typeModel), new org.hibernate.search.util.common.logging.impl.CommaSeparatedClassesFormatter(parameterTypes), constructors));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorRetrievingConstructorHandle$str() {
        return "HSEARCH700111: Exception while retrieving constructor handle for '%1$s' on '%2$s'.";
    }
    @Override
    public final SearchException errorRetrievingConstructorHandle(final Constructor<?> constructor, final PojoRawTypeModel<?> parentTypeModel, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), errorRetrievingConstructorHandle$str(), constructor, new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(parentTypeModel)), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidObjectPath$str() {
        return "HSEARCH700121: Invalid ObjectPath encountered '%1$s': %2$s";
    }
    @Override
    public final SearchException invalidObjectPath(final ObjectPath path, final String causeMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidObjectPath$str(), path, causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedToCreateImplicitReindexingAssociationInverseSideResolverNode$str() {
        return "HSEARCH700122: An unexpected failure occurred while configuring resolution of association inverse side for reindexing. This may lead to incomplete reindexing and thus out-of-sync indexes. The exception is being ignored to preserve backwards compatibility with earlier versions of Hibernate Search. Failure: %3$s %2$s Association inverse side: %1$s.";
    }
    @Override
    public final SearchException failedToCreateImplicitReindexingAssociationInverseSideResolverNode(final Map<PojoRawTypeModel<?>, PojoModelPathValueNode> inversePathByInverseType, final EventContext context, final String causeMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), failedToCreateImplicitReindexingAssociationInverseSideResolverNode$str(), inversePathByInverseType, new org.hibernate.search.util.common.logging.impl.EventContextFormatter(context), causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownClassForNonInterfaceSuperType$str() {
        return "HSEARCH700130: No matching entity type for class '%1$s'. Neither this class nor any of its subclasses is mapped in Hibernate Search. Note interfaces are not considered superclasses and are not permitted here. Valid classes are: %2$s";
    }
    @Override
    public final SearchException unknownClassForNonInterfaceSuperType(final Class<?> invalidClass, final Collection<Class<?>> validClasses) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownClassForNonInterfaceSuperType$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(invalidClass), new org.hibernate.search.util.common.logging.impl.CommaSeparatedClassesFormatter(validClasses)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownEntityName$str() {
        return "HSEARCH700131: No matching entity type for name '%1$s'. This is not the name of an entity type in Hibernate Search. Valid entity names are: %2$s";
    }
    @Override
    public final SearchException unknownEntityName(final String invalidName, final Collection<String> validNames) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownEntityName$str(), invalidName, validNames));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownNonInterfaceSuperTypeIdentifier$str() {
        return "HSEARCH700132: No matching entity type for type '%1$s'. Neither this type nor any of its subclasses is mapped in Hibernate Search. Note interfaces are not considered superclasses and are not permitted here. Valid types are: %2$s";
    }
    @Override
    public final SearchException unknownNonInterfaceSuperTypeIdentifier(final PojoRawTypeIdentifier<?> typeIdentifier, final Set<PojoRawTypeIdentifier<?>> availableTypeIdentifiers) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownNonInterfaceSuperTypeIdentifier$str(), typeIdentifier, availableTypeIdentifiers));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotFindConstructorParameter$str() {
        return "HSEARCH700133: No parameter at index '%2$s' for constructor '%1$s'.";
    }
    @Override
    public final SearchException cannotFindConstructorParameter(final PojoConstructorModel<?> constructorModel, final int index) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotFindConstructorParameter$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoConstructorModelFormatter(constructorModel), index));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String uselessExcludePathFilters$str() {
        return "HSEARCH700142: %1$s defines excludePaths filters that do not match anything. Non-matching excludePaths filters: %2$s. Encountered field paths: %3$s. Check the filters for typos, or remove them if they are not useful.";
    }
    @Override
    public final SearchException uselessExcludePathFilters(final MappingElement mappingElement, final Set<String> nonMatchingExcludePaths, final Set<String> encounteredFieldPaths, final EventContext eventContext) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), uselessExcludePathFilters$str(), mappingElement, nonMatchingExcludePaths, encounteredFieldPaths), eventContext);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String defaultContainerExtractorCyclicRecursion$str() {
        return "HSEARCH700143: Cyclic recursion when applying the default container extractors to type '%1$s'. Container extractors applied to that type and resulting in the same type: %2$s. To break the cycle, you should consider configuring container extraction explicitly, possibly disabling it for this part of your mapping. See the reference documentation for more information.";
    }
    @Override
    public final SearchException defaultContainerExtractorCyclicRecursion(final PojoTypeModel<?> typeModel, final List<String> extractorNames) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), defaultContainerExtractorCyclicRecursion$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(typeModel), extractorNames));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidFieldEncodingForVectorFieldMapping$str() {
        return "HSEARCH700144: Unable to apply property mapping: this property mapping must target an index field of vector type, but the resolved field type is non-vector. This generally means you need to use a different field annotation or to convert property values using a custom ValueBridge or ValueBinder. If you are already using a custom ValueBridge or ValueBinder, check its field type. Details: encountered type DSL step '%1$s', which does not extend the expected interface '%2$s'.";
    }
    @Override
    public final SearchException invalidFieldEncodingForVectorFieldMapping(final IndexFieldTypeOptionsStep<?, ?> step, final Class<?> expectedContextType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidFieldEncodingForVectorFieldMapping$str(), step, new org.hibernate.search.util.common.logging.impl.ClassFormatter(expectedContextType)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String vectorDimensionNotSpecified$str() {
        return "HSEARCH700145: Vector dimension is a required property. Either specify it as an annotation property (@VectorField(dimension = somePositiveInteger)), or define a value binder (@VectorField(valueBinder = @ValueBinderRef(..))) that explicitly declares a vector field specifying the dimension.";
    }
    @Override
    public final SearchException vectorDimensionNotSpecified() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), vectorDimensionNotSpecified$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String vectorFieldMustUseExplicitExtractorPath$str() {
        return "HSEARCH700146: Vector fields require an explicit extraction path being specified, i.e. extraction must be set to DEFAULT and a nonempty array of container value extractor names provided, e.g. @ContainerExtraction(extract = ContainerExtract.DEFAULT, value = { ... }).";
    }
    @Override
    public final SearchException vectorFieldMustUseExplicitExtractorPath() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), vectorFieldMustUseExplicitExtractorPath$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownEntityNameForNonInterfaceSuperType$str() {
        return "HSEARCH700147: No matching entity type for entity name '%1$s'. Either this is not the name of an entity type, or neither the entity type nor any of its subclasses is mapped in Hibernate Search. Note interfaces are not considered superclasses and are not permitted here. Valid entity names are: %2$s";
    }
    @Override
    public final SearchException unknownEntityNameForNonInterfaceSuperType(final String invalidEntityName, final Collection<String> validEntityNames) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownEntityNameForNonInterfaceSuperType$str(), invalidEntityName, validEntityNames));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multipleEntityTypesWithSameName$str() {
        return "HSEARCH700148: Multiple entity types configured with the same name '%1$s': '%2$s', '%3$s'";
    }
    @Override
    public final SearchException multipleEntityTypesWithSameName(final String entityName, final PojoRawTypeModel<?> previousType, final PojoRawTypeModel<?> type) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), multipleEntityTypesWithSameName$str(), entityName, new org.hibernate.search.engine.logging.spi.MappableTypeModelFormatter(previousType), new org.hibernate.search.engine.logging.spi.MappableTypeModelFormatter(type)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multipleSecondaryEntityNames$str() {
        return "HSEARCH700149: Multiple secondary entity names assigned to the same type: '%1$s', '%2$s'.";
    }
    @Override
    public final SearchException multipleSecondaryEntityNames(final String entityName, final String otherEntityName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), multipleSecondaryEntityNames$str(), entityName, otherEntityName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multipleEntityTypesWithSameSecondaryName$str() {
        return "HSEARCH700150: Multiple entity types configured with the same secondary name '%1$s': '%2$s', '%3$s'";
    }
    @Override
    public final SearchException multipleEntityTypesWithSameSecondaryName(final String entityName, final PojoRawTypeModel<?> previousType, final PojoRawTypeModel<?> type) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), multipleEntityTypesWithSameSecondaryName$str(), entityName, new org.hibernate.search.engine.logging.spi.MappableTypeModelFormatter(previousType), new org.hibernate.search.engine.logging.spi.MappableTypeModelFormatter(type)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidEntitySuperType$str() {
        return "HSEARCH700151: Invalid type for '%1$s': the entity type must extend '%2$s', but entity type '%3$s' does not.";
    }
    @Override
    public final SearchException invalidEntitySuperType(final String entityName, final Class<?> expectedSuperType, final Class<?> actualJavaType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidEntitySuperType$str(), entityName, new org.hibernate.search.util.common.logging.impl.ClassFormatter(expectedSuperType), new org.hibernate.search.util.common.logging.impl.ClassFormatter(actualJavaType)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidIndexedSuperTypeEntityNames$str() {
        return "HSEARCH700152: No matching indexed entity types for entity names %1$s. Either these are not the names of entity types, or neither the entity types nor any of their subclasses are indexed in Hibernate Search. Valid entity names are: %2$s.";
    }
    @Override
    public final SearchException invalidIndexedSuperTypeEntityNames(final Collection<String> nonIndexedTypes, final Collection<String> validSuperTypes) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidIndexedSuperTypeEntityNames$str(), nonIndexedTypes, validSuperTypes));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidIndexedSuperTypeClasses$str() {
        return "HSEARCH700153: No matching indexed entity types for classes %1$s. Neither these classes nor any of their subclasses are indexed in Hibernate Search. Valid classes are: %2$s.";
    }
    @Override
    public final SearchException invalidIndexedSuperTypeClasses(final Collection<Class<?>> invalidClasses, final Collection<Class<?>> validClasses) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidIndexedSuperTypeClasses$str(), new org.hibernate.search.util.common.logging.impl.CommaSeparatedClassesFormatter(invalidClasses), new org.hibernate.search.util.common.logging.impl.CommaSeparatedClassesFormatter(validClasses)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownEntityNameForIndexedEntityType$str() {
        return "HSEARCH700154: No matching indexed entity type for name '%1$s'. Either this is not the name of an entity type, or the entity type is not indexed in Hibernate Search. Valid names for indexed entity types are: %2$s";
    }
    @Override
    public final SearchException unknownEntityNameForIndexedEntityType(final String invalidName, final Collection<String> validNames) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownEntityNameForIndexedEntityType$str(), invalidName, validNames));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String usingNonDefaultValueConvertAndValueModelNotAllowed$str() {
        return "HSEARCH700162: Using non-default `valueModel=ValueModel.%1$s` and `convert=ValueConvert.%2$s` at the same time is not allowed. Remove the `convert` attribute and keep only the `valueModel=ValueModel.%1$s`.";
    }
    @Override
    public final SearchException usingNonDefaultValueConvertAndValueModelNotAllowed(final String model, final String convert, final EventContext eventContext) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), usingNonDefaultValueConvertAndValueModelNotAllowed$str(), model, convert), eventContext);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String propertyNameCannotContainDots$str() {
        return "HSEARCH700170: Property name '%1$s' cannot contain dots.";
    }
    @Override
    public final IllegalArgumentException propertyNameCannotContainDots(final String propertyName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), propertyNameCannotContainDots$str(), propertyName));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
