/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.model.path.impl;

import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.path.impl.PojoPathFilterImpl;
import org.hibernate.search.mapper.pojo.model.path.impl.PojoPathOrdinals;
import org.hibernate.search.mapper.pojo.model.path.spi.PojoPathDefinition;
import org.hibernate.search.mapper.pojo.model.path.spi.PojoPathDefinitionProvider;
import org.hibernate.search.mapper.pojo.model.path.spi.PojoPathFilter;
import org.hibernate.search.util.common.impl.CollectionHelper;

public final class PojoRuntimePathsBuildingHelper {
    private final PojoPathOrdinals ordinals = new PojoPathOrdinals();
    private final PojoPathDefinitionProvider pathDefinitionProvider;
    private final Map<PojoModelPathValueNode, PojoPathDefinition> pathDefinitionCache = new LinkedHashMap<PojoModelPathValueNode, PojoPathDefinition>();

    public PojoRuntimePathsBuildingHelper(PojoPathDefinitionProvider pathDefinitionProvider) {
        this.pathDefinitionProvider = pathDefinitionProvider;
        for (String path : pathDefinitionProvider.preDefinedOrdinals()) {
            this.ordinals.toExistingOrNewOrdinal(path);
        }
    }

    public PojoPathDefinition toPathDefinition(PojoModelPathValueNode path) {
        return this.pathDefinitionCache.computeIfAbsent(path, this.pathDefinitionProvider::interpretPath);
    }

    public PojoPathOrdinals pathOrdinals() {
        return this.ordinals;
    }

    public PojoPathFilter createFilter(Set<PojoModelPathValueNode> paths) {
        LinkedHashSet pathsAsStrings = CollectionHelper.newLinkedHashSet((int)paths.size());
        for (PojoModelPathValueNode path : paths) {
            pathsAsStrings.addAll(this.toPathDefinition(path).stringRepresentations());
        }
        BitSet acceptedPaths = new BitSet();
        for (String pathsAsString : pathsAsStrings) {
            acceptedPaths.set(this.ordinals.toExistingOrNewOrdinal(pathsAsString));
        }
        return new PojoPathFilterImpl(this.ordinals, acceptedPaths);
    }

    public PojoPathFilter createFilterForNonNullOrdinals(List<?> list) {
        BitSet acceptedPaths = new BitSet();
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) == null) continue;
            acceptedPaths.set(i);
        }
        return new PojoPathFilterImpl(this.ordinals, acceptedPaths);
    }
}

