/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.search.definition.binding.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.search.projection.definition.spi.ConstantProjectionDefinition;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.mapping.building.impl.PojoMappingHelper;
import org.hibernate.search.mapper.pojo.model.path.spi.ProjectionConstructorPath;
import org.hibernate.search.mapper.pojo.model.spi.PojoConstructorIdentifier;
import org.hibernate.search.mapper.pojo.model.spi.PojoConstructorModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoMethodParameterModel;
import org.hibernate.search.mapper.pojo.reporting.spi.PojoEventContexts;
import org.hibernate.search.mapper.pojo.search.definition.binding.impl.ProjectionConstructorParameterBinder;
import org.hibernate.search.mapper.pojo.search.definition.impl.PojoConstructorProjectionDefinition;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;
import org.hibernate.search.util.common.reporting.spi.EventContextProvider;

public class ProjectionConstructorBinder<T>
implements EventContextProvider {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoMappingHelper mappingHelper;
    private final ProjectionConstructorParameterBinder<?> parent;
    final PojoConstructorModel<T> constructor;
    final PojoConstructorIdentifier constructorIdentifier;

    public ProjectionConstructorBinder(PojoMappingHelper mappingHelper, PojoConstructorModel<T> constructor) {
        this(mappingHelper, constructor, null);
    }

    public ProjectionConstructorBinder(PojoMappingHelper mappingHelper, PojoConstructorModel<T> constructor, ProjectionConstructorParameterBinder<?> parent) {
        this.mappingHelper = mappingHelper;
        this.parent = parent;
        this.constructor = constructor;
        this.constructorIdentifier = new PojoConstructorIdentifier(constructor);
    }

    public EventContext eventContext() {
        return EventContext.concat((EventContext)(this.parent == null ? null : this.parent.eventContext()), (EventContext[])new EventContext[]{PojoEventContexts.fromType(this.constructor.typeModel()), PojoEventContexts.fromConstructor(this.constructor)});
    }

    public PojoConstructorProjectionDefinition<T> bind() {
        if (this.constructor.typeModel().isAbstract()) {
            throw log.invalidAbstractTypeForProjectionConstructor(this.constructor.typeModel());
        }
        ProjectionConstructorPath path = this.getPathFromSameProjectionConstructor();
        if (path != null) {
            throw log.infiniteRecursionForProjectionConstructor(path);
        }
        ArrayList parameterDefinitions = new ArrayList();
        for (PojoMethodParameterModel<?> parameter : this.constructor.declaredParameters()) {
            BeanHolder parameterDefinition;
            ProjectionConstructorParameterBinder parameterBinder = new ProjectionConstructorParameterBinder(this.mappingHelper, this, parameter);
            try {
                parameterDefinition = parameterBinder.bind();
            }
            catch (RuntimeException e) {
                this.mappingHelper.failureCollector().withContext(parameterBinder.eventContext()).add((Throwable)e);
                parameterDefinition = ConstantProjectionDefinition.nullValue();
            }
            parameterDefinitions.add(parameterDefinition);
        }
        return new PojoConstructorProjectionDefinition<T>(this.constructorIdentifier, this.constructor.handle(), parameterDefinitions);
    }

    private ProjectionConstructorPath getPathFromSameProjectionConstructor() {
        if (this.parent == null) {
            return null;
        }
        ProjectionConstructorBinder<T> matchingAncestor = super.getMatchingAncestor(this.constructor);
        return matchingAncestor == null ? null : super.createPath(matchingAncestor, new ProjectionConstructorPath(this.constructorIdentifier), this.parent.parameter.index());
    }

    private ProjectionConstructorBinder<?> getMatchingAncestor(PojoConstructorModel<?> constructorToMatch) {
        if (this.constructor.equals(constructorToMatch)) {
            return this;
        }
        if (this.parent != null) {
            return super.getMatchingAncestor(constructorToMatch);
        }
        return null;
    }

    private ProjectionConstructorPath createPath(ProjectionConstructorBinder<?> firstElement, ProjectionConstructorPath child, int childPosition) {
        ProjectionConstructorPath pathFromSelf = new ProjectionConstructorPath(new PojoConstructorIdentifier(this.constructor), child, childPosition);
        if (this == firstElement) {
            return pathFromSelf;
        }
        return super.createPath(firstElement, pathFromSelf, this.parent.parameter.index());
    }
}

