/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.search.definition.binding.builtin;

import java.lang.invoke.MethodHandles;
import java.util.Optional;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.search.definition.binding.ProjectionBinder;
import org.hibernate.search.mapper.pojo.search.definition.binding.ProjectionBindingContext;
import org.hibernate.search.mapper.pojo.search.definition.binding.ProjectionBindingMultiContext;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class ObjectProjectionBinder
implements ProjectionBinder {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final String fieldPathOrNull;

    public static ObjectProjectionBinder create() {
        return ObjectProjectionBinder.create(null);
    }

    public static ObjectProjectionBinder create(String fieldPath) {
        return new ObjectProjectionBinder(fieldPath);
    }

    private ObjectProjectionBinder(String fieldPathOrNull) {
        this.fieldPathOrNull = fieldPathOrNull;
    }

    @Override
    public void bind(ProjectionBindingContext context) {
        Optional<? extends ProjectionBindingMultiContext> multiOptional = context.multi();
        String fieldPath = this.fieldPathOrFail(context);
        if (multiOptional.isPresent()) {
            ProjectionBindingMultiContext multi = multiOptional.get();
            this.bind(context, multi, fieldPath, multi.containerElement().rawType());
        } else {
            this.bind(context, fieldPath, context.constructorParameter().rawType());
        }
    }

    private <T> void bind(ProjectionBindingContext context, String fieldPath, Class<T> constructorParameterType) {
        context.definition(constructorParameterType, context.createObjectDefinition(fieldPath, constructorParameterType));
    }

    private <T> void bind(ProjectionBindingContext context, ProjectionBindingMultiContext multi, String fieldPath, Class<T> containerElementType) {
        multi.definition(containerElementType, context.createObjectDefinitionMulti(fieldPath, containerElementType));
    }

    private String fieldPathOrFail(ProjectionBindingContext context) {
        if (this.fieldPathOrNull != null) {
            return this.fieldPathOrNull;
        }
        Optional<String> paramName = context.constructorParameter().name();
        if (!paramName.isPresent()) {
            throw log.missingParameterNameForObjectProjectionInProjectionConstructor();
        }
        return paramName.get();
    }
}

