/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.search.definition.binding.builtin;

import java.lang.invoke.MethodHandles;
import java.util.Optional;
import org.hibernate.search.engine.search.common.ValueConvert;
import org.hibernate.search.engine.search.projection.definition.spi.FieldProjectionDefinition;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.search.definition.binding.ProjectionBinder;
import org.hibernate.search.mapper.pojo.search.definition.binding.ProjectionBindingContext;
import org.hibernate.search.mapper.pojo.search.definition.binding.ProjectionBindingMultiContext;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class FieldProjectionBinder
implements ProjectionBinder {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final String fieldPathOrNull;
    private ValueConvert valueConvert = ValueConvert.YES;

    public static FieldProjectionBinder create() {
        return FieldProjectionBinder.create(null);
    }

    public static FieldProjectionBinder create(String fieldPath) {
        return new FieldProjectionBinder(fieldPath);
    }

    private FieldProjectionBinder(String fieldPathOrNull) {
        this.fieldPathOrNull = fieldPathOrNull;
    }

    public FieldProjectionBinder valueConvert(ValueConvert valueConvert) {
        this.valueConvert = valueConvert;
        return this;
    }

    @Override
    public void bind(ProjectionBindingContext context) {
        Optional<? extends ProjectionBindingMultiContext> multiOptional = context.multi();
        String fieldPath = this.fieldPathOrFail(context);
        if (multiOptional.isPresent()) {
            ProjectionBindingMultiContext multi = multiOptional.get();
            this.bind(multi, fieldPath, multi.containerElement().rawType());
        } else {
            this.bind(context, fieldPath, context.constructorParameter().rawType());
        }
    }

    private <T> void bind(ProjectionBindingContext context, String fieldPath, Class<T> constructorParameterType) {
        context.definition(constructorParameterType, new FieldProjectionDefinition.SingleValued(fieldPath, constructorParameterType, this.valueConvert));
    }

    private <T> void bind(ProjectionBindingMultiContext context, String fieldPath, Class<T> containerElementType) {
        context.definition(containerElementType, new FieldProjectionDefinition.MultiValued(fieldPath, containerElementType, this.valueConvert));
    }

    private String fieldPathOrFail(ProjectionBindingContext context) {
        if (this.fieldPathOrNull != null) {
            return this.fieldPathOrNull;
        }
        Optional<String> paramName = context.constructorParameter().name();
        if (!paramName.isPresent()) {
            throw log.missingParameterNameForFieldProjectionInProjectionConstructor();
        }
        return paramName.get();
    }
}

