/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.massindexing.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.engine.backend.work.execution.OperationSubmitter;
import org.hibernate.search.mapper.pojo.loading.spi.PojoMassEntityLoader;
import org.hibernate.search.mapper.pojo.loading.spi.PojoMassEntitySink;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.massindexing.MassIndexingEnvironment;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoMassIndexingFailureHandledRunnable;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoMassIndexingIndexedTypeGroup;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoMassIndexingNotifier;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoProducerConsumerQueue;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexingEntityLoadingContext;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexingLoadingStrategy;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexingSessionContext;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexer;
import org.hibernate.search.util.common.impl.Futures;
import org.hibernate.search.util.common.impl.Throwables;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class PojoMassIndexingEntityLoadingRunnable<E, I>
extends PojoMassIndexingFailureHandledRunnable {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoMassIndexingIndexedTypeGroup<E> typeGroup;
    private final PojoMassIndexingLoadingStrategy<E, I> loadingStrategy;
    private final PojoProducerConsumerQueue<List<I>> identifierQueue;
    private final String tenantId;
    private final MassIndexingEnvironment.EntityLoadingContext entityLoadingContext;

    protected PojoMassIndexingEntityLoadingRunnable(PojoMassIndexingNotifier notifier, MassIndexingEnvironment environment, PojoMassIndexingIndexedTypeGroup<E> typeGroup, PojoMassIndexingLoadingStrategy<E, I> loadingStrategy, PojoProducerConsumerQueue<List<I>> identifierQueue, String tenantId) {
        super(notifier, environment);
        this.typeGroup = typeGroup;
        this.loadingStrategy = loadingStrategy;
        this.identifierQueue = identifierQueue;
        this.tenantId = tenantId;
        this.entityLoadingContext = new EntityLoadingContextImpl();
    }

    @Override
    protected void runWithFailureHandler() throws InterruptedException {
        log.trace("started");
        LoadingContext context = new LoadingContext();
        try (PojoMassEntityLoader<I> entityLoader = this.loadingStrategy.createEntityLoader(context);){
            List<I> idList;
            do {
                if ((idList = this.identifierQueue.take()) == null) continue;
                log.tracef("received list of ids %s", idList);
                try {
                    entityLoader.load(idList);
                }
                catch (RuntimeException e) {
                    this.getNotifier().reportEntitiesLoadingFailure(this.typeGroup, idList, e);
                }
            } while (idList != null);
            context.waitForLastBatches();
        }
        log.trace("finished");
    }

    @Override
    protected void cleanUpOnFailure() {
    }

    @Override
    protected void cleanUpOnInterruption() {
    }

    @Override
    protected MassIndexingEnvironment.Context createMassIndexingEnvironmentContext() {
        return this.entityLoadingContext;
    }

    @Override
    protected boolean supportsThreadLifecycleHooks() {
        return true;
    }

    @Override
    protected String operationName() {
        return log.massIndexingLoadingAndExtractingEntityData(this.typeGroup.notifiedGroupName());
    }

    private static final class EntityLoadingContextImpl
    implements MassIndexingEnvironment.EntityLoadingContext {
        private EntityLoadingContextImpl() {
        }
    }

    private final class LoadingContext
    implements PojoMassIndexingEntityLoadingContext<E> {
        private static final int CONCURRENT_BATCHES = 2;
        private final List<IndexingBatch> batches = new ArrayList<IndexingBatch>(2);
        private int currentBatchIndex = 0;

        public LoadingContext() {
            for (int i = 0; i < 2; ++i) {
                this.batches.add(new IndexingBatch());
            }
        }

        @Override
        public Set<PojoRawTypeIdentifier<? extends E>> includedTypes() {
            return Collections.unmodifiableSet(PojoMassIndexingEntityLoadingRunnable.this.typeGroup.includedTypesIdentifiers());
        }

        @Override
        public PojoMassEntitySink<E> createSink(final PojoMassIndexingSessionContext sessionContext) {
            final PojoIndexer indexer = sessionContext.createIndexer();
            return new PojoMassEntitySink<E>(){

                @Override
                public void accept(List<? extends E> batch) throws InterruptedException {
                    if (batch == null || batch.isEmpty()) {
                        return;
                    }
                    IndexingBatch currentBatch = (IndexingBatch)LoadingContext.this.batches.get(LoadingContext.this.currentBatchIndex);
                    currentBatch.waitForIndexingEndAndReport();
                    currentBatch.startIndexingList(sessionContext, indexer, batch);
                    LoadingContext.this.currentBatchIndex = (LoadingContext.this.currentBatchIndex + 1) % 2;
                }
            };
        }

        @Override
        public String tenantIdentifier() {
            return PojoMassIndexingEntityLoadingRunnable.this.tenantId;
        }

        public void waitForLastBatches() throws InterruptedException {
            for (IndexingBatch batch : this.batches) {
                batch.waitForIndexingEndAndReport();
            }
        }
    }

    private final class IndexingBatch {
        private PojoMassIndexingSessionContext sessionContext;
        private List<?> entities;
        private CompletableFuture<?>[] indexingFutures;

        private IndexingBatch() {
        }

        public void startIndexingList(PojoMassIndexingSessionContext sessionContext, PojoIndexer indexer, List<?> entities) throws InterruptedException {
            this.sessionContext = sessionContext;
            this.entities = entities;
            PojoMassIndexingEntityLoadingRunnable.this.getNotifier().reportEntitiesLoaded(entities.size());
            this.indexingFutures = new CompletableFuture[entities.size()];
            for (int i = 0; i < entities.size(); ++i) {
                Object entity = entities.get(i);
                this.indexingFutures[i] = this.startIndexing(sessionContext, indexer, entity);
            }
        }

        private void waitForIndexingEndAndReport() throws InterruptedException {
            if (this.indexingFutures == null) {
                return;
            }
            Futures.unwrappedExceptionGet((Future)((Object)CompletableFuture.allOf(this.indexingFutures).exceptionally(exception -> null)));
            int successfulEntities = 0;
            for (int i = 0; i < this.entities.size(); ++i) {
                CompletableFuture<?> future = this.indexingFutures[i];
                if (future.isCompletedExceptionally()) {
                    Object entity = this.entities.get(i);
                    PojoMassIndexingEntityLoadingRunnable.this.getNotifier().reportEntityIndexingFailure(PojoMassIndexingEntityLoadingRunnable.this.typeGroup, this.sessionContext, entity, Throwables.expectException((Throwable)Futures.getThrowableNow(future)));
                    continue;
                }
                ++successfulEntities;
            }
            PojoMassIndexingEntityLoadingRunnable.this.getNotifier().reportDocumentsAdded(successfulEntities);
            this.sessionContext = null;
            this.entities = null;
            this.indexingFutures = null;
        }

        private CompletableFuture<?> startIndexing(PojoMassIndexingSessionContext sessionContext, PojoIndexer indexer, Object entity) throws InterruptedException {
            CompletableFuture<?> future;
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            try {
                PojoRawTypeIdentifier<?> typeIdentifier = this.detectTypeIdentifier(sessionContext, entity);
                future = indexer.add(typeIdentifier, null, null, entity, DocumentCommitStrategy.NONE, DocumentRefreshStrategy.NONE, OperationSubmitter.blocking());
            }
            catch (RuntimeException e) {
                CompletableFuture future2 = new CompletableFuture();
                future2.completeExceptionally(e);
                return future2;
            }
            PojoMassIndexingEntityLoadingRunnable.this.getNotifier().reportDocumentBuilt();
            return future;
        }

        private PojoRawTypeIdentifier<?> detectTypeIdentifier(PojoMassIndexingSessionContext sessionContext, Object entity) {
            return sessionContext.runtimeIntrospector().detectEntityType(entity);
        }
    }
}

