/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.work.impl;

import java.util.BitSet;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.hibernate.search.engine.backend.common.spi.EntityReferenceFactory;
import org.hibernate.search.engine.backend.common.spi.MultiEntityOperationExecutionReport;
import org.hibernate.search.engine.backend.work.execution.OperationSubmitter;
import org.hibernate.search.mapper.pojo.route.DocumentRouteDescriptor;
import org.hibernate.search.mapper.pojo.route.DocumentRoutesDescriptor;
import org.hibernate.search.mapper.pojo.work.impl.PojoTypeIndexingPlanDelegate;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkTypeContext;
import org.hibernate.search.mapper.pojo.work.spi.DirtinessDescriptor;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexingQueueEventPayload;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexingQueueEventSendingPlan;
import org.hibernate.search.mapper.pojo.work.spi.PojoWorkSessionContext;
import org.hibernate.search.util.common.AssertionFailure;

final class PojoTypeIndexingPlanEventQueueDelegate<I, E>
implements PojoTypeIndexingPlanDelegate<I, E> {
    private final PojoWorkTypeContext<I, E> typeContext;
    private final PojoWorkSessionContext sessionContext;
    private final PojoIndexingQueueEventSendingPlan sendingPlan;

    PojoTypeIndexingPlanEventQueueDelegate(PojoWorkTypeContext<I, E> typeContext, PojoWorkSessionContext sessionContext, PojoIndexingQueueEventSendingPlan sendingPlan) {
        this.typeContext = typeContext;
        this.sessionContext = sessionContext;
        this.sendingPlan = sendingPlan;
    }

    @Override
    public boolean isDirtyForAddOrUpdate(boolean forceSelfDirty, boolean forceContainingDirty, BitSet dirtyPathsOrNull) {
        return forceSelfDirty || forceContainingDirty || dirtyPathsOrNull != null && this.typeContext.reindexingResolver().dirtySelfOrContainingFilter().test(dirtyPathsOrNull);
    }

    @Override
    public void add(I identifier, DocumentRouteDescriptor route, Supplier<E> entitySupplier) {
        DirtinessDescriptor dirtiness = new DirtinessDescriptor(true, true, Collections.emptySet(), false);
        this.sendingPlan.append(this.typeContext.entityName(), identifier, this.typeContext.identifierMapping().toDocumentIdentifier(identifier, this.sessionContext.mappingContext()), new PojoIndexingQueueEventPayload(DocumentRoutesDescriptor.of(route), dirtiness));
    }

    @Override
    public void addOrUpdate(I identifier, DocumentRoutesDescriptor routes, Supplier<E> entitySupplier, boolean forceSelfDirty, boolean forceContainingDirty, BitSet dirtyPaths, boolean updatedBecauseOfContained, boolean updateBecauseOfDirty) {
        DirtinessDescriptor dirtiness = new DirtinessDescriptor(forceSelfDirty, forceContainingDirty, this.typeContext.pathOrdinals().toPathSet(dirtyPaths), updatedBecauseOfContained);
        this.sendingPlan.append(this.typeContext.entityName(), identifier, this.typeContext.identifierMapping().toDocumentIdentifier(identifier, this.sessionContext.mappingContext()), new PojoIndexingQueueEventPayload(routes, dirtiness));
    }

    @Override
    public void delete(I identifier, DocumentRoutesDescriptor routes, Supplier<E> entitySupplier) {
        DirtinessDescriptor dirtiness = new DirtinessDescriptor(true, false, Collections.emptySet(), false);
        this.sendingPlan.append(this.typeContext.entityName(), identifier, this.typeContext.identifierMapping().toDocumentIdentifier(identifier, this.sessionContext.mappingContext()), new PojoIndexingQueueEventPayload(routes, dirtiness));
    }

    @Override
    public void discard() {
        throw new AssertionFailure("discard() should be handled at the strategy level");
    }

    @Override
    public <R> CompletableFuture<MultiEntityOperationExecutionReport<R>> executeAndReport(EntityReferenceFactory<R> entityReferenceFactory, OperationSubmitter operationSubmitter) {
        throw new AssertionFailure("executeAndReport() should be handled at the strategy level");
    }
}

