/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.search.definition.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.hibernate.search.engine.backend.common.spi.FieldPaths;
import org.hibernate.search.engine.reporting.spi.ContextualFailureCollector;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.definition.spi.CompositeProjectionDefinition;
import org.hibernate.search.engine.search.projection.dsl.CompositeProjectionInnerStep;
import org.hibernate.search.engine.search.projection.dsl.CompositeProjectionValueStep;
import org.hibernate.search.engine.search.projection.dsl.SearchProjectionFactory;
import org.hibernate.search.mapper.pojo.extractor.impl.BoundContainerExtractorPath;
import org.hibernate.search.mapper.pojo.extractor.mapping.programmatic.ContainerExtractorPath;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.mapping.building.impl.PojoMappingHelper;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoMappingCollector;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoSearchMappingCollectorConstructorNode;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoSearchMappingCollectorTypeNode;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoTypeMetadataContributor;
import org.hibernate.search.mapper.pojo.model.spi.PojoConstructorModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoMethodParameterModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel;
import org.hibernate.search.mapper.pojo.reporting.impl.PojoConstructorProjectionDefinitionMessages;
import org.hibernate.search.mapper.pojo.reporting.spi.PojoEventContexts;
import org.hibernate.search.mapper.pojo.search.definition.impl.ConstructorProjectionApplicationException;
import org.hibernate.search.mapper.pojo.search.definition.impl.InnerProjectionDefinition;
import org.hibernate.search.mapper.pojo.search.definition.impl.NullInnerProjectionDefinition;
import org.hibernate.search.mapper.pojo.search.definition.impl.ObjectInnerProjectionDefinition;
import org.hibernate.search.mapper.pojo.search.definition.impl.ValueInnerProjectionDefinition;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.impl.ToStringTreeAppendable;
import org.hibernate.search.util.common.impl.ToStringTreeBuilder;
import org.hibernate.search.util.common.logging.impl.CommaSeparatedClassesFormatter;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reflect.spi.ValueCreateHandle;

public final class PojoConstructorProjectionDefinition<T>
implements CompositeProjectionDefinition<T>,
ToStringTreeAppendable {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final PojoConstructorProjectionDefinitionMessages MESSAGES = PojoConstructorProjectionDefinitionMessages.INSTANCE;
    private final ConstructorIdentifier constructor;
    private final ValueCreateHandle<? extends T> valueCreateHandle;
    private final List<InnerProjectionDefinition> innerDefinitions;

    private PojoConstructorProjectionDefinition(PojoConstructorModel<T> constructor, List<InnerProjectionDefinition> innerDefinitions) {
        this.constructor = new ConstructorIdentifier(constructor);
        this.valueCreateHandle = constructor.handle();
        this.innerDefinitions = innerDefinitions;
    }

    public String toString() {
        return "PojoConstructorProjectionDefinition[valueCreateHandle=" + this.valueCreateHandle + ']';
    }

    public void appendTo(ToStringTreeBuilder builder) {
        builder.attribute("valueCreateHandle", this.valueCreateHandle).attribute("innerDefinitions", this.innerDefinitions);
    }

    public CompositeProjectionValueStep<?, T> apply(SearchProjectionFactory<?, ?> projectionFactory, CompositeProjectionInnerStep initialStep) {
        int i = -1;
        try {
            SearchProjection[] innerProjections = new SearchProjection[this.innerDefinitions.size()];
            for (i = 0; i < this.innerDefinitions.size(); ++i) {
                innerProjections[i] = this.innerDefinitions.get(i).create(projectionFactory);
            }
            return initialStep.from(innerProjections).asArray(this.valueCreateHandle);
        }
        catch (ConstructorProjectionApplicationException e) {
            ProjectionConstructorPath path = new ProjectionConstructorPath(e.projectionConstructorPath(), i, this.constructor);
            throw log.errorApplyingProjectionConstructor(e.getCause().getMessage(), (Exception)((Object)e), path);
        }
        catch (SearchException e) {
            ProjectionConstructorPath path = new ProjectionConstructorPath(this.constructor);
            throw log.errorApplyingProjectionConstructor(e.getMessage(), (Exception)((Object)e), path);
        }
    }

    public static class ConstructorIdentifier {
        private final String name;
        private final Class<?>[] parametersJavaTypes;

        public ConstructorIdentifier(PojoConstructorModel<?> constructor) {
            this.name = constructor.typeModel().name();
            this.parametersJavaTypes = constructor.parametersJavaTypes();
        }

        public String toHighlightedString(int position) {
            return this.name + "(" + CommaSeparatedClassesFormatter.formatHighlighted((Class[])this.parametersJavaTypes, (int)position) + ")";
        }

        public String toString() {
            return this.toHighlightedString(-1);
        }
    }

    public static class ProjectionConstructorPath {
        private final ProjectionConstructorPath child;
        private final int position;
        private final ConstructorIdentifier constructor;

        public ProjectionConstructorPath(ProjectionConstructorPath child, int position, ConstructorIdentifier constructor) {
            this.child = child;
            this.position = position;
            this.constructor = constructor;
        }

        public ProjectionConstructorPath(ConstructorIdentifier constructor) {
            this(null, -1, constructor);
        }

        public String toPrefixedString() {
            return "\n" + MESSAGES.executedConstructorPath() + "\n" + this;
        }

        public String toString() {
            return this.child == null ? this.constructor.toString() : this.child + "\n\t\u2937 for parameter #" + this.position + " in " + this.constructor.toHighlightedString(this.position);
        }
    }

    private static class ConstructorParameterTypeNode<T>
    implements PojoSearchMappingCollectorTypeNode,
    Consumer<PojoConstructorProjectionDefinition<T>> {
        private final PojoMappingHelper mappingHelper;
        private final ConstructorParameterNode<?> parent;
        private final String relativeFieldPath;
        private final PojoRawTypeModel<T> type;
        private PojoConstructorProjectionDefinition<T> constructorProjectionDefinition;

        public ConstructorParameterTypeNode(PojoMappingHelper mappingHelper, ConstructorParameterNode<?> parent, String relativeFieldPath, PojoRawTypeModel<T> type) {
            this.mappingHelper = mappingHelper;
            this.parent = parent;
            this.relativeFieldPath = relativeFieldPath;
            this.type = type;
        }

        @Override
        public ContextualFailureCollector failureCollector() {
            return this.parent.failureCollector().withContext(PojoEventContexts.fromType(this.type));
        }

        @Override
        public PojoRawTypeIdentifier<?> typeIdentifier() {
            return this.type.typeIdentifier();
        }

        @Override
        public PojoSearchMappingCollectorConstructorNode constructor(Class<?>[] parameterTypes) {
            return new ConstructorNode<T>(this.mappingHelper, this, this.type.constructor(parameterTypes), this);
        }

        @Override
        public void accept(PojoConstructorProjectionDefinition<T> constructorProjectionDefinition) {
            if (this.constructorProjectionDefinition != null) {
                throw log.multipleProjectionConstructorsForType(this.type.typeIdentifier().javaClass());
            }
            this.constructorProjectionDefinition = constructorProjectionDefinition;
        }
    }

    private static class ConstructorParameterNode<P>
    implements PojoMappingCollector {
        private final PojoMappingHelper mappingHelper;
        private final ConstructorNode<?> parent;
        private final PojoMethodParameterModel<P> parameter;

        public ConstructorParameterNode(PojoMappingHelper mappingHelper, ConstructorNode<?> parent, PojoMethodParameterModel<P> parameter) {
            this.mappingHelper = mappingHelper;
            this.parent = parent;
            this.parameter = parameter;
        }

        @Override
        public ContextualFailureCollector failureCollector() {
            return this.parent.failureCollector().withContext(PojoEventContexts.fromMethodParameter(this.parameter));
        }

        InnerProjectionDefinition inferInnerProjection() {
            boolean multi;
            if (this.parameter.isImplicit()) {
                return NullInnerProjectionDefinition.INSTANCE;
            }
            PojoTypeModel<P> parameterType = this.parameter.typeModel();
            BoundContainerExtractorPath<P, ?> boundParameterElementPath = this.mappingHelper.indexModelBinder().bindExtractorPath(this.parameter.typeModel(), ContainerExtractorPath.defaultExtractors());
            List<String> boundParameterElementExtractorNames = boundParameterElementPath.getExtractorPath().explicitExtractorNames();
            if (boundParameterElementExtractorNames.isEmpty()) {
                multi = false;
            } else {
                if (boundParameterElementExtractorNames.size() > 1 || !"collection".equals(boundParameterElementExtractorNames.get(0)) && !"iterable".equals(boundParameterElementExtractorNames.get(0)) || !this.mappingHelper.introspector().typeModel(List.class).isSubTypeOf(parameterType.rawType().rawType())) {
                    throw log.invalidMultiValuedParameterTypeForProjectionConstructor(parameterType, PojoEventContexts.fromMethodParameter(this.parameter));
                }
                multi = true;
            }
            PojoRawTypeModel<?> boundParameterElementRawType = boundParameterElementPath.getExtractedType().rawType();
            Optional<String> paramName = this.parameter.name();
            if (!paramName.isPresent()) {
                throw log.missingParameterNameForProjectionConstructor(((ConstructorNode)this.parent).constructor.typeModel(), PojoEventContexts.fromMethodParameter(this.parameter));
            }
            String innerRelativeFieldPath = paramName.get();
            String innerAbsoluteFieldPath = FieldPaths.compose((String)((ConstructorNode)this.parent).absoluteFieldPath, (String)innerRelativeFieldPath);
            ConstructorParameterTypeNode parameterTypeNode = new ConstructorParameterTypeNode(this.mappingHelper, this, innerRelativeFieldPath, boundParameterElementRawType);
            for (PojoTypeMetadataContributor contributor : this.mappingHelper.contributorProvider().get(boundParameterElementRawType)) {
                contributor.contributeSearchMapping(parameterTypeNode);
            }
            if (parameterTypeNode.constructorProjectionDefinition != null) {
                return new ObjectInnerProjectionDefinition(innerAbsoluteFieldPath, multi, parameterTypeNode.constructorProjectionDefinition);
            }
            return new ValueInnerProjectionDefinition(innerAbsoluteFieldPath, multi, boundParameterElementRawType.typeIdentifier().javaClass());
        }
    }

    static class ConstructorNode<T>
    implements PojoSearchMappingCollectorConstructorNode {
        private final PojoMappingHelper mappingHelper;
        private final ConstructorParameterTypeNode<?> parent;
        private final String relativeFieldPath;
        private final String absoluteFieldPath;
        private final PojoConstructorModel<T> constructor;
        private final Consumer<PojoConstructorProjectionDefinition<T>> collector;

        ConstructorNode(PojoMappingHelper mappingHelper, PojoConstructorModel<T> constructor, Consumer<PojoConstructorProjectionDefinition<T>> collector) {
            this(mappingHelper, null, constructor, collector);
        }

        ConstructorNode(PojoMappingHelper mappingHelper, ConstructorParameterTypeNode<?> parent, PojoConstructorModel<T> constructor, Consumer<PojoConstructorProjectionDefinition<T>> collector) {
            this.mappingHelper = mappingHelper;
            this.parent = parent;
            this.relativeFieldPath = parent == null ? null : ((ConstructorParameterTypeNode)parent).relativeFieldPath;
            this.absoluteFieldPath = FieldPaths.compose((String)(parent == null ? null : ((ConstructorParameterNode)((ConstructorParameterTypeNode)parent).parent).parent.absoluteFieldPath), (String)this.relativeFieldPath);
            this.constructor = constructor;
            this.collector = collector;
        }

        @Override
        public ContextualFailureCollector failureCollector() {
            if (this.parent == null) {
                return this.mappingHelper.failureCollector().withContext(PojoEventContexts.fromType(this.constructor.typeModel())).withContext(PojoEventContexts.fromConstructor(this.constructor));
            }
            return this.parent.failureCollector().withContext(PojoEventContexts.fromConstructor(this.constructor));
        }

        @Override
        public void projectionConstructor() {
            String path;
            if (this.constructor.typeModel().isAbstract()) {
                throw log.invalidAbstractTypeForProjectionConstructor(this.constructor.typeModel());
            }
            if (this.parent != null && (path = ((ConstructorParameterNode)((ConstructorParameterTypeNode)this.parent).parent).parent.getPathFromSameProjectionConstructor(this.constructor)) != null) {
                throw log.infiniteRecursionForProjectionConstructor(this.constructor, FieldPaths.compose((String)path, (String)this.relativeFieldPath));
            }
            ArrayList<InnerProjectionDefinition> innerDefinitions = new ArrayList<InnerProjectionDefinition>();
            for (PojoMethodParameterModel<?> parameter : this.constructor.declaredParameters()) {
                ConstructorParameterNode parameterNode = new ConstructorParameterNode(this.mappingHelper, this, parameter);
                innerDefinitions.add(parameterNode.inferInnerProjection());
            }
            this.collector.accept(new PojoConstructorProjectionDefinition(this.constructor, innerDefinitions));
        }

        private String getPathFromSameProjectionConstructor(PojoConstructorModel<?> constructorToMatch) {
            if (this.constructor.equals(constructorToMatch)) {
                return "";
            }
            if (this.parent != null) {
                String path = ((ConstructorParameterNode)((ConstructorParameterTypeNode)this.parent).parent).parent.getPathFromSameProjectionConstructor(constructorToMatch);
                return path == null ? null : FieldPaths.compose((String)path, (String)this.relativeFieldPath);
            }
            return null;
        }
    }
}

