/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.mapping.impl.AbstractPojoTypeManager;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoContainedTypeManager;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoIndexedTypeManager;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.scope.impl.PojoScopeIndexedTypeContext;
import org.hibernate.search.mapper.pojo.scope.impl.PojoScopeTypeContextProvider;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkTypeContext;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkTypeContextProvider;
import org.hibernate.search.util.common.data.spi.KeyValueProvider;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class PojoTypeManagerContainer
implements AutoCloseable,
PojoWorkTypeContextProvider,
PojoScopeTypeContextProvider {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final KeyValueProvider<PojoRawTypeIdentifier<?>, AbstractPojoTypeManager<?, ?>> byExactType;
    private final KeyValueProvider<PojoRawTypeIdentifier<?>, PojoIndexedTypeManager<?, ?>> indexedByExactType;
    private final KeyValueProvider<String, AbstractPojoTypeManager<?, ?>> byEntityName;
    private final Map<PojoRawTypeIdentifier<?>, Set<? extends PojoIndexedTypeManager<?, ?>>> indexedBySuperType;
    private final Collection<PojoIndexedTypeManager<?, ?>> allIndexed;

    public static Builder builder() {
        return new Builder();
    }

    private PojoTypeManagerContainer(Builder builder) {
        PojoRawTypeIdentifier typeIdentifier;
        LinkedHashMap<PojoRawTypeIdentifier, AbstractPojoTypeManager> byExactTypeContent = new LinkedHashMap<PojoRawTypeIdentifier, AbstractPojoTypeManager>();
        LinkedHashMap<PojoRawTypeIdentifier, AbstractPojoTypeManager> indexedByExactTypeContent = new LinkedHashMap<PojoRawTypeIdentifier, AbstractPojoTypeManager>();
        LinkedHashMap<String, AbstractPojoTypeManager> byEntityNameContent = new LinkedHashMap<String, AbstractPojoTypeManager>();
        for (AbstractPojoTypeManager typeManager : builder.indexed) {
            typeIdentifier = ((PojoIndexedTypeManager)typeManager).typeIdentifier;
            byExactTypeContent.put(typeIdentifier, typeManager);
            indexedByExactTypeContent.put(typeIdentifier, typeManager);
            byEntityNameContent.put(typeManager.entityName(), typeManager);
        }
        for (AbstractPojoTypeManager typeManager : builder.contained) {
            typeIdentifier = ((PojoContainedTypeManager)typeManager).typeIdentifier;
            byExactTypeContent.put(typeIdentifier, typeManager);
            byEntityNameContent.put(typeManager.entityName(), typeManager);
        }
        this.byExactType = new KeyValueProvider(byExactTypeContent, log::unknownTypeIdentifierForMappedEntityType);
        this.indexedByExactType = new KeyValueProvider(indexedByExactTypeContent, log::unknownTypeIdentifierForIndexedEntityType);
        this.byEntityName = new KeyValueProvider(byEntityNameContent, log::unknownEntityNameForMappedEntityType);
        this.indexedBySuperType = new LinkedHashMap(builder.indexedBySuperType);
        this.indexedBySuperType.replaceAll((k, v) -> Collections.unmodifiableSet(v));
        this.allIndexed = Collections.unmodifiableCollection(indexedByExactTypeContent.values());
    }

    @Override
    public void close() {
        try (Closer closer = new Closer();){
            closer.pushAll(AbstractPojoTypeManager::close, this.allIndexed);
        }
    }

    public <E> AbstractPojoTypeManager<?, E> forExactType(PojoRawTypeIdentifier<E> typeIdentifier) {
        return (AbstractPojoTypeManager)this.byExactType.getOrFail(typeIdentifier);
    }

    public <E> PojoIndexedTypeManager<?, E> indexedForExactType(PojoRawTypeIdentifier<E> typeIdentifier) {
        return (PojoIndexedTypeManager)this.indexedByExactType.getOrFail(typeIdentifier);
    }

    @Override
    public Set<PojoRawTypeIdentifier<?>> allIndexedSuperTypes() {
        return this.indexedBySuperType.keySet();
    }

    @Override
    public <E> Optional<? extends Set<? extends PojoScopeIndexedTypeContext<?, ? extends E>>> allIndexedForSuperType(PojoRawTypeIdentifier<E> typeIdentifier) {
        return Optional.ofNullable(this.indexedBySuperType.get(typeIdentifier));
    }

    @Override
    public KeyValueProvider<String, ? extends PojoWorkTypeContext<?, ?>> byEntityName() {
        return this.byEntityName;
    }

    Collection<PojoIndexedTypeManager<?, ?>> allIndexed() {
        return this.allIndexed;
    }

    public static class Builder {
        private final List<PojoIndexedTypeManager<?, ?>> indexed = new ArrayList();
        private final List<PojoContainedTypeManager<?, ?>> contained = new ArrayList();
        private final Map<PojoRawTypeIdentifier<?>, Set<PojoIndexedTypeManager<?, ?>>> indexedBySuperType = new LinkedHashMap();

        private Builder() {
        }

        public <E> void addIndexed(PojoRawTypeModel<E> typeModel, PojoIndexedTypeManager<?, E> typeManager) {
            this.indexed.add(typeManager);
            typeModel.descendingSuperTypes().map(PojoRawTypeModel::typeIdentifier).forEach(clazz -> this.indexedBySuperType.computeIfAbsent((PojoRawTypeIdentifier<?>)clazz, ignored -> new LinkedHashSet()).add(typeManager));
        }

        public <E> void addContained(PojoContainedTypeManager<?, E> typeManager) {
            this.contained.add(typeManager);
        }

        public void closeOnFailure() {
            try (Closer closer = new Closer();){
                closer.pushAll(PojoIndexedTypeManager::close, this.indexed);
                closer.pushAll(AbstractPojoTypeManager::close, this.contained);
            }
        }

        public PojoTypeManagerContainer build() {
            return new PojoTypeManagerContainer(this);
        }
    }
}

