/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.building.impl;

import java.lang.invoke.MethodHandles;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.thread.spi.ThreadPoolProvider;
import org.hibernate.search.engine.mapper.mapping.building.spi.BackendsInfo;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexedEmbeddedDefinition;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexedEmbeddedPathTracker;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexedEntityBindingMapperContext;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappedIndexManagerBuilder;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappedIndexManagerFactory;
import org.hibernate.search.engine.mapper.mapping.building.spi.Mapper;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingAbortedException;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingBuildContext;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingPartialBuildState;
import org.hibernate.search.engine.mapper.model.spi.MappableTypeModel;
import org.hibernate.search.engine.mapper.model.spi.TypeMetadataContributorProvider;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.engine.reporting.spi.ContextualFailureCollector;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.reporting.spi.FailureCollector;
import org.hibernate.search.engine.tenancy.spi.TenancyMode;
import org.hibernate.search.mapper.pojo.automaticindexing.ReindexOnUpdate;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoImplicitReindexingResolverBuildingHelper;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoImplicitReindexingResolver;
import org.hibernate.search.mapper.pojo.bridge.IdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.impl.BoundRoutingBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.impl.RoutingBindingContextImpl;
import org.hibernate.search.mapper.pojo.bridge.mapping.impl.BridgeResolver;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.RoutingBinder;
import org.hibernate.search.mapper.pojo.extractor.impl.ContainerExtractorBinder;
import org.hibernate.search.mapper.pojo.identity.impl.IdentifierMappingImplementor;
import org.hibernate.search.mapper.pojo.identity.impl.IdentityMappingMode;
import org.hibernate.search.mapper.pojo.identity.impl.PojoRootIdentityMappingCollector;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.mapping.building.impl.PojoIndexModelBinder;
import org.hibernate.search.mapper.pojo.mapping.building.impl.PojoIndexedTypeManagerBuilder;
import org.hibernate.search.mapper.pojo.mapping.building.impl.PojoMappingHelper;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoContainedTypeExtendedMappingCollector;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoIndexMappingCollectorTypeNode;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoMapperDelegate;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoSearchMappingCollectorTypeNode;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoTypeMetadataContributor;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoContainedTypeManager;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoMappingDelegateImpl;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoTypeManagerContainer;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.building.impl.PojoTypeAdditionalMetadataProvider;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.impl.PojoEntityTypeAdditionalMetadata;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.impl.PojoIndexedTypeAdditionalMetadata;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.impl.PojoTypeAdditionalMetadata;
import org.hibernate.search.mapper.pojo.model.dependency.impl.PojoRoutingIndexingDependencyConfigurationContextImpl;
import org.hibernate.search.mapper.pojo.model.impl.PojoModelTypeRootElement;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPath;
import org.hibernate.search.mapper.pojo.model.spi.PojoBootstrapIntrospector;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.reporting.spi.PojoEventContexts;
import org.hibernate.search.mapper.pojo.search.definition.impl.PojoSearchQueryElementRegistry;
import org.hibernate.search.mapper.pojo.search.definition.impl.PojoSearchQueryElementRegistryBuilder;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class PojoMapper<MPBS extends MappingPartialBuildState>
implements Mapper<MPBS>,
IndexedEntityBindingMapperContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final ContextualFailureCollector failureCollector;
    private final TypeMetadataContributorProvider<PojoTypeMetadataContributor> contributorProvider;
    private final BeanReference<? extends IdentifierBridge<Object>> providedIdentifierBridge;
    private final IdentityMappingMode containedEntityIdentityMappingMode;
    private final TenancyMode tenancyMode;
    private final ReindexOnUpdate defaultReindexOnUpdate;
    private final FailureHandler failureHandler;
    private final ThreadPoolProvider threadPoolProvider;
    private final PojoMapperDelegate<MPBS> delegate;
    private final PojoTypeAdditionalMetadataProvider typeAdditionalMetadataProvider;
    private final ContainerExtractorBinder extractorBinder;
    private final PojoMappingHelper mappingHelper;
    private final Set<PojoRawTypeModel<?>> entityTypes = new LinkedHashSet();
    private final Set<PojoRawTypeModel<?>> indexedEntityTypes = new LinkedHashSet();
    private final Set<PojoRawTypeModel<?>> initialMappedTypes = new LinkedHashSet();
    private final Map<PojoRawTypeModel<?>, PojoIndexedTypeManagerBuilder<?>> indexedTypeManagerBuilders = new LinkedHashMap();
    private final Map<IndexedEmbeddedDefinition, IndexedEmbeddedPathTracker> pathTrackers = new LinkedHashMap<IndexedEmbeddedDefinition, IndexedEmbeddedPathTracker>();
    private PojoSearchQueryElementRegistry searchQueryElementRegistry;
    private boolean closed = false;

    public PojoMapper(MappingBuildContext buildContext, TypeMetadataContributorProvider<PojoTypeMetadataContributor> contributorProvider, PojoBootstrapIntrospector introspector, ContainerExtractorBinder extractorBinder, BridgeResolver bridgeResolver, BeanReference<? extends IdentifierBridge<Object>> providedIdentifierBridge, IdentityMappingMode containedEntityIdentityMappingMode, TenancyMode tenancyMode, ReindexOnUpdate defaultReindexOnUpdate, PojoMapperDelegate<MPBS> delegate) {
        this.failureCollector = buildContext.failureCollector();
        this.contributorProvider = contributorProvider;
        this.containedEntityIdentityMappingMode = containedEntityIdentityMappingMode;
        this.tenancyMode = tenancyMode;
        this.defaultReindexOnUpdate = defaultReindexOnUpdate;
        this.failureHandler = buildContext.failureHandler();
        this.threadPoolProvider = buildContext.threadPoolProvider();
        this.delegate = delegate;
        this.providedIdentifierBridge = providedIdentifierBridge;
        this.typeAdditionalMetadataProvider = new PojoTypeAdditionalMetadataProvider(buildContext.beanResolver(), contributorProvider);
        this.extractorBinder = extractorBinder;
        PojoIndexModelBinder indexModelBinder = new PojoIndexModelBinder(buildContext, introspector, extractorBinder, bridgeResolver, this.typeAdditionalMetadataProvider);
        this.mappingHelper = new PojoMappingHelper(buildContext.beanResolver(), (FailureCollector)this.failureCollector, contributorProvider, introspector, this.typeAdditionalMetadataProvider, indexModelBinder);
    }

    public void closeOnFailure() {
        if (!this.closed) {
            this.closed = true;
            try (Closer closer = new Closer();){
                closer.pushAll(PojoIndexedTypeManagerBuilder::closeOnFailure, this.indexedTypeManagerBuilders.values());
                closer.push(PojoMapperDelegate::closeOnFailure, this.delegate);
            }
        }
    }

    public void prepareMappedTypes(BackendsInfo backendsInfo) {
        Set encounteredTypes = this.contributorProvider.typesContributedTo();
        for (MappableTypeModel mappableTypeModel : encounteredTypes) {
            try {
                if (!(mappableTypeModel instanceof PojoRawTypeModel)) {
                    throw new AssertionFailure("Expected the mappable type model to be an instance of " + PojoRawTypeModel.class + ", got " + mappableTypeModel + " instead.");
                }
                PojoRawTypeModel rawTypeModel = (PojoRawTypeModel)mappableTypeModel;
                this.prepareEntityOrIndexedType(rawTypeModel, backendsInfo);
                this.initialMappedTypes.add(rawTypeModel);
            }
            catch (RuntimeException e) {
                this.failureCollector.withContext(EventContexts.fromType((MappableTypeModel)mappableTypeModel)).add((Throwable)e);
            }
        }
        log.detectedMappedTypes(this.entityTypes, this.indexedEntityTypes, this.initialMappedTypes);
    }

    private void prepareEntityOrIndexedType(PojoRawTypeModel<?> rawTypeModel, BackendsInfo backendsInfo) {
        PojoTypeAdditionalMetadata metadata = this.typeAdditionalMetadataProvider.get(rawTypeModel);
        if (metadata.isEntity()) {
            this.entityTypes.add(rawTypeModel);
        }
        Optional<PojoIndexedTypeAdditionalMetadata> indexedTypeMetadataOptional = metadata.getIndexedTypeMetadata();
        if (!rawTypeModel.isAbstract() && indexedTypeMetadataOptional.isPresent()) {
            if (!metadata.getEntityTypeMetadata().isPresent()) {
                throw log.missingEntityTypeMetadata(rawTypeModel);
            }
            PojoIndexedTypeAdditionalMetadata indexedTypeMetadata = indexedTypeMetadataOptional.get();
            backendsInfo.collect(indexedTypeMetadata.backendName(), this.tenancyMode);
            this.indexedEntityTypes.add(rawTypeModel);
        }
    }

    public void mapTypes(MappedIndexManagerFactory indexManagerFactory) {
        for (PojoRawTypeModel<?> indexedEntityType : this.indexedEntityTypes) {
            try {
                this.mapIndexedType(indexedEntityType, indexManagerFactory);
            }
            catch (RuntimeException e) {
                this.failureCollector.withContext(EventContexts.fromType(indexedEntityType)).add((Throwable)e);
            }
        }
        if (!this.failureCollector.hasFailure()) {
            this.checkPathTrackers();
        }
        PojoSearchQueryElementRegistryBuilder searchQueryElementRegistryBuilder = new PojoSearchQueryElementRegistryBuilder(this.mappingHelper);
        for (PojoRawTypeModel<?> type : this.initialMappedTypes) {
            try {
                this.collectSearchMapping(type, searchQueryElementRegistryBuilder.type(type));
            }
            catch (RuntimeException e) {
                this.failureCollector.withContext(EventContexts.fromType(type)).add((Throwable)e);
            }
        }
        this.searchQueryElementRegistry = searchQueryElementRegistryBuilder.build();
    }

    private <E> void mapIndexedType(PojoRawTypeModel<E> indexedEntityType, MappedIndexManagerFactory indexManagerFactory) {
        PojoTypeAdditionalMetadata metadata = this.typeAdditionalMetadataProvider.get(indexedEntityType);
        PojoEntityTypeAdditionalMetadata entityTypeMetadata = metadata.getEntityTypeMetadata().get();
        PojoIndexedTypeAdditionalMetadata indexedTypeMetadata = metadata.getIndexedTypeMetadata().get();
        String entityName = entityTypeMetadata.getEntityName();
        String indexName = indexedTypeMetadata.indexName().orElse(entityName);
        MappedIndexManagerBuilder indexManagerBuilder = indexManagerFactory.createMappedIndexManager((IndexedEntityBindingMapperContext)this, this.delegate, indexedTypeMetadata.backendName(), indexName, entityName);
        Optional<RoutingBinder> routingBinderOptional = indexedTypeMetadata.routingBinder();
        BoundRoutingBridge<E> routingBridge = null;
        if (routingBinderOptional.isPresent()) {
            PojoBootstrapIntrospector introspector = this.mappingHelper.introspector();
            PojoModelTypeRootElement<E> pojoModelRootElement = new PojoModelTypeRootElement<E>(BoundPojoModelPath.root(indexedEntityType), introspector, this.typeAdditionalMetadataProvider);
            PojoRoutingIndexingDependencyConfigurationContextImpl<E> dependencyContext = new PojoRoutingIndexingDependencyConfigurationContextImpl<E>(introspector, this.extractorBinder, this.typeAdditionalMetadataProvider, indexedEntityType);
            routingBridge = new RoutingBindingContextImpl<E>(this.mappingHelper.beanResolver(), introspector, indexedEntityType, pojoModelRootElement, dependencyContext, indexedTypeMetadata.routingBinderParams()).applyBinder(routingBinderOptional.get());
        }
        PojoIndexedTypeManagerBuilder<E> builder = new PojoIndexedTypeManagerBuilder<E>(entityName, indexedEntityType, this.mappingHelper, indexManagerBuilder, this.delegate.createIndexedTypeExtendedMappingCollector(indexedEntityType, entityName), this.providedIdentifierBridge, routingBridge, this.mappingHelper.beanResolver());
        this.indexedTypeManagerBuilders.put(indexedEntityType, builder);
        this.collectIndexMapping(indexedEntityType, builder.asCollector());
    }

    public MPBS prepareBuild() throws MappingAbortedException {
        PojoMappingDelegateImpl mappingDelegate;
        PojoTypeManagerContainer.Builder typeManagerContainerBuilder = PojoTypeManagerContainer.builder();
        PojoImplicitReindexingResolverBuildingHelper reindexingResolverBuildingHelper = new PojoImplicitReindexingResolverBuildingHelper(this.extractorBinder, this.typeAdditionalMetadataProvider, this.entityTypes, this.defaultReindexOnUpdate);
        try {
            for (PojoIndexedTypeManagerBuilder<?> pojoIndexedTypeManagerBuilder : this.indexedTypeManagerBuilders.values()) {
                pojoIndexedTypeManagerBuilder.preBuild(reindexingResolverBuildingHelper);
            }
            if (this.failureCollector.hasFailure()) {
                throw new MappingAbortedException();
            }
            for (Map.Entry entry : this.indexedTypeManagerBuilders.entrySet()) {
                PojoRawTypeModel typeModel = (PojoRawTypeModel)entry.getKey();
                PojoIndexedTypeManagerBuilder pojoIndexedTypeManagerBuilder = (PojoIndexedTypeManagerBuilder)entry.getValue();
                try {
                    pojoIndexedTypeManagerBuilder.buildAndAddTo(typeManagerContainerBuilder, reindexingResolverBuildingHelper);
                }
                catch (RuntimeException e) {
                    this.failureCollector.withContext(PojoEventContexts.fromType(typeModel)).add((Throwable)e);
                }
            }
            for (PojoRawTypeModel pojoRawTypeModel : this.entityTypes) {
                if (pojoRawTypeModel.isAbstract() || this.indexedTypeManagerBuilders.containsKey(pojoRawTypeModel)) continue;
                try {
                    this.buildAndAddContainedTypeManagerTo(typeManagerContainerBuilder, reindexingResolverBuildingHelper, pojoRawTypeModel);
                }
                catch (RuntimeException e) {
                    this.failureCollector.withContext(PojoEventContexts.fromType(pojoRawTypeModel)).add((Throwable)e);
                }
            }
            if (this.failureCollector.hasFailure()) {
                throw new MappingAbortedException();
            }
            mappingDelegate = new PojoMappingDelegateImpl(this.threadPoolProvider, this.failureHandler, this.tenancyMode, typeManagerContainerBuilder.build(), this.searchQueryElementRegistry);
        }
        catch (RuntimeException | MappingAbortedException e) {
            ((SuppressingCloser)((SuppressingCloser)new SuppressingCloser(e).push(PojoImplicitReindexingResolverBuildingHelper::closeOnFailure, (Object)reindexingResolverBuildingHelper)).push(PojoTypeManagerContainer.Builder::closeOnFailure, (Object)typeManagerContainerBuilder)).push(PojoMapperDelegate::closeOnFailure, this.delegate);
            throw e;
        }
        this.closed = true;
        try {
            return (MPBS)((MappingPartialBuildState)this.delegate.prepareBuild(mappingDelegate));
        }
        catch (RuntimeException e) {
            ((SuppressingCloser)new SuppressingCloser((Throwable)e).push(PojoMapperDelegate::closeOnFailure, this.delegate)).push((AutoCloseable)mappingDelegate);
            throw e;
        }
    }

    public IndexedEmbeddedPathTracker getOrCreatePathTracker(IndexedEmbeddedDefinition definition) {
        return this.pathTrackers.computeIfAbsent(definition, IndexedEmbeddedPathTracker::new);
    }

    private void checkPathTrackers() {
        for (Map.Entry<IndexedEmbeddedDefinition, IndexedEmbeddedPathTracker> entry : this.pathTrackers.entrySet()) {
            IndexedEmbeddedPathTracker pathTracker = entry.getValue();
            Set uselessIncludePaths = pathTracker.uselessIncludePaths();
            if (uselessIncludePaths.isEmpty()) continue;
            Set encounteredFieldPaths = pathTracker.encounteredFieldPaths();
            this.failureCollector.add((Throwable)log.uselessIncludePathFilters(uselessIncludePaths, encounteredFieldPaths, EventContexts.fromType((MappableTypeModel)entry.getKey().definingTypeModel())));
        }
    }

    private <T> void buildAndAddContainedTypeManagerTo(PojoTypeManagerContainer.Builder typeManagerContainerBuilder, PojoImplicitReindexingResolverBuildingHelper reindexingResolverBuildingHelper, PojoRawTypeModel<T> entityType) {
        PojoEntityTypeAdditionalMetadata entityTypeMetadata = this.typeAdditionalMetadataProvider.get(entityType).getEntityTypeMetadata().orElseThrow(() -> new AssertionFailure("Missing metadata for entity type '" + entityType));
        Optional<PojoImplicitReindexingResolver<T>> reindexingResolverOptional = reindexingResolverBuildingHelper.buildOptional(entityType);
        if (reindexingResolverOptional.isPresent()) {
            String entityName = entityTypeMetadata.getEntityName();
            PojoImplicitReindexingResolver<T> reindexingResolver = reindexingResolverOptional.get();
            PojoContainedTypeExtendedMappingCollector extendedMappingCollector = this.delegate.createContainedTypeExtendedMappingCollector(entityType, entityName);
            extendedMappingCollector.dirtyFilter(reindexingResolver.dirtySelfOrContainingFilter());
            extendedMappingCollector.dirtyContainingAssociationFilter(reindexingResolver.associationInverseSideResolver().dirtyContainingAssociationFilter());
            PojoRootIdentityMappingCollector<T> identityMappingCollector = new PojoRootIdentityMappingCollector<T>(entityType, this.mappingHelper, Optional.empty(), this.providedIdentifierBridge, this.mappingHelper.beanResolver());
            this.collectIndexMapping(entityType, identityMappingCollector.toMappingCollectorRootNode());
            IdentifierMappingImplementor<?, T> identifierMapping = identityMappingCollector.buildAndContributeTo(extendedMappingCollector, this.containedEntityIdentityMappingMode);
            PojoContainedTypeManager typeManager = new PojoContainedTypeManager(entityName, entityType.typeIdentifier(), entityType.caster(), reindexingResolverBuildingHelper.isSingleConcreteTypeInEntityHierarchy(entityType), identifierMapping, reindexingResolverBuildingHelper.runtimePathsBuildingHelper(entityType).pathOrdinals(), reindexingResolver);
            log.containedTypeManager(entityType, typeManager);
            typeManagerContainerBuilder.addContained(typeManager);
        }
    }

    private <T> void collectIndexMapping(PojoRawTypeModel<T> type, PojoIndexMappingCollectorTypeNode collector) {
        for (PojoTypeMetadataContributor contributor : this.contributorProvider.get(type)) {
            contributor.contributeIndexMapping(collector);
        }
    }

    private <T> void collectSearchMapping(PojoRawTypeModel<T> type, PojoSearchMappingCollectorTypeNode collector) {
        for (PojoTypeMetadataContributor contributor : this.contributorProvider.get(type)) {
            contributor.contributeSearchMapping(collector);
        }
    }
}

