/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.mapping.impl;

import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.search.mapper.orm.event.impl.HibernateOrmListenerTypeContext;
import org.hibernate.search.mapper.orm.loading.spi.HibernateOrmEntityLoadingStrategy;
import org.hibernate.search.mapper.orm.loading.spi.HibernateOrmLoadingTypeContext;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmEntityLoadingBinder;
import org.hibernate.search.mapper.orm.model.impl.DocumentIdSourceProperty;
import org.hibernate.search.mapper.orm.session.impl.HibernateOrmSessionTypeContext;
import org.hibernate.search.mapper.pojo.loading.definition.spi.PojoEntityLoadingBindingContext;
import org.hibernate.search.mapper.pojo.loading.spi.PojoLoadingTypeContext;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoTypeExtendedMappingCollector;
import org.hibernate.search.mapper.pojo.model.path.spi.PojoPathFilter;
import org.hibernate.search.mapper.pojo.model.spi.PojoPropertyModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeContext;

abstract class AbstractHibernateOrmTypeContext<E>
implements PojoTypeContext<E>,
HibernateOrmListenerTypeContext,
HibernateOrmSessionTypeContext<E>,
HibernateOrmLoadingTypeContext<E> {
    private final PojoRawTypeIdentifier<E> typeIdentifier;
    private final PojoLoadingTypeContext<E> delegate;
    private final String jpaEntityName;
    private final EntityMappingType entityMappingType;
    private final boolean documentIdIsEntityId;
    private final HibernateOrmEntityLoadingStrategy<? super E, ?> loadingStrategy;
    private final PojoPathFilter dirtyFilter;
    private final PojoPathFilter dirtyContainingAssociationFilter;

    AbstractHibernateOrmTypeContext(Builder<E> builder, PojoLoadingTypeContext<E> delegate, SessionFactoryImplementor sessionFactory) {
        this.typeIdentifier = builder.typeIdentifier;
        this.delegate = delegate;
        this.jpaEntityName = builder.jpaEntityName;
        MappingMetamodelImplementor metamodel = sessionFactory.getMappingMetamodel();
        this.entityMappingType = metamodel.getEntityDescriptor(builder.hibernateOrmEntityName);
        this.documentIdIsEntityId = builder.documentIdSourceProperty != null && builder.documentIdSourceProperty.name.equals(this.entityMappingType.getIdentifierMapping().getAttributeName());
        this.loadingStrategy = builder.loadingStrategy;
        this.dirtyFilter = builder.dirtyFilter;
        this.dirtyContainingAssociationFilter = builder.dirtyContainingAssociationFilter;
    }

    public String toString() {
        return this.typeIdentifier().toString();
    }

    @Override
    public PojoRawTypeIdentifier<E> typeIdentifier() {
        return this.typeIdentifier;
    }

    @Override
    public PojoLoadingTypeContext<E> delegate() {
        return this.delegate;
    }

    @Override
    public String jpaEntityName() {
        return this.jpaEntityName;
    }

    public String hibernateOrmEntityName() {
        return this.entityMappingType.getEntityName();
    }

    @Override
    public EntityMappingType entityMappingType() {
        return this.entityMappingType;
    }

    @Override
    public HibernateOrmEntityLoadingStrategy<? super E, ?> loadingStrategy() {
        return this.loadingStrategy;
    }

    @Override
    public Object toIndexingPlanProvidedId(Object entityId) {
        if (this.documentIdIsEntityId) {
            return entityId;
        }
        return null;
    }

    @Override
    public PojoPathFilter dirtyFilter() {
        return this.dirtyFilter;
    }

    @Override
    public PojoPathFilter dirtyContainingAssociationFilter() {
        return this.dirtyContainingAssociationFilter;
    }

    public static abstract class Builder<E>
    implements PojoTypeExtendedMappingCollector {
        public final PojoRawTypeIdentifier<E> typeIdentifier;
        private final PersistentClass persistentClass;
        private final String jpaEntityName;
        private final String hibernateOrmEntityName;
        private DocumentIdSourceProperty<?> documentIdSourceProperty;
        private PojoPathFilter dirtyFilter;
        private PojoPathFilter dirtyContainingAssociationFilter;
        private HibernateOrmEntityLoadingStrategy<? super E, ?> loadingStrategy;

        Builder(PojoRawTypeModel<E> typeModel, PersistentClass persistentClass) {
            this.typeIdentifier = typeModel.typeIdentifier();
            this.persistentClass = persistentClass;
            this.jpaEntityName = persistentClass.getJpaEntityName();
            this.hibernateOrmEntityName = persistentClass.getEntityName();
        }

        public void documentIdSourceProperty(PojoPropertyModel<?> documentIdSourceProperty) {
            this.documentIdSourceProperty = new DocumentIdSourceProperty(documentIdSourceProperty);
        }

        public void dirtyFilter(PojoPathFilter dirtyFilter) {
            this.dirtyFilter = dirtyFilter;
        }

        public void dirtyContainingAssociationFilter(PojoPathFilter filter) {
            this.dirtyContainingAssociationFilter = filter;
        }

        public void applyLoadingBinder(Object binder, PojoEntityLoadingBindingContext context) {
            HibernateOrmEntityLoadingBinder castBinder = (HibernateOrmEntityLoadingBinder)binder;
            this.loadingStrategy = castBinder.createLoadingStrategy(this.persistentClass, this.documentIdSourceProperty);
            if (this.loadingStrategy != null) {
                context.selectionLoadingStrategy(this.typeIdentifier.javaClass(), this.loadingStrategy);
                context.massLoadingStrategy(this.typeIdentifier.javaClass(), this.loadingStrategy);
            }
        }
    }
}

