/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.logging.impl;

import jakarta.transaction.Synchronization;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.hibernate.ScrollMode;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.mapping.Value;
import org.hibernate.resource.beans.container.spi.BeanContainer;
import org.hibernate.search.engine.environment.bean.spi.BeanNotFoundException;
import org.hibernate.search.mapper.orm.logging.impl.ConfigurationLog;
import org.hibernate.search.mapper.orm.logging.impl.DeprecationLog;
import org.hibernate.search.mapper.orm.logging.impl.IndexingLog;
import org.hibernate.search.mapper.orm.logging.impl.LoadingLog;
import org.hibernate.search.mapper.orm.logging.impl.MappingLog;
import org.hibernate.search.mapper.orm.logging.impl.OrmLog;
import org.hibernate.search.mapper.orm.logging.impl.OrmMiscLog;
import org.hibernate.search.mapper.orm.logging.impl.VersionLog;
import org.hibernate.search.mapper.orm.search.loading.EntityLoadingCacheLookupStrategy;
import org.hibernate.search.mapper.pojo.logging.spi.PojoModelPathFormatter;
import org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPath;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.hibernate.search.util.common.logging.impl.CommaSeparatedClassesFormatter;
import org.hibernate.search.util.common.logging.impl.EventContextFormatter;
import org.hibernate.search.util.common.reporting.EventContext;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class OrmLog_$logger
extends DelegatingBasicLogger
implements OrmLog,
ConfigurationLog,
DeprecationLog,
IndexingLog,
LoadingLog,
BasicLogger,
MappingLog,
OrmMiscLog,
VersionLog,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = OrmLog_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public OrmLog_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void nextLoggerIdForConvenience() {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.nextLoggerIdForConvenience$str(), new Object[0]);
    }

    protected String nextLoggerIdForConvenience$str() {
        return "HSEARCH800143: ";
    }

    protected String hibernateSearchNotInitialized$str() {
        return "HSEARCH800001: Hibernate Search was not initialized.";
    }

    @Override
    public final SearchException hibernateSearchNotInitialized() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.hibernateSearchNotInitialized$str(), new Object[0]));
        OrmLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) {
            e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        }
    }

    protected String invalidAutomaticIndexingStrategyName$str() {
        return "HSEARCH800003: Invalid automatic indexing strategy name: '%1$s'. Valid names are: %2$s.";
    }

    @Override
    public final SearchException invalidAutomaticIndexingStrategyName(String invalidRepresentation, List<String> validRepresentations) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidAutomaticIndexingStrategyName$str(), invalidRepresentation, validRepresentations));
        OrmLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidEntityLoadingCacheLookupStrategyName$str() {
        return "HSEARCH800018: Invalid entity loading cache lookup strategy name: '%1$s'. Valid names are: %2$s.";
    }

    @Override
    public final SearchException invalidEntityLoadingCacheLookupStrategyName(String invalidRepresentation, List<String> validRepresentations) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidEntityLoadingCacheLookupStrategyName$str(), invalidRepresentation, validRepresentations));
        OrmLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidSchemaManagementStrategyName$str() {
        return "HSEARCH800032: Invalid schema management strategy name: '%1$s'. Valid names are: %2$s.";
    }

    @Override
    public final SearchException invalidSchemaManagementStrategyName(String invalidRepresentation, List<String> validRepresentations) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidSchemaManagementStrategyName$str(), invalidRepresentation, validRepresentations));
        OrmLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String beanNotFoundInBeanContainer$str() {
        return "HSEARCH800041: No such bean in bean container '%1$s'.";
    }

    @Override
    public final BeanNotFoundException beanNotFoundInBeanContainer(BeanContainer beanContainer) {
        BeanNotFoundException result = new BeanNotFoundException(String.format(this.getLoggingLocale(), this.beanNotFoundInBeanContainer$str(), beanContainer));
        OrmLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotConfigureSynchronizationStrategyWithIndexingEventQueue$str() {
        return "HSEARCH800042: Cannot customize the indexing plan synchronization strategy:  the selected coordination strategy always processes events asynchronously, through a queue.";
    }

    @Override
    public final SearchException cannotConfigureSynchronizationStrategyWithIndexingEventQueue() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotConfigureSynchronizationStrategyWithIndexingEventQueue$str(), new Object[0]));
        OrmLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String missingTenantIdConfiguration$str() {
        return "HSEARCH800054: Cannot determine the set of all possible tenant identifiers. You must provide this information by setting configuration property '%1$s' to a comma-separated string containing all possible tenant identifiers.";
    }

    @Override
    public final SearchException missingTenantIdConfiguration(String tenantIdsConfigurationPropertyKey) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.missingTenantIdConfiguration$str(), tenantIdsConfigurationPropertyKey));
        OrmLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidTenantId$str() {
        return "HSEARCH800055: Cannot target tenant '%1$s' because this tenant identifier was not listed in the configuration provided on startup. To target this tenant, you must provide the tenant identifier through configuration property '%3$s', which should be set to a comma-separated string containing all possible tenant identifiers. Currently configured tenant identifiers: %2$s.";
    }

    @Override
    public final SearchException invalidTenantId(String tenantId, Set<String> allTenantIds, String tenantIdsConfigurationPropertyKey) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidTenantId$str(), tenantId, allTenantIds, tenantIdsConfigurationPropertyKey));
        OrmLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotApplySessionFilterWhenAsyncProcessingIsUsed$str() {
        return "HSEARCH800124: Unable to apply the given filter at the session level with the outbox polling coordination strategy. With this coordination strategy, applying a session-level indexing plan filter is only allowed if it excludes all types.";
    }

    @Override
    public final SearchException cannotApplySessionFilterWhenAsyncProcessingIsUsed() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotApplySessionFilterWhenAsyncProcessingIsUsed$str(), new Object[0]));
        OrmLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void errorResolvingBean(Class<?> typeReference, Exception e) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)e, this.errorResolvingBean$str(), typeReference);
    }

    protected String errorResolvingBean$str() {
        return "HSEARCH800138: Error resolving bean of type [%s] - using fallback";
    }

    @Override
    public final void hibernateSearchDisabled() {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.hibernateSearchDisabled$str(), new Object[0]);
    }

    protected String hibernateSearchDisabled$str() {
        return "HSEARCH800139: Hibernate Search is disabled through configuration properties.";
    }

    @Override
    public final void dirtyChecksEnabled(boolean dirtyCheckingEnabled) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.dirtyChecksEnabled$str(), (Object)dirtyCheckingEnabled);
    }

    protected String dirtyChecksEnabled$str() {
        return "HSEARCH800140: Hibernate Search dirty checks: %s";
    }

    @Override
    public final void hibernateSearchListenerEnabled() {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.hibernateSearchListenerEnabled$str(), new Object[0]);
    }

    protected String hibernateSearchListenerEnabled$str() {
        return "HSEARCH800141: Hibernate Search event listeners activated";
    }

    @Override
    public final void hibernateSearchListenerDisabled() {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.hibernateSearchListenerDisabled$str(), new Object[0]);
    }

    protected String hibernateSearchListenerDisabled$str() {
        return "HSEARCH800142: Hibernate Search event listeners deactivated";
    }

    @Override
    public final void deprecatedPropertyUsedInsteadOfNew(String resolveOrRaw, String resolveOrRaw1) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.deprecatedPropertyUsedInsteadOfNew$str(), (Object)resolveOrRaw, (Object)resolveOrRaw1);
    }

    protected String deprecatedPropertyUsedInsteadOfNew$str() {
        return "HSEARCH800053: Configuration property '%1$s' is deprecated; use '%2$s' instead.";
    }

    protected String bothNewAndOldConfigurationPropertiesForIndexingPlanSyncAreUsed$str() {
        return "HSEARCH800122: Both '%1$s' and '%2$s' are configured. Use only '%1$s' to set the indexing plan synchronization strategy. ";
    }

    @Override
    public final SearchException bothNewAndOldConfigurationPropertiesForIndexingPlanSyncAreUsed(String key1, String key2) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.bothNewAndOldConfigurationPropertiesForIndexingPlanSyncAreUsed$str(), key1, key2));
        OrmLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void automaticIndexingSynchronizationStrategyIsDeprecated(String deprecatedProperty, String newProperty) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.automaticIndexingSynchronizationStrategyIsDeprecated$str(), (Object)deprecatedProperty, (Object)newProperty);
    }

    protected String automaticIndexingSynchronizationStrategyIsDeprecated$str() {
        return "HSEARCH800123: Configuration property '%1$s' is deprecated; use '%2$s' instead.";
    }

    @Override
    public final void automaticIndexingEnableDirtyCheckIsDeprecated(String deprecatedProperty) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.automaticIndexingEnableDirtyCheckIsDeprecated$str(), (Object)deprecatedProperty);
    }

    protected String automaticIndexingEnableDirtyCheckIsDeprecated$str() {
        return "HSEARCH800125: Configuration property '%1$s' is deprecated. This setting will be removed in a future version. There will be no alternative provided to replace it. After the removal of this property in a future version, a dirty check will always be performed when considering whether to trigger reindexing.";
    }

    protected String bothNewAndOldConfigurationPropertiesForIndexingListenersAreUsed$str() {
        return "HSEARCH800126: Both '%1$s' and '%2$s' are configured. Use only '%2$s' to enable indexing listeners. ";
    }

    @Override
    public final SearchException bothNewAndOldConfigurationPropertiesForIndexingListenersAreUsed(String key1, String key2) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.bothNewAndOldConfigurationPropertiesForIndexingListenersAreUsed$str(), key1, key2));
        OrmLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String indexingFailure$str() {
        return "HSEARCH800022: Indexing failure: %1$s.\nThe following entities may not have been updated correctly in the index: %2$s.";
    }

    @Override
    public final SearchException indexingFailure(String causeMessage, List<?> failingEntities, Throwable cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.indexingFailure$str(), causeMessage, failingEntities), cause);
        OrmLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void beforeCompletion(Transaction transactionIdentifier) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.beforeCompletion$str(), (Object)transactionIdentifier);
    }

    protected String beforeCompletion$str() {
        return "HSEARCH800135: Processing Transaction's beforeCompletion() phase for %s.";
    }

    @Override
    public final void afterCompletionExecuting(Transaction transactionIdentifier) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.afterCompletionExecuting$str(), (Object)transactionIdentifier);
    }

    protected String afterCompletionExecuting$str() {
        return "HSEARCH800136: Processing Transaction's afterCompletion() phase for %s. Executing indexing plan.";
    }

    @Override
    public final void afterCompletionCanceling(Transaction transactionIdentifier, int status) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.afterCompletionCanceling$str(), (Object)transactionIdentifier, (Object)status);
    }

    protected String afterCompletionCanceling$str() {
        return "HSEARCH800137: Processing Transaction's afterCompletion() phase for %s. Cancelling indexing plan due to transaction status %d";
    }

    protected String foundMultipleEntitiesForDocumentId$str() {
        return "HSEARCH800040: Multiple instances of entity type '%1$s' have their property '%2$s' set to '%3$s'. '%2$s' is the document ID and must be assigned unique values.";
    }

    @Override
    public final SearchException foundMultipleEntitiesForDocumentId(String entityName, String documentIdSourcePropertyName, Object id) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.foundMultipleEntitiesForDocumentId$str(), entityName, documentIdSourcePropertyName, id));
        OrmLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void numberOfKeysToFetch(long totalCount) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.numberOfKeysToFetch$str(), (Object)totalCount);
    }

    protected String numberOfKeysToFetch$str() {
        return "HSEARCH800134: Going to fetch %d primary keys";
    }

    protected String unknownPathForDirtyChecking$str() {
        return "HSEARCH800007: Unable to resolve path '%1$s' to a persisted attribute in Hibernate ORM metadata. If this path points to a transient attribute, use @IndexingDependency(derivedFrom = ...) to specify which persisted attributes it is derived from. See the reference documentation for more information.";
    }

    @Override
    public final SearchException unknownPathForDirtyChecking(PojoModelPath path, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownPathForDirtyChecking$str(), new PojoModelPathFormatter(path)), (Throwable)e);
        OrmLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unreportedPathForDirtyChecking$str() {
        return "HSEARCH800008: Path '%1$s' points to attribute '%2$s' that will never be reported as dirty by Hibernate ORM. Check that you didn't declare an invalid indexing dependency.";
    }

    @Override
    public final SearchException unreportedPathForDirtyChecking(PojoModelPath path, Value value) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unreportedPathForDirtyChecking$str(), new PojoModelPathFormatter(path), value));
        OrmLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidContainerExtractorForDirtyChecking$str() {
        return "HSEARCH800009: Unable to apply container value extractor with name '%2$s' to Hibernate ORM metadata node of type '%1$s'.";
    }

    @Override
    public final SearchException invalidContainerExtractorForDirtyChecking(Class<?> ormMappingClass, String extractorName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidContainerExtractorForDirtyChecking$str(), ormMappingClass, extractorName));
        OrmLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String errorRetrievingPropertyTypeModel$str() {
        return "HSEARCH800012: Unable to retrieve property type model for '%1$s' on '%2$s': %3$s";
    }

    @Override
    public final SearchException errorRetrievingPropertyTypeModel(String propertyModelName, PojoRawTypeModel<?> parentTypeModel, String causeMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.errorRetrievingPropertyTypeModel$str(), propertyModelName, new PojoTypeModelFormatter(parentTypeModel), causeMessage), (Throwable)cause);
        OrmLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unknownNamedType$str() {
        return "HSEARCH800027: Unknown type: '%1$s'. Available named types: %2$s. For entity types, the correct type name is the entity name. For component types (embeddeds, ...) in dynamic-map entities, the correct type name is name of the owner entity followed by a dot ('.') followed by the dot-separated path to the component, e.g. 'MyEntity.myEmbedded' or 'MyEntity.myEmbedded.myNestedEmbedded'.";
    }

    @Override
    public final SearchException unknownNamedType(String typeName, Collection<String> availableNamedTypes) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownNamedType$str(), typeName, availableNamedTypes));
        OrmLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unknownClassForIndexedEntityType$str() {
        return "HSEARCH800033: No matching indexed entity type for class '%1$s'. Either this class is not an entity type, or the entity type is not indexed in Hibernate Search. Valid classes for indexed entity types are: %2$s";
    }

    @Override
    public final SearchException unknownClassForIndexedEntityType(Class<?> invalidClass, Collection<Class<?>> validClasses) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownClassForIndexedEntityType$str(), new ClassFormatter(invalidClass), new CommaSeparatedClassesFormatter(validClasses)));
        OrmLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unknownEntityNameForIndexedEntityType$str() {
        return "HSEARCH800034: No matching indexed entity type for name '%1$s'. Either this is not the name of an entity type, or the entity type is not indexed in Hibernate Search. Valid names for indexed entity types are: %2$s";
    }

    @Override
    public final SearchException unknownEntityNameForIndexedEntityType(String invalidName, Collection<String> validNames) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownEntityNameForIndexedEntityType$str(), invalidName, validNames));
        OrmLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unknownTypeIdentifierForIndexedEntityType$str() {
        return "HSEARCH800059: No matching indexed entity type for type identifier '%1$s'. Either this type is not an entity type, or the entity type is not indexed in Hibernate Search. Valid identifiers for indexed entity types are: %2$s";
    }

    @Override
    public final SearchException unknownTypeIdentifierForIndexedEntityType(PojoRawTypeIdentifier<?> invalidTypeId, Collection<PojoRawTypeIdentifier<?>> validTypeIds) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownTypeIdentifierForIndexedEntityType$str(), invalidTypeId, validTypeIds));
        OrmLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unknownClassForMappedEntityType$str() {
        return "HSEARCH800060: No matching entity type for class '%1$s'. Either this class is not an entity type, or the entity type is not mapped in Hibernate Search. Valid classes for mapped entity types are: %2$s";
    }

    @Override
    public final SearchException unknownClassForMappedEntityType(Class<?> invalidClass, Collection<Class<?>> validClasses) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownClassForMappedEntityType$str(), new ClassFormatter(invalidClass), new CommaSeparatedClassesFormatter(validClasses)));
        OrmLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unknownEntityNameForMappedEntityType$str() {
        return "HSEARCH800061: No matching entity type for name '%1$s'. Either this is not the name of an entity type, or the entity type is not mapped in Hibernate Search. Valid names for mapped entity types are: %2$s";
    }

    @Override
    public final SearchException unknownEntityNameForMappedEntityType(String invalidName, Collection<String> validNames) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownEntityNameForMappedEntityType$str(), invalidName, validNames));
        OrmLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unknownHibernateOrmEntityNameForMappedEntityType$str() {
        return "HSEARCH800064: No matching entity type for name '%1$s'. Either this is not the Hibernate ORM name of an entity type, or the entity type is not mapped in Hibernate Search. Valid Hibernate ORM names for mapped entities are: %2$s";
    }

    @Override
    public final SearchException unknownHibernateOrmEntityNameForMappedEntityType(String invalidName, Collection<String> validNames) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownHibernateOrmEntityNameForMappedEntityType$str(), invalidName, validNames));
        OrmLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String failedToResolveStateRepresentation$str() {
        return "HSEARCH800121: An unexpected failure occurred while resolving the representation of path '%1$s' in the entity state array, which is necessary to configure resolution of association inverse side for reindexing. Cannot proceed further as this may lead to incomplete reindexing and thus out-of-sync indexes. Failure: %3$s %2$s";
    }

    @Override
    public final SearchException failedToResolveStateRepresentation(String path, EventContext context, String causeMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.failedToResolveStateRepresentation$str(), path, new EventContextFormatter(context), causeMessage), (Throwable)cause);
        OrmLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void cannotGuessTransactionStatus(Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.cannotGuessTransactionStatus$str(), new Object[0]);
    }

    protected String cannotGuessTransactionStatus$str() {
        return "HSEARCH000036: Unable to guess the transaction status: not starting a JTA transaction.";
    }

    @Override
    public final void unableToCloseSearcherInScrollableResult(Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.unableToCloseSearcherInScrollableResult$str(), new Object[0]);
    }

    protected String unableToCloseSearcherInScrollableResult$str() {
        return "HSEARCH000039: Unable to properly close scroll in ScrollableResults.";
    }

    protected String transactionNotActiveWhileProducingIdsForBatchIndexing$str() {
        return "HSEARCH000276: No transaction active. Consider increasing the connection time-out.";
    }

    @Override
    public final SearchException transactionNotActiveWhileProducingIdsForBatchIndexing() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.transactionNotActiveWhileProducingIdsForBatchIndexing$str(), new Object[0]));
        OrmLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String usingDifferentSessionFactories$str() {
        return "HSEARCH800011: Unable to create a SearchSession for sessions created using a different session factory. Expected: '%1$s'. In use: '%2$s'.";
    }

    @Override
    public final SearchException usingDifferentSessionFactories(SessionFactory expectedSessionFactory, SessionFactory usedSessionFactory) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.usingDifferentSessionFactories$str(), expectedSessionFactory, usedSessionFactory));
        OrmLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String hibernateSessionAccessError$str() {
        return "HSEARCH800016: Unable to access Hibernate ORM session: %1$s";
    }

    @Override
    public final SearchException hibernateSessionAccessError(String causeMessage, IllegalStateException cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.hibernateSessionAccessError$str(), causeMessage), (Throwable)cause);
        OrmLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String hibernateSessionIsClosed$str() {
        return "HSEARCH800017: Underlying Hibernate ORM Session is closed.";
    }

    @Override
    public final SearchException hibernateSessionIsClosed(IllegalStateException cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.hibernateSessionIsClosed$str(), new Object[0]), (Throwable)cause);
        OrmLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void skippingPreliminaryCacheLookupsForNonEntityIdEntityLoader(String entityName, EntityLoadingCacheLookupStrategy cacheLookupStrategy) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.skippingPreliminaryCacheLookupsForNonEntityIdEntityLoader$str(), (Object)entityName, (Object)cacheLookupStrategy);
    }

    protected String skippingPreliminaryCacheLookupsForNonEntityIdEntityLoader$str() {
        return "HSEARCH800019: The entity loader for '%1$s' is ignoring the cache lookup strategy '%2$s', because document IDs are distinct from entity IDs and thus cannot be used for persistence context or second level cache lookups.";
    }

    @Override
    public final void skippingSecondLevelCacheLookupsForNonCachedEntityTypeEntityLoader(String entityName) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.skippingSecondLevelCacheLookupsForNonCachedEntityTypeEntityLoader$str(), (Object)entityName);
    }

    protected String skippingSecondLevelCacheLookupsForNonCachedEntityTypeEntityLoader$str() {
        return "HSEARCH800020: The entity loader for '%1$s' is ignoring the second-level cache even though it was instructed to use it, because caching is not enabled for this entity type.";
    }

    protected String hibernateSessionFactoryAccessError$str() {
        return "HSEARCH800021: Unable to access Hibernate ORM session factory: %1$s";
    }

    @Override
    public final SearchException hibernateSessionFactoryAccessError(String causeMessage, IllegalStateException cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.hibernateSessionFactoryAccessError$str(), causeMessage), (Throwable)cause);
        OrmLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String synchronizationBeforeTransactionFailure$str() {
        return "HSEARCH800023: Unable to process entities for indexing before transaction completion: %1$s";
    }

    @Override
    public final SearchException synchronizationBeforeTransactionFailure(String causeMessage, Throwable cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.synchronizationBeforeTransactionFailure$str(), causeMessage), cause);
        OrmLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String synchronizationAfterTransactionFailure$str() {
        return "HSEARCH800024: Unable to index documents for indexing after transaction completion: %1$s";
    }

    @Override
    public final SearchException synchronizationAfterTransactionFailure(String causeMessage, Throwable cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.synchronizationAfterTransactionFailure$str(), causeMessage), cause);
        OrmLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String transactionHandlingException$str() {
        return "HSEARCH800025: Unable to handle transaction: %1$s";
    }

    @Override
    public final SearchException transactionHandlingException(String causeMessage, Throwable cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.transactionHandlingException$str(), causeMessage), cause);
        OrmLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void shutdownFailed(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.shutdownFailed$str(), new Object[0]);
    }

    protected String shutdownFailed$str() {
        return "HSEARCH800035: Unable to shut down Hibernate Search:";
    }

    protected String canOnlyUseScrollWithScrollModeForwardsOnly$str() {
        return "HSEARCH800036: Cannot use scroll() with scroll mode '%1$s' with Hibernate Search queries: only ScrollMode.FORWARDS_ONLY is supported.";
    }

    @Override
    public final SearchException canOnlyUseScrollWithScrollModeForwardsOnly(ScrollMode scrollMode) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.canOnlyUseScrollWithScrollModeForwardsOnly$str(), scrollMode));
        OrmLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotScrollBackwards$str() {
        return "HSEARCH800037: Cannot scroll backwards with Hibernate Search scrolls: they are forwards-only. Ensure you always increment the scroll position, and never decrement it.";
    }

    @Override
    public final SearchException cannotScrollBackwards() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotScrollBackwards$str(), new Object[0]));
        OrmLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotSetScrollPositionRelativeToEnd$str() {
        return "HSEARCH800038: Cannot set the scroll position relative to the end with Hibernate Search scrolls. Ensure you always pass a positive number to setRowNumber().";
    }

    @Override
    public final SearchException cannotSetScrollPositionRelativeToEnd() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotSetScrollPositionRelativeToEnd$str(), new Object[0]));
        OrmLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotUseClosedScrollableResults$str() {
        return "HSEARCH800039: Cannot use this ScrollableResults instance: it is closed.";
    }

    @Override
    public final SearchException cannotUseClosedScrollableResults() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotUseClosedScrollableResults$str(), new Object[0]));
        OrmLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void ignoringUnrecognizedQueryHint(String hintName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.ignoringUnrecognizedQueryHint$str(), (Object)hintName);
    }

    protected String ignoringUnrecognizedQueryHint$str() {
        return "HSEARCH800056: Ignoring unrecognized query hint [%s]";
    }

    protected String cannotSetFetchSize$str() {
        return "HSEARCH800057: Cannot set the fetch size of Hibernate Search ScrollableResults after having created them. If you want to define the size of batches for entity loading, set loading options when defining the query instead, for example with .loading(o -> o.fetchSize(50)). See the reference documentation for more information.";
    }

    @Override
    public final SearchException cannotSetFetchSize() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotSetFetchSize$str(), new Object[0]));
        OrmLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void transactionManagerNotRequired() {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.transactionManagerNotRequired$str(), new Object[0]);
    }

    protected String transactionManagerNotRequired$str() {
        return "HSEARCH800127: TransactionFactory does not require a TransactionManager: don't wrap in a JTA transaction";
    }

    @Override
    public final void transactionManagerNotFound() {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.transactionManagerNotFound$str(), new Object[0]);
    }

    protected String transactionManagerNotFound$str() {
        return "HSEARCH800128: No TransactionManager found, do not start a surrounding JTA transaction";
    }

    @Override
    public final void noInProgressTransaction() {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.noInProgressTransaction$str(), new Object[0]);
    }

    protected String noInProgressTransaction$str() {
        return "HSEARCH800129: No Transaction in progress, needs to start a JTA transaction";
    }

    @Override
    public final void transactionAlreadyInProgress() {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.transactionAlreadyInProgress$str(), new Object[0]);
    }

    protected String transactionAlreadyInProgress$str() {
        return "HSEARCH800130: Transaction in progress, no need to start a JTA transaction";
    }

    @Override
    public final void syncAdapterIgnoringAfterCompletion(Synchronization delegate) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.syncAdapterIgnoringAfterCompletion$str(), (Object)delegate);
    }

    protected String syncAdapterIgnoringAfterCompletion$str() {
        return "HSEARCH800131: Transaction's afterCompletion is expected to be executed through the AfterTransactionCompletionProcess interface, ignoring: %s";
    }

    @Override
    public final void syncAdapterIgnoringBeforeCompletionAlreadyExecuted(Synchronization delegate) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.syncAdapterIgnoringBeforeCompletionAlreadyExecuted$str(), (Object)delegate);
    }

    protected String syncAdapterIgnoringBeforeCompletionAlreadyExecuted$str() {
        return "HSEARCH800132: Transaction's beforeCompletion() phase already been processed, ignoring: %s";
    }

    @Override
    public final void syncAdapterIgnoringAfterCompletionAlreadyExecuted(Synchronization delegate) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.syncAdapterIgnoringAfterCompletionAlreadyExecuted$str(), (Object)delegate);
    }

    protected String syncAdapterIgnoringAfterCompletionAlreadyExecuted$str() {
        return "HSEARCH800133: Transaction's afterCompletion() phase already been processed, ignoring: %s";
    }

    @Override
    public final void version(String versionString) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.version$str(), (Object)versionString);
    }

    protected String version$str() {
        return "HSEARCH000034: Hibernate Search version %1$s";
    }
}

