/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.session.impl;

import jakarta.persistence.EntityManager;
import java.util.Collection;
import java.util.function.Supplier;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.search.engine.search.query.dsl.SearchQuerySelectStep;
import org.hibernate.search.mapper.orm.automaticindexing.session.AutomaticIndexingSynchronizationStrategy;
import org.hibernate.search.mapper.orm.common.EntityReference;
import org.hibernate.search.mapper.orm.common.impl.HibernateOrmUtils;
import org.hibernate.search.mapper.orm.massindexing.MassIndexer;
import org.hibernate.search.mapper.orm.schema.management.SearchSchemaManager;
import org.hibernate.search.mapper.orm.scope.HibernateOrmRootReferenceScope;
import org.hibernate.search.mapper.orm.scope.SearchScope;
import org.hibernate.search.mapper.orm.search.loading.dsl.SearchLoadingOptionsStep;
import org.hibernate.search.mapper.orm.session.SearchSession;
import org.hibernate.search.mapper.orm.session.impl.HibernateOrmSearchSession;
import org.hibernate.search.mapper.orm.session.impl.HibernateOrmSearchSessionMappingContext;
import org.hibernate.search.mapper.orm.work.SearchIndexingPlan;
import org.hibernate.search.mapper.orm.work.SearchWorkspace;
import org.hibernate.search.mapper.pojo.work.IndexingPlanSynchronizationStrategy;
import org.hibernate.search.mapper.pojo.work.SearchIndexingPlanFilter;

public class DelegatingSearchSession
implements SearchSession {
    private final Supplier<? extends HibernateOrmSearchSessionMappingContext> mappingContextProvider;
    private final Session session;

    public DelegatingSearchSession(Supplier<? extends HibernateOrmSearchSessionMappingContext> mappingContextProvider, Session session) {
        this.mappingContextProvider = mappingContextProvider;
        this.session = session;
    }

    @Override
    public <T> SearchQuerySelectStep<T, ?, EntityReference, T, SearchLoadingOptionsStep, ?, ?> search(Collection<? extends Class<? extends T>> classes) {
        return this.getDelegate().search(classes);
    }

    @Override
    public <SR, T> SearchQuerySelectStep<SR, ?, EntityReference, T, SearchLoadingOptionsStep, ?, ?> search(SearchScope<SR, T> scope) {
        return this.getDelegate().search(scope);
    }

    @Override
    public <SR, T> SearchQuerySelectStep<SR, ?, EntityReference, T, SearchLoadingOptionsStep, ?, ?> search(HibernateOrmRootReferenceScope<SR, T> scope) {
        return this.getDelegate().search(scope);
    }

    @Override
    public SearchSchemaManager schemaManager(Collection<? extends Class<?>> classes) {
        return this.getDelegate().schemaManager(classes);
    }

    @Override
    public SearchWorkspace workspace(Collection<? extends Class<?>> classes) {
        return this.getDelegate().workspace(classes);
    }

    @Override
    public MassIndexer massIndexer(Collection<? extends Class<?>> classes) {
        return this.getDelegate().massIndexer(classes);
    }

    @Override
    public <SR, T> SearchScope<SR, T> scope(Collection<? extends Class<? extends T>> classes) {
        return this.getDelegate().scope((Collection)classes);
    }

    @Override
    public <SR, T> SearchScope<SR, T> scope(Class<T> expectedSuperType, Collection<String> entityNames) {
        return this.getDelegate().scope(expectedSuperType, entityNames);
    }

    @Override
    public EntityManager toEntityManager() {
        return this.session;
    }

    @Override
    public Session toOrmSession() {
        return this.session;
    }

    @Override
    public SearchIndexingPlan indexingPlan() {
        return this.getDelegate().indexingPlan();
    }

    @Override
    public void automaticIndexingSynchronizationStrategy(AutomaticIndexingSynchronizationStrategy synchronizationStrategy) {
        this.getDelegate().automaticIndexingSynchronizationStrategy(synchronizationStrategy);
    }

    @Override
    public void indexingPlanSynchronizationStrategy(IndexingPlanSynchronizationStrategy synchronizationStrategy) {
        this.getDelegate().indexingPlanSynchronizationStrategy(synchronizationStrategy);
    }

    @Override
    public void indexingPlanFilter(SearchIndexingPlanFilter filter) {
        this.getDelegate().indexingPlanFilter(filter);
    }

    private HibernateOrmSearchSession getDelegate() {
        SessionImplementor sessionImpl = HibernateOrmUtils.toSessionImplementor((EntityManager)this.session);
        return HibernateOrmSearchSession.get(this.mappingContextProvider.get(), sessionImpl);
    }
}

