/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.logging.impl;

import jakarta.transaction.Synchronization;
import java.lang.invoke.MethodHandles;
import org.hibernate.ScrollMode;
import org.hibernate.SessionFactory;
import org.hibernate.search.mapper.orm.search.loading.EntityLoadingCacheLookupStrategy;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.CategorizedLogger;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@CategorizedLogger(category="org.hibernate.search.mapper.orm", description="The main category for the Hibernate ORM mapper-specific logs.\nIt may also include logs that do not fit any other, more specific, Hibernate ORM mapper category.\n")
@MessageLogger(projectCode="HSEARCH")
public interface OrmMiscLog {
    public static final String CATEGORY_NAME = "org.hibernate.search.mapper.orm";
    public static final OrmMiscLog INSTANCE = (OrmMiscLog)LoggerFactory.make(OrmMiscLog.class, (String)"org.hibernate.search.mapper.orm", (MethodHandles.Lookup)MethodHandles.lookup());

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=36, value="Unable to guess the transaction status: not starting a JTA transaction.")
    public void cannotGuessTransactionStatus(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=39, value="Unable to properly close scroll in ScrollableResults.")
    public void unableToCloseSearcherInScrollableResult(@Cause Exception var1);

    @Message(id=276, value="No transaction active. Consider increasing the connection time-out.")
    public SearchException transactionNotActiveWhileProducingIdsForBatchIndexing();

    @Message(id=800011, value="Unable to create a SearchSession for sessions created using a different session factory. Expected: '%1$s'. In use: '%2$s'.")
    public SearchException usingDifferentSessionFactories(SessionFactory var1, SessionFactory var2);

    @Message(id=800016, value="Unable to access Hibernate ORM session: %1$s")
    public SearchException hibernateSessionAccessError(String var1, @Cause IllegalStateException var2);

    @Message(id=800017, value="Underlying Hibernate ORM Session is closed.")
    public SearchException hibernateSessionIsClosed(@Cause IllegalStateException var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=800019, value="The entity loader for '%1$s' is ignoring the cache lookup strategy '%2$s', because document IDs are distinct from entity IDs and thus cannot be used for persistence context or second level cache lookups.")
    public void skippingPreliminaryCacheLookupsForNonEntityIdEntityLoader(String var1, EntityLoadingCacheLookupStrategy var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=800020, value="The entity loader for '%1$s' is ignoring the second-level cache even though it was instructed to use it, because caching is not enabled for this entity type.")
    public void skippingSecondLevelCacheLookupsForNonCachedEntityTypeEntityLoader(String var1);

    @Message(id=800021, value="Unable to access Hibernate ORM session factory: %1$s")
    public SearchException hibernateSessionFactoryAccessError(String var1, @Cause IllegalStateException var2);

    @Message(id=800023, value="Unable to process entities for indexing before transaction completion: %1$s")
    public SearchException synchronizationBeforeTransactionFailure(String var1, @Cause Throwable var2);

    @Message(id=800024, value="Unable to index documents for indexing after transaction completion: %1$s")
    public SearchException synchronizationAfterTransactionFailure(String var1, @Cause Throwable var2);

    @Message(id=800025, value="Unable to handle transaction: %1$s")
    public SearchException transactionHandlingException(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=800035, value="Unable to shut down Hibernate Search:")
    public void shutdownFailed(@Cause Throwable var1);

    @Message(id=800036, value="Cannot use scroll() with scroll mode '%1$s' with Hibernate Search queries: only ScrollMode.FORWARDS_ONLY is supported.")
    public SearchException canOnlyUseScrollWithScrollModeForwardsOnly(ScrollMode var1);

    @Message(id=800037, value="Cannot scroll backwards with Hibernate Search scrolls: they are forwards-only. Ensure you always increment the scroll position, and never decrement it.")
    public SearchException cannotScrollBackwards();

    @Message(id=800038, value="Cannot set the scroll position relative to the end with Hibernate Search scrolls. Ensure you always pass a positive number to setRowNumber().")
    public SearchException cannotSetScrollPositionRelativeToEnd();

    @Message(id=800039, value="Cannot use this ScrollableResults instance: it is closed.")
    public SearchException cannotUseClosedScrollableResults();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=800056, value="Ignoring unrecognized query hint [%s]")
    public void ignoringUnrecognizedQueryHint(String var1);

    @Message(id=800057, value="Cannot set the fetch size of Hibernate Search ScrollableResults after having created them. If you want to define the size of batches for entity loading, set loading options when defining the query instead, for example with .loading(o -> o.fetchSize(50)). See the reference documentation for more information.")
    public SearchException cannotSetFetchSize();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=800127, value="TransactionFactory does not require a TransactionManager: don't wrap in a JTA transaction")
    public void transactionManagerNotRequired();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=800128, value="No TransactionManager found, do not start a surrounding JTA transaction")
    public void transactionManagerNotFound();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=800129, value="No Transaction in progress, needs to start a JTA transaction")
    public void noInProgressTransaction();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=800130, value="Transaction in progress, no need to start a JTA transaction")
    public void transactionAlreadyInProgress();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=800131, value="Transaction's afterCompletion is expected to be executed through the AfterTransactionCompletionProcess interface, ignoring: %s")
    public void syncAdapterIgnoringAfterCompletion(Synchronization var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=800132, value="Transaction's beforeCompletion() phase already been processed, ignoring: %s")
    public void syncAdapterIgnoringBeforeCompletionAlreadyExecuted(Synchronization var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=800133, value="Transaction's afterCompletion() phase already been processed, ignoring: %s")
    public void syncAdapterIgnoringAfterCompletionAlreadyExecuted(Synchronization var1);
}

