/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.loading.impl;

import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.query.QueryFlushMode;
import org.hibernate.search.mapper.orm.common.spi.TransactionHelper;
import org.hibernate.search.mapper.orm.loading.impl.HibernateOrmMassLoadingContext;
import org.hibernate.search.mapper.orm.loading.spi.HibernateOrmQueryLoader;
import org.hibernate.search.mapper.pojo.loading.spi.PojoMassEntityLoader;
import org.hibernate.search.mapper.pojo.loading.spi.PojoMassEntitySink;

public final class HibernateOrmMassEntityLoader<E, I>
implements PojoMassEntityLoader<I> {
    private static final String ID_PARAMETER_NAME = "ids";
    private final HibernateOrmQueryLoader<E, ?> typeQueryLoader;
    private final HibernateOrmMassLoadingContext options;
    private final PojoMassEntitySink<E> sink;
    private final SessionImplementor session;
    private final TransactionHelper transactionHelper;

    public HibernateOrmMassEntityLoader(HibernateOrmQueryLoader<E, ?> typeGroupLoader, HibernateOrmMassLoadingContext options, PojoMassEntitySink<E> sink, SessionImplementor session) {
        this.typeQueryLoader = typeGroupLoader;
        this.options = options;
        this.sink = sink;
        this.session = session;
        this.transactionHelper = new TransactionHelper(session.getSessionFactory(), null);
    }

    public void close() {
        this.session.close();
    }

    public void load(List<I> identifiers) throws InterruptedException {
        this.transactionHelper.begin((SharedSessionContractImplementor)this.session);
        try {
            this.sink.accept(this.typeQueryLoader.uniquePropertyIsTheEntityId() ? this.multiLoad(identifiers) : this.queryByIds(identifiers));
            this.session.clear();
        }
        catch (Exception e) {
            this.transactionHelper.rollbackSafely((SharedSessionContractImplementor)this.session, e);
            throw e;
        }
        this.transactionHelper.commit((SharedSessionContractImplementor)this.session);
    }

    private List<E> multiLoad(List<I> identifiers) {
        return this.typeQueryLoader.createMultiIdentifierLoadAccess(this.session).with(this.options.cacheMode()).with(LockOptions.NONE).multiLoad(identifiers);
    }

    private List<E> queryByIds(List<I> identifiers) {
        return this.typeQueryLoader.createLoadingQuery(this.session, ID_PARAMETER_NAME).setParameter(ID_PARAMETER_NAME, identifiers).setCacheMode(this.options.cacheMode()).setLockOptions(LockOptions.NONE).setCacheable(false).setQueryFlushMode(QueryFlushMode.NO_FLUSH).setFetchSize(identifiers.size()).list();
    }
}

