/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.bootstrap.impl;

import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.search.engine.environment.classpath.spi.AggregatedClassLoader;
import org.hibernate.search.engine.environment.classpath.spi.ClassResolver;
import org.hibernate.search.engine.environment.classpath.spi.DefaultClassResolver;
import org.hibernate.search.engine.environment.classpath.spi.DefaultResourceResolver;
import org.hibernate.search.engine.environment.classpath.spi.DefaultServiceResolver;
import org.hibernate.search.engine.environment.classpath.spi.ResourceResolver;
import org.hibernate.search.engine.environment.classpath.spi.ServiceResolver;

final class HibernateOrmClassLoaderServiceClassAndResourceAndServiceResolver
implements ClassResolver,
ResourceResolver,
ServiceResolver {
    private final ClassLoaderService hibernateClassLoaderService;
    private final ClassResolver internalClassResolver;
    private final ResourceResolver internalResourceResolver;
    private final ServiceResolver internalServiceResolver;

    HibernateOrmClassLoaderServiceClassAndResourceAndServiceResolver(ClassLoaderService hibernateClassLoaderService) {
        this.hibernateClassLoaderService = hibernateClassLoaderService;
        AggregatedClassLoader aggregatedClassLoader = AggregatedClassLoader.createDefault();
        this.internalClassResolver = DefaultClassResolver.create((AggregatedClassLoader)aggregatedClassLoader);
        this.internalResourceResolver = DefaultResourceResolver.create((AggregatedClassLoader)aggregatedClassLoader);
        this.internalServiceResolver = DefaultServiceResolver.create((AggregatedClassLoader)aggregatedClassLoader);
    }

    public Class<?> classForName(String className) {
        try {
            return this.hibernateClassLoaderService.classForName(className);
        }
        catch (LinkageError | ClassLoadingException e) {
            return this.internalClassResolver.classForName(className);
        }
    }

    public Package packageForName(String packageName) {
        Package pakcage = null;
        try {
            pakcage = this.hibernateClassLoaderService.packageForNameOrNull(packageName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (pakcage == null) {
            pakcage = this.internalClassResolver.packageForName(packageName);
        }
        return pakcage;
    }

    public URL locateResource(String resourceName) {
        URL url = null;
        try {
            url = this.hibernateClassLoaderService.locateResource(resourceName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (url == null) {
            url = this.internalClassResolver.locateResource(resourceName);
        }
        return url;
    }

    public InputStream locateResourceStream(String name) {
        InputStream in = this.hibernateClassLoaderService.locateResourceStream(name);
        if (in == null) {
            in = this.internalResourceResolver.locateResourceStream(name);
        }
        return in;
    }

    public <T> Collection<T> loadJavaServices(Class<T> serviceContract) {
        Collection servicesFromORMCLassLoader = this.hibernateClassLoaderService.loadJavaServices(serviceContract);
        Iterable servicesFromLocalClassLoader = this.internalServiceResolver.loadJavaServices(serviceContract);
        LinkedHashMap combined = new LinkedHashMap();
        this.addAllServices(servicesFromORMCLassLoader, combined);
        this.addAllServices(servicesFromLocalClassLoader, combined);
        return combined.values();
    }

    private <T> void addAllServices(Iterable<T> services, Map<String, T> combined) {
        for (T service : services) {
            combined.put(service.getClass().getName(), service);
        }
    }
}

