/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.automaticindexing.session.impl;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.engine.backend.work.execution.OperationSubmitter;
import org.hibernate.search.engine.common.EntityReference;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.mapper.orm.automaticindexing.session.AutomaticIndexingSynchronizationConfigurationContext;
import org.hibernate.search.mapper.orm.automaticindexing.session.AutomaticIndexingSynchronizationStrategy;
import org.hibernate.search.mapper.orm.work.SearchIndexingPlanExecutionReport;
import org.hibernate.search.mapper.pojo.work.IndexingPlanSynchronizationStrategy;
import org.hibernate.search.mapper.pojo.work.IndexingPlanSynchronizationStrategyConfigurationContext;

public class DelegatingAutomaticIndexingSynchronizationStrategy
implements AutomaticIndexingSynchronizationStrategy {
    private final IndexingPlanSynchronizationStrategy delegate;

    public DelegatingAutomaticIndexingSynchronizationStrategy(IndexingPlanSynchronizationStrategy delegate) {
        this.delegate = delegate;
    }

    @Override
    public void apply(final AutomaticIndexingSynchronizationConfigurationContext context) {
        this.delegate.apply(new IndexingPlanSynchronizationStrategyConfigurationContext(){

            public void documentCommitStrategy(DocumentCommitStrategy strategy) {
                context.documentCommitStrategy(strategy);
            }

            public void documentRefreshStrategy(DocumentRefreshStrategy strategy) {
                context.documentRefreshStrategy(strategy);
            }

            public void indexingFutureHandler(Consumer<? super CompletableFuture<? extends org.hibernate.search.mapper.pojo.work.SearchIndexingPlanExecutionReport>> handler) {
                context.indexingFutureHandler((CompletableFuture<SearchIndexingPlanExecutionReport> report) -> handler.accept((CompletableFuture<? extends org.hibernate.search.mapper.pojo.work.SearchIndexingPlanExecutionReport>)report.thenApply(HibernateOrmDelegatingSearchIndexingPlanExecutionReport::new)));
            }

            public FailureHandler failureHandler() {
                return context.failureHandler();
            }

            public void operationSubmitter(OperationSubmitter operationSubmitter) {
                context.operationSubmitter(operationSubmitter);
            }
        });
    }

    public IndexingPlanSynchronizationStrategy delegate() {
        return this.delegate;
    }

    private static class HibernateOrmDelegatingSearchIndexingPlanExecutionReport
    implements org.hibernate.search.mapper.pojo.work.SearchIndexingPlanExecutionReport {
        private final SearchIndexingPlanExecutionReport report;

        private HibernateOrmDelegatingSearchIndexingPlanExecutionReport(SearchIndexingPlanExecutionReport report) {
            this.report = report;
        }

        public Optional<Throwable> throwable() {
            return this.report.throwable();
        }

        public List<? extends EntityReference> failingEntities() {
            return this.report.failingEntities();
        }
    }
}

