/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.logging.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.CategorizedLogger;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@CategorizedLogger(category="org.hibernate.search.deprecation.mapper.orm", description="Logs related to the usage of deprecated configuration properties\nor configuration property values specific to the Hibernate ORM mapper.\n")
@MessageLogger(projectCode="HSEARCH")
public interface DeprecationLog {
    public static final String CATEGORY_NAME = "org.hibernate.search.deprecation.mapper.orm";
    public static final DeprecationLog INSTANCE = (DeprecationLog)LoggerFactory.make(DeprecationLog.class, (String)"org.hibernate.search.deprecation.mapper.orm", (MethodHandles.Lookup)MethodHandles.lookup());

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=800053, value="Configuration property '%1$s' is deprecated; use '%2$s' instead.")
    public void deprecatedPropertyUsedInsteadOfNew(String var1, String var2);

    @Message(id=800122, value="Both '%1$s' and '%2$s' are configured. Use only '%1$s' to set the indexing plan synchronization strategy. ")
    public SearchException bothNewAndOldConfigurationPropertiesForIndexingPlanSyncAreUsed(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=800123, value="Configuration property '%1$s' is deprecated; use '%2$s' instead.")
    public void automaticIndexingSynchronizationStrategyIsDeprecated(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=800125, value="Configuration property '%1$s' is deprecated. This setting will be removed in a future version. There will be no alternative provided to replace it. After the removal of this property in a future version, a dirty check will always be performed when considering whether to trigger reindexing.")
    public void automaticIndexingEnableDirtyCheckIsDeprecated(String var1);

    @Message(id=800126, value="Both '%1$s' and '%2$s' are configured. Use only '%2$s' to enable indexing listeners. ")
    public SearchException bothNewAndOldConfigurationPropertiesForIndexingListenersAreUsed(String var1, String var2);
}

