/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.bootstrap.impl;

import java.util.Map;
import java.util.Optional;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.models.spi.ClassDetailsRegistry;
import org.hibernate.resource.beans.container.spi.BeanContainer;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.search.engine.Version;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.AllAwareConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertyChecker;
import org.hibernate.search.engine.common.spi.SearchIntegration;
import org.hibernate.search.engine.common.spi.SearchIntegrationEnvironment;
import org.hibernate.search.engine.common.spi.SearchIntegrationPartialBuildState;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.environment.bean.spi.BeanProvider;
import org.hibernate.search.engine.environment.classpath.spi.ClassResolver;
import org.hibernate.search.engine.environment.classpath.spi.ResourceResolver;
import org.hibernate.search.engine.environment.classpath.spi.ServiceResolver;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingInitiator;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingKey;
import org.hibernate.search.mapper.orm.bootstrap.impl.HibernateOrmBeanContainerBeanProvider;
import org.hibernate.search.mapper.orm.bootstrap.impl.HibernateOrmClassLoaderServiceClassAndResourceAndServiceResolver;
import org.hibernate.search.mapper.orm.bootstrap.impl.HibernateOrmIntegrationPartialBuildState;
import org.hibernate.search.mapper.orm.bootstrap.spi.HibernateOrmIntegrationBooterBehavior;
import org.hibernate.search.mapper.orm.common.impl.HibernateOrmUtils;
import org.hibernate.search.mapper.orm.coordination.impl.CoordinationConfigurationContextImpl;
import org.hibernate.search.mapper.orm.logging.impl.ConfigurationLog;
import org.hibernate.search.mapper.orm.logging.impl.VersionLog;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmMappingInitiator;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmMappingKey;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.reflect.spi.ValueHandleFactory;
import org.hibernate.service.Service;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceContributor;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.jboss.jandex.IndexView;

public abstract class HibernateSearchPreIntegrationService
implements Service,
AutoCloseable {
    private static final ConfigurationProperty<Boolean> ENABLED = ConfigurationProperty.forKey((String)"hibernate.search.enabled").asBoolean().withDefault((Object)true).build();
    private static final ConfigurationProperty<Boolean> LOG_VERSION = ConfigurationProperty.forKey((String)"jboss.log-version").asBoolean().withDefault((Object)true).build();
    private final ConfigurationPropertyChecker propertyChecker;
    private final ConfigurationPropertySource rawPropertySource;
    private CoordinationConfigurationContextImpl coordinationStrategyConfiguration;

    protected HibernateSearchPreIntegrationService(ConfigurationPropertyChecker propertyChecker, ConfigurationPropertySource rawPropertySource) {
        this.propertyChecker = propertyChecker;
        this.rawPropertySource = rawPropertySource;
    }

    @Override
    public final void close() throws Exception {
        try (Closer closer = new Closer();){
            this.doClose((Closer<RuntimeException>)closer);
        }
    }

    protected void doClose(Closer<RuntimeException> closer) {
        closer.push(CoordinationConfigurationContextImpl::close, (Object)this.coordinationStrategyConfiguration);
    }

    ConfigurationPropertySource rawPropertySource() {
        return this.rawPropertySource;
    }

    abstract ConfigurationPropertySource propertySource();

    public CoordinationConfigurationContextImpl coordinationStrategyConfiguration() {
        if (this.coordinationStrategyConfiguration == null) {
            this.coordinationStrategyConfiguration = CoordinationConfigurationContextImpl.configure(this.propertySource(), this.beanResolver());
        }
        return this.coordinationStrategyConfiguration;
    }

    ConfigurationPropertyChecker propertyChecker() {
        return this.propertyChecker;
    }

    abstract BeanResolver beanResolver();

    abstract HibernateOrmIntegrationPartialBuildState doBootFirstPhase(Metadata var1, IndexView var2, ClassDetailsRegistry var3, ValueHandleFactory var4);

    static class PreBooted
    extends HibernateSearchPreIntegrationService {
        private final ConfigurationPropertySource propertySource;
        private final HibernateOrmIntegrationPartialBuildState partialBuildState;

        PreBooted(ConfigurationPropertyChecker propertyChecker, ConfigurationPropertySource rawPropertySource, HibernateOrmIntegrationPartialBuildState partialBuildState) {
            super(propertyChecker, rawPropertySource);
            this.propertySource = SearchIntegrationEnvironment.rootPropertySource((ConfigurationPropertySource)rawPropertySource, (BeanResolver)partialBuildState.beanResolver());
            this.partialBuildState = partialBuildState;
        }

        @Override
        protected void doClose(Closer<RuntimeException> closer) {
            super.doClose(closer);
            closer.push(HibernateOrmIntegrationPartialBuildState::closeOnFailure, (Object)this.partialBuildState);
        }

        @Override
        ConfigurationPropertySource propertySource() {
            return this.propertySource;
        }

        @Override
        BeanResolver beanResolver() {
            return this.partialBuildState.beanResolver();
        }

        @Override
        HibernateOrmIntegrationPartialBuildState doBootFirstPhase(Metadata metadata, IndexView jandexIndex, ClassDetailsRegistry classDetailsRegistry, ValueHandleFactory valueHandleFactory) {
            return this.partialBuildState;
        }
    }

    static class NotBooted
    extends HibernateSearchPreIntegrationService {
        private final SearchIntegrationEnvironment environment;
        private final ServiceRegistry serviceRegistry;

        NotBooted(ConfigurationPropertyChecker propertyChecker, ConfigurationPropertySource rawPropertySource, SearchIntegrationEnvironment environment, ServiceRegistry serviceRegistry) {
            super(propertyChecker, rawPropertySource);
            this.environment = environment;
            this.serviceRegistry = serviceRegistry;
        }

        @Override
        protected void doClose(Closer<RuntimeException> closer) {
            super.doClose(closer);
            closer.push(SearchIntegrationEnvironment::close, (Object)this.environment);
        }

        @Override
        ConfigurationPropertySource propertySource() {
            return this.environment.propertySource();
        }

        @Override
        BeanResolver beanResolver() {
            return this.environment.beanResolver();
        }

        @Override
        HibernateOrmIntegrationPartialBuildState doBootFirstPhase(Metadata metadata, IndexView jandexIndex, ClassDetailsRegistry classDetailsRegistry, ValueHandleFactory valueHandleFactory) {
            HibernateOrmMappingInitiator mappingInitiator = null;
            SearchIntegrationPartialBuildState searchIntegrationPartialBuildState = null;
            try {
                SearchIntegration.Builder builder = SearchIntegration.builder((SearchIntegrationEnvironment)this.environment);
                HibernateOrmMappingKey mappingKey = new HibernateOrmMappingKey();
                mappingInitiator = HibernateOrmMappingInitiator.create(metadata, jandexIndex, classDetailsRegistry, valueHandleFactory, this.serviceRegistry);
                builder.addMappingInitiator((MappingKey)mappingKey, (MappingInitiator)mappingInitiator);
                searchIntegrationPartialBuildState = builder.prepareBuild();
                return new HibernateOrmIntegrationPartialBuildState(searchIntegrationPartialBuildState, mappingKey);
            }
            catch (RuntimeException e) {
                ((SuppressingCloser)new SuppressingCloser((Throwable)e).push(HibernateOrmMappingInitiator::closeOnFailure, mappingInitiator)).push(SearchIntegrationPartialBuildState::closeOnFailure, searchIntegrationPartialBuildState);
                throw e;
            }
        }
    }

    public static class Initiator
    implements StandardServiceInitiator<HibernateSearchPreIntegrationService> {
        private boolean initiated = false;

        public Class<HibernateSearchPreIntegrationService> getServiceInitiated() {
            return HibernateSearchPreIntegrationService.class;
        }

        public HibernateSearchPreIntegrationService initiateService(Map configurationValues, ServiceRegistryImplementor registry) {
            if (this.initiated) {
                return null;
            }
            this.initiated = true;
            if (((Boolean)LOG_VERSION.get((ConfigurationPropertySource)AllAwareConfigurationPropertySource.system())).booleanValue()) {
                VersionLog.INSTANCE.version(Version.versionString());
            }
            ConfigurationPropertyChecker propertyChecker = ConfigurationPropertyChecker.create();
            ConfigurationPropertySource propertySource = propertyChecker.wrap(AllAwareConfigurationPropertySource.fromMap((Map)HibernateOrmUtils.getServiceOrFail((ServiceRegistry)registry, ConfigurationService.class).getSettings()));
            boolean enabled = (Boolean)ENABLED.get(propertySource);
            Optional<HibernateOrmIntegrationPartialBuildState> partialBuildState = HibernateOrmIntegrationPartialBuildState.get(propertySource);
            if (!enabled) {
                ConfigurationLog.INSTANCE.hibernateSearchDisabled();
                partialBuildState.ifPresent(HibernateOrmIntegrationPartialBuildState::closeOnFailure);
                return null;
            }
            if (partialBuildState.isPresent()) {
                return new PreBooted(propertyChecker, propertySource, partialBuildState.get());
            }
            return HibernateOrmIntegrationBooterBehavior.bootFirstPhase(() -> {
                SearchIntegrationEnvironment environment = Initiator.createEnvironment(propertyChecker, propertySource, registry);
                return new NotBooted(propertyChecker, propertySource, environment, (ServiceRegistry)registry);
            });
        }

        public static SearchIntegrationEnvironment createEnvironment(ConfigurationPropertyChecker propertyChecker, ConfigurationPropertySource propertySource, ServiceRegistryImplementor registry) {
            HibernateOrmBeanContainerBeanProvider beanProvider = null;
            SearchIntegrationEnvironment.Builder environmentBuilder = SearchIntegrationEnvironment.builder((ConfigurationPropertySource)propertySource, (ConfigurationPropertyChecker)propertyChecker);
            try {
                BeanContainer beanContainer;
                ClassLoaderService hibernateOrmClassLoaderService = HibernateOrmUtils.getServiceOrFail((ServiceRegistry)registry, ClassLoaderService.class);
                Optional<ManagedBeanRegistry> managedBeanRegistryService = HibernateOrmUtils.getServiceOrEmpty((ServiceRegistry)registry, ManagedBeanRegistry.class);
                HibernateOrmClassLoaderServiceClassAndResourceAndServiceResolver classAndResourceAndServiceResolver = new HibernateOrmClassLoaderServiceClassAndResourceAndServiceResolver(hibernateOrmClassLoaderService);
                environmentBuilder.classResolver((ClassResolver)classAndResourceAndServiceResolver).resourceResolver((ResourceResolver)classAndResourceAndServiceResolver).serviceResolver((ServiceResolver)classAndResourceAndServiceResolver);
                if (managedBeanRegistryService.isPresent() && (beanContainer = managedBeanRegistryService.get().getBeanContainer()) != null) {
                    beanProvider = new HibernateOrmBeanContainerBeanProvider(beanContainer);
                    environmentBuilder.beanProvider((BeanProvider)beanProvider);
                }
                return environmentBuilder.build();
            }
            catch (RuntimeException e) {
                new SuppressingCloser((Throwable)e).push(BeanProvider::close, beanProvider);
                throw e;
            }
        }
    }

    public static class Contributor
    implements ServiceContributor {
        public void contribute(StandardServiceRegistryBuilder serviceRegistryBuilder) {
            serviceRegistryBuilder.addInitiator((StandardServiceInitiator)new Initiator());
        }
    }
}

