/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.tenancy.spi;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.OptionalConfigurationProperty;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.tenancy.spi.TenancyMode;
import org.hibernate.search.mapper.orm.cfg.HibernateOrmMapperSettings;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.pojo.tenancy.TenantIdentifierConverter;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.impl.Contracts;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class TenancyConfiguration
implements AutoCloseable {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final OptionalConfigurationProperty<List<String>> MULTI_TENANCY_TENANT_IDS = ConfigurationProperty.forKey((String)"multi_tenancy.tenant_ids").asString().multivalued().validate(value -> Contracts.assertNotNullNorEmpty((Collection)value, (String)"value")).build();
    private static final ConfigurationProperty<BeanReference<? extends TenantIdentifierConverter>> MULTI_TENANCY_TENANT_IDENTIFIER_CONVERTER = ConfigurationProperty.forKey((String)"multi_tenancy.tenant_identifier_converter").asBeanReference(TenantIdentifierConverter.class).withDefault(HibernateOrmMapperSettings.Defaults.MULTI_TENANCY_TENANT_IDENTIFIER_CONVERTER).build();
    private final Optional<Set<String>> tenantIds;
    private final String tenantIdsConfigurationPropertyKey;
    private final BeanHolder<? extends TenantIdentifierConverter> tenantIdentifierConverter;

    public static TenancyConfiguration create(BeanResolver beanResolver, TenancyMode tenancyMode, ConfigurationPropertySource configurationPropertySource) {
        String tenantIdsConfigurationPropertyKey = MULTI_TENANCY_TENANT_IDS.resolveOrRaw(configurationPropertySource);
        BeanHolder tenantIdentifierConverter = (BeanHolder)MULTI_TENANCY_TENANT_IDENTIFIER_CONVERTER.getAndTransform(configurationPropertySource, arg_0 -> ((BeanResolver)beanResolver).resolve(arg_0));
        switch (tenancyMode) {
            case SINGLE_TENANCY: {
                return new TenancyConfiguration((BeanHolder<? extends TenantIdentifierConverter>)tenantIdentifierConverter, Optional.of(Collections.emptySet()), tenantIdsConfigurationPropertyKey);
            }
            case MULTI_TENANCY: {
                return new TenancyConfiguration((BeanHolder<? extends TenantIdentifierConverter>)tenantIdentifierConverter, MULTI_TENANCY_TENANT_IDS.getAndMap(configurationPropertySource, LinkedHashSet::new), tenantIdsConfigurationPropertyKey);
            }
        }
        throw new AssertionFailure("Unknown tenancy mode: " + tenancyMode);
    }

    public static TenancyConfiguration create(BeanHolder<? extends TenantIdentifierConverter> tenantIdentifierConverter, Optional<Set<String>> tenantIds, String tenantIdsConfigurationPropertyKey) {
        return new TenancyConfiguration(tenantIdentifierConverter, tenantIds, tenantIdsConfigurationPropertyKey);
    }

    private TenancyConfiguration(BeanHolder<? extends TenantIdentifierConverter> tenantIdentifierConverter, Optional<Set<String>> tenantIds, String tenantIdsConfigurationPropertyKey) {
        this.tenantIdentifierConverter = tenantIdentifierConverter;
        this.tenantIds = tenantIds;
        this.tenantIdsConfigurationPropertyKey = tenantIdsConfigurationPropertyKey;
    }

    public Set<String> tenantIdsOrFail() {
        return this.tenantIds.orElseThrow(() -> log.missingTenantIdConfiguration(this.tenantIdsConfigurationPropertyKey));
    }

    public SearchException invalidTenantId(String tenantId) {
        return log.invalidTenantId(tenantId, this.tenantIds.orElse(Collections.emptySet()), this.tenantIdsConfigurationPropertyKey);
    }

    public Object convert(String tenantIdentifier) {
        return ((TenantIdentifierConverter)this.tenantIdentifierConverter.get()).fromStringValue(tenantIdentifier);
    }

    public String convert(Object tenantIdentifier) {
        return ((TenantIdentifierConverter)this.tenantIdentifierConverter.get()).toStringValue(tenantIdentifier);
    }

    @Override
    public void close() {
        if (this.tenantIdentifierConverter != null) {
            this.tenantIdentifierConverter.close();
        }
    }
}

