/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.model.impl;

import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.search.mapper.pojo.mapping.spi.PojoRawTypeIdentifierResolver;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.model.spi.PojoRuntimeIntrospector;

public class HibernateOrmRuntimeIntrospector
implements PojoRuntimeIntrospector {
    private final PojoRawTypeIdentifierResolver typeIdentifierResolver;
    private final SharedSessionContractImplementor sessionImplementor;

    public HibernateOrmRuntimeIntrospector(PojoRawTypeIdentifierResolver typeIdentifierResolver, SharedSessionContractImplementor sessionImplementor) {
        this.typeIdentifierResolver = typeIdentifierResolver;
        this.sessionImplementor = sessionImplementor;
    }

    public <T> PojoRawTypeIdentifier<? extends T> detectEntityType(T entity) {
        if (entity == null) {
            return null;
        }
        String entityName = this.sessionImplementor.bestGuessEntityName(entity);
        if (entityName == null) {
            return null;
        }
        return (PojoRawTypeIdentifier)this.typeIdentifierResolver.typeIdentifierBySecondaryEntityName().getOrNull((Object)entityName);
    }

    public Object unproxy(Object value) {
        if (value instanceof HibernateProxy) {
            HibernateProxy proxy = (HibernateProxy)value;
            LazyInitializer lazyInitializer = proxy.getHibernateLazyInitializer();
            Object initialized = lazyInitializer.getImplementation(this.sessionImplementor);
            if (initialized != null) {
                return initialized;
            }
            return this.sessionImplementor.getPersistenceContext().unproxyAndReassociate((Object)proxy);
        }
        return value;
    }

    public boolean isIgnorableDataAccessThrowable(Throwable throwable) {
        return throwable instanceof HibernateException || throwable instanceof AssertionFailure;
    }
}

